/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.util;

import java.math.BigInteger;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.PropertySet;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkplugUtil {
    private static Logger logger = LoggerFactory.getLogger(SparkplugUtil.class.getName());

    public static int getQualityCode(Metric metric) {
        PropertySet propertySet = metric.getProperties();
        logger.trace("Getting properties for {} with value: {}", (Object)metric.getName(), (Object)(propertySet != null && propertySet.getPropertyMap() != null ? propertySet.getPropertyMap().toString() : "null"));
        if (propertySet != null && propertySet.getPropertyValue("Quality") != null) {
            return (Integer)propertySet.getPropertyValue("Quality").getValue();
        }
        logger.trace("No incoming quality for {} - assuming good", (Object)metric.getName());
        return 192;
    }

    public static Long getBdSequenceNumber(SparkplugBPayload payload) throws Exception {
        for (Metric metric : payload.getMetrics()) {
            if (!"bdSeq".equals(metric.getName())) continue;
            return SparkplugUtil.convertSeqNumber(metric.getValue());
        }
        return null;
    }

    public static long convertSeqNumber(Object sequenceNumber) {
        if (sequenceNumber instanceof Long) {
            return (Long)sequenceNumber;
        }
        if (sequenceNumber instanceof BigInteger) {
            return ((BigInteger)sequenceNumber).longValue();
        }
        if (sequenceNumber instanceof Integer) {
            return ((Integer)sequenceNumber).longValue();
        }
        if (sequenceNumber instanceof Byte) {
            return ((Byte)sequenceNumber).longValue();
        }
        if (sequenceNumber instanceof Short) {
            return ((Short)sequenceNumber).longValue();
        }
        return (Long)sequenceNumber;
    }
}

