/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.tahu.SparkplugException;
import org.eclipse.tahu.SparkplugInvalidTypeException;
import org.eclipse.tahu.message.model.DataSet;
import org.eclipse.tahu.message.model.MetaData;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.Parameter;
import org.eclipse.tahu.message.model.PropertySet;
import org.eclipse.tahu.message.model.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateMap
extends Template {
    private static Logger logger = LoggerFactory.getLogger(TemplateMap.class.getName());
    private final Map<String, Metric> metricMap;
    private final Object mapLock = new Object();

    public TemplateMap() {
        this.metricMap = new ConcurrentHashMap<String, Metric>();
    }

    public TemplateMap(String version, String templateRef, boolean isDefinition, Map<String, Metric> metricMap, List<Parameter> parameters) {
        super(version, templateRef, isDefinition, null, parameters);
        this.metricMap = metricMap;
    }

    public TemplateMap(Template template) throws Exception {
        this.metricMap = new HashMap<String, Metric>();
        if (template != null) {
            this.setVersion(template.getVersion());
            this.setTemplateRef(template.getTemplateRef());
            this.setDefinition(template.isDefinition());
            if (template.getMetrics() != null) {
                for (Metric metric : template.getMetrics()) {
                    this.addMetric(new Metric(metric));
                }
            }
            if (template.getParameters() != null) {
                ArrayList<Parameter> parametersList = new ArrayList<Parameter>();
                for (Parameter parameter : template.getParameters()) {
                    parametersList.add(new Parameter(parameter));
                }
                super.setParameters(parametersList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Metric> getMetricMap() {
        Object object = this.mapLock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.metricMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetric(String metricName, Metric metric) {
        Object object = this.mapLock;
        synchronized (object) {
            this.metricMap.put(metricName, metric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Metric> getMetrics() {
        Object object = this.mapLock;
        synchronized (object) {
            return new ArrayList<Metric>(this.metricMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMetrics(List<Metric> metrics) {
        Object object = this.mapLock;
        synchronized (object) {
            for (Metric metric : metrics) {
                this.addMetric(metric);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetric(Metric metric) {
        Object object = this.mapLock;
        synchronized (object) {
            this.metricMap.put(metric.getName(), metric);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TemplateMap [version=");
        builder.append(super.getVersion());
        builder.append(", templateRef=");
        builder.append(super.getTemplateRef());
        builder.append(", isDefinition=");
        builder.append(super.isDefinition());
        builder.append(", metrics=");
        builder.append(this.metricMap);
        builder.append(", parameters=");
        builder.append(super.getParameters());
        builder.append("]");
        return builder.toString();
    }

    public static class CustomMetricBuilder {
        private String name;
        private Long alias;
        private Date timestamp;
        private MetricDataType dataType;
        private Boolean isHistorical;
        private Boolean isTransient;
        private MetaData metaData = null;
        private PropertySet properties = null;
        private Object value;

        public CustomMetricBuilder(Metric metric) throws SparkplugException {
            this.name = metric.getName();
            this.alias = metric.getAlias();
            this.timestamp = metric.getTimestamp();
            this.dataType = metric.getDataType();
            this.isHistorical = metric.isHistorical();
            this.isTransient = metric.isTransient();
            this.metaData = metric.getMetaData() != null ? new MetaData.MetaDataBuilder(metric.getMetaData()).createMetaData() : null;
            PropertySet propertySet = this.properties = metric.getMetaData() != null ? new PropertySet.PropertySetBuilder(metric.getProperties()).createPropertySet() : null;
            this.value = this.dataType.toIntValue() == MetricDataType.DataSet.toIntValue() ? (metric.getValue() != null ? new DataSet.DataSetBuilder((DataSet)metric.getValue()).createDataSet() : null) : (this.dataType.toIntValue() == MetricDataType.Template.toIntValue() ? (metric.getValue() != null ? new TemplateMapBuilder((TemplateMap)metric.getValue()).createTemplateMap() : null) : metric.getValue());
        }

        public Metric createMetric() throws SparkplugInvalidTypeException {
            return new Metric(this.name, this.alias, this.timestamp, this.dataType, this.isHistorical, this.isTransient, this.metaData, this.properties, this.value);
        }
    }

    public static class TemplateMapBuilder {
        private String version;
        private String templateRef;
        private boolean isDefinition;
        private Map<String, Metric> metricMap;
        private List<Parameter> parameters;

        public TemplateMapBuilder() {
            this.metricMap = new ConcurrentHashMap<String, Metric>();
            this.parameters = new ArrayList<Parameter>();
        }

        public TemplateMapBuilder(Template template) throws SparkplugException {
            this.version = template.getVersion();
            this.templateRef = template.getTemplateRef();
            this.isDefinition = template.isDefinition();
            this.metricMap = new ConcurrentHashMap<String, Metric>(template.getMetrics().size());
            for (Metric metric : template.getMetrics()) {
                logger.trace("Adding metric '{}' when converting Template to TemplateMap", (Object)metric.getName());
                this.metricMap.put(metric.getName(), new CustomMetricBuilder(metric).createMetric());
            }
            logger.trace("MetricMap after conversion: {}", (Object)this.metricMap);
            this.parameters = new ArrayList<Parameter>(template.getParameters().size());
            for (Parameter parameter : template.getParameters()) {
                this.parameters.add(new Parameter(parameter.getName(), parameter.getType(), parameter.getValue()));
            }
        }

        public TemplateMapBuilder(TemplateMap templateMap) throws SparkplugException {
            this.version = templateMap.getVersion();
            this.templateRef = templateMap.getTemplateRef();
            this.isDefinition = templateMap.isDefinition();
            this.metricMap = new ConcurrentHashMap<String, Metric>(templateMap.getMetrics().size());
            for (Metric metric : templateMap.getMetrics()) {
                this.metricMap.put(metric.getName(), new CustomMetricBuilder(metric).createMetric());
            }
            this.parameters = new ArrayList<Parameter>(templateMap.getParameters().size());
            for (Parameter parameter : templateMap.getParameters()) {
                this.parameters.add(new Parameter(parameter.getName(), parameter.getType(), parameter.getValue()));
            }
        }

        public TemplateMapBuilder version(String version) {
            this.version = version;
            return this;
        }

        public TemplateMapBuilder templateRef(String templateRef) {
            this.templateRef = templateRef;
            return this;
        }

        public TemplateMapBuilder definition(boolean isDefinition) {
            this.isDefinition = isDefinition;
            return this;
        }

        public TemplateMapBuilder addParameter(Parameter parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public TemplateMapBuilder addParameters(Collection<Parameter> parameters) {
            this.parameters.addAll(parameters);
            return this;
        }

        public TemplateMap createTemplateMap() {
            return new TemplateMap(this.version, this.templateRef, this.isDefinition, this.metricMap, this.parameters);
        }
    }
}

