/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.edge;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.tahu.SparkplugInvalidTypeException;
import org.eclipse.tahu.SparkplugParsingException;
import org.eclipse.tahu.edge.CommandCallback;
import org.eclipse.tahu.edge.CommandListener;
import org.eclipse.tahu.edge.EdgeClient;
import org.eclipse.tahu.edge.PeriodicPublisher;
import org.eclipse.tahu.edge.api.MetricHandler;
import org.eclipse.tahu.edge.sim.DataSimulator;
import org.eclipse.tahu.edge.sim.RandomDataSimulator;
import org.eclipse.tahu.message.DefaultBdSeqManager;
import org.eclipse.tahu.message.SparkplugBPayloadDecoder;
import org.eclipse.tahu.message.SparkplugBPayloadEncoder;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.MessageType;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.SparkplugBPayloadMap;
import org.eclipse.tahu.message.model.SparkplugDescriptor;
import org.eclipse.tahu.message.model.StatePayload;
import org.eclipse.tahu.message.model.Topic;
import org.eclipse.tahu.model.MqttServerDefinition;
import org.eclipse.tahu.mqtt.ClientCallback;
import org.eclipse.tahu.mqtt.MqttClientId;
import org.eclipse.tahu.mqtt.MqttServerName;
import org.eclipse.tahu.mqtt.MqttServerUrl;
import org.eclipse.tahu.util.SparkplugUtil;
import org.eclipse.tahu.util.TopicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkplugEdgeNode
implements Runnable,
MetricHandler,
ClientCallback,
CommandCallback {
    private static Logger logger = LoggerFactory.getLogger(SparkplugEdgeNode.class.getName());
    private static final String COMMAND_LISTENER_DIRECTORY = "/tmp/commands";
    private static final long COMMAND_LISTENER_POLL_RATE = 50L;
    private static final String GROUP_ID = "G2";
    private static final String EDGE_NODE_ID = "E2";
    private static final EdgeNodeDescriptor EDGE_NODE_DESCRIPTOR = new EdgeNodeDescriptor("G2", "E2");
    private static final List<String> DEVICE_IDS = Arrays.asList("D2");
    private static final List<DeviceDescriptor> DEVICE_DESCRIPTORS = Arrays.asList(new DeviceDescriptor(EDGE_NODE_DESCRIPTOR, "D2"));
    private static final String PRIMARY_HOST_ID = "IamHost";
    private static final boolean USE_ALIASES = false;
    private static final Long REBIRTH_DEBOUNCE_DELAY = 5000L;
    private static final MqttServerName MQTT_SERVER_NAME_1 = new MqttServerName("Mqtt Server One");
    private static final String MQTT_CLIENT_ID_1 = "Sparkplug-Tahu-Compatible-Impl-One";
    private static final MqttServerUrl MQTT_SERVER_URL_1 = MqttServerUrl.getMqttServerUrlSafe("tcp://localhost:1883");
    private static final String USERNAME_1 = "admin";
    private static final String PASSWORD_1 = "changeme";
    private static final MqttServerName MQTT_SERVER_NAME_2 = new MqttServerName("Mqtt Server Two");
    private static final String MQTT_CLIENT_ID_2 = "Sparkplug-Tahu-Compatible-Impl-Two";
    private static final MqttServerUrl MQTT_SERVER_URL_2 = MqttServerUrl.getMqttServerUrlSafe("tcp://localhost:1884");
    private static final String USERNAME_2 = "admin";
    private static final String PASSWORD_2 = "changeme";
    private static final int KEEP_ALIVE_TIMEOUT = 30;
    private static final Topic NDEATH_TOPIC = new Topic("spBv1.0", "G2", "E2", MessageType.NDEATH);
    private static final List<MqttServerDefinition> mqttServerDefinitions = new ArrayList<MqttServerDefinition>();
    private CommandListener commandListener;
    private long birthBdSeq;
    private long deathBdSeq;
    private final DataSimulator dataSimulator = new RandomDataSimulator(10, (Map<SparkplugDescriptor, Integer>)new HashMap<SparkplugDescriptor, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            for (DeviceDescriptor deviceDescriptor : DEVICE_DESCRIPTORS) {
                this.put(deviceDescriptor, 50);
            }
        }
    });
    private Object clientLock = new Object();
    private EdgeClient edgeClient;
    private Thread edgeClientThread;
    private PeriodicPublisher periodicPublisher;
    private DefaultBdSeqManager defaultBdSeqManager;
    private Thread periodicPublisherThread;

    public static void main(String[] arg) {
        try {
            mqttServerDefinitions.add(new MqttServerDefinition(MQTT_SERVER_NAME_1, new MqttClientId(MQTT_CLIENT_ID_1, false), MQTT_SERVER_URL_1, "admin", "changeme", 30, NDEATH_TOPIC));
            System.out.println("Starting the Sparkplug Edge Node");
            System.out.println("\tGroup ID: G2");
            System.out.println("\tEdge Node ID: E2");
            System.out.println("\tDevice IDs: " + DEVICE_IDS);
            System.out.println("\tPrimary Host ID: IamHost");
            System.out.println("\tUsing Aliases: false");
            System.out.println("\tRebirth Debounce Delay: " + REBIRTH_DEBOUNCE_DELAY);
            for (MqttServerDefinition mqttServerDefinition : mqttServerDefinitions) {
                System.out.println("\tMQTT Server Name: " + mqttServerDefinition.getMqttServerName());
                System.out.println("\tMQTT Client ID: " + mqttServerDefinition.getMqttClientId());
                System.out.println("\tMQTT Server URL: " + mqttServerDefinition.getMqttServerUrl());
                System.out.println("\tUsername: " + mqttServerDefinition.getUsername());
                System.out.println("\tPassword: ********");
                System.out.println("\tKeep Alive Timeout: " + mqttServerDefinition.getKeepAliveTimeout());
            }
            SparkplugEdgeNode sparkplugEdgeNode = new SparkplugEdgeNode();
            Thread edgeNodeThread = new Thread(sparkplugEdgeNode);
            edgeNodeThread.start();
            Thread.sleep(360000L);
            sparkplugEdgeNode.shutdown();
        }
        catch (Exception e) {
            logger.error("Failed to run the Edge Node", e);
        }
    }

    public SparkplugEdgeNode() {
        try {
            this.defaultBdSeqManager = new DefaultBdSeqManager("SparkplugEdgeNode");
            this.birthBdSeq = this.deathBdSeq = this.defaultBdSeqManager.getNextDeathBdSeqNum();
            this.edgeClient = new EdgeClient(this, EDGE_NODE_DESCRIPTOR, DEVICE_IDS, PRIMARY_HOST_ID, false, REBIRTH_DEBOUNCE_DELAY, mqttServerDefinitions, this, null);
        }
        catch (Exception e) {
            logger.error("Failed to create the Sparkplug Edge Client", e);
        }
    }

    @Override
    public void run() {
        try {
            this.commandListener = new CommandListener(this, COMMAND_LISTENER_DIRECTORY, 50L);
            this.commandListener.start();
            this.edgeClientThread = new Thread(this.edgeClient);
            this.edgeClientThread.start();
        }
        catch (Exception e) {
            logger.error("Failed to start", e);
        }
    }

    @Override
    public Topic getDeathTopic() {
        return NDEATH_TOPIC;
    }

    @Override
    public byte[] getDeathPayloadBytes() throws Exception {
        SparkplugBPayload nDeathPayload = new SparkplugBPayload.SparkplugBPayloadBuilder().setTimestamp(new Date()).createPayload();
        this.addDeathSeqNum(nDeathPayload);
        return new SparkplugBPayloadEncoder().getBytes(nDeathPayload, true);
    }

    @Override
    public void publishBirthSequence() {
        try {
            SparkplugBPayloadMap nBirthPayload = this.dataSimulator.getNodeBirthPayload(EDGE_NODE_DESCRIPTOR);
            nBirthPayload = this.addBirthSeqNum(nBirthPayload);
            this.edgeClient.publishNodeBirth(nBirthPayload);
            for (String deviceId : DEVICE_IDS) {
                SparkplugBPayload dBirthPayload = this.dataSimulator.getDeviceBirthPayload(new DeviceDescriptor(EDGE_NODE_DESCRIPTOR, deviceId));
                this.edgeClient.publishDeviceBirth(deviceId, dBirthPayload);
            }
            this.periodicPublisher = new PeriodicPublisher(5000L, this.dataSimulator, this.edgeClient, EDGE_NODE_DESCRIPTOR, DEVICE_DESCRIPTORS);
            this.periodicPublisherThread = new Thread(this.periodicPublisher);
            this.periodicPublisherThread.start();
        }
        catch (Exception e) {
            logger.error("Failed to publish the BIRTH sequence", e);
        }
    }

    @Override
    public boolean hasMetric(SparkplugDescriptor sparkplugDescriptor, String metricName) {
        return this.dataSimulator.hasMetric(sparkplugDescriptor, metricName);
    }

    @Override
    public void shutdown() {
        logger.info("ClientCallback shutdown");
        if (this.commandListener != null) {
            this.commandListener.shutdown();
            this.commandListener = null;
        }
        if (this.periodicPublisher != null) {
            this.periodicPublisher.shutdown();
            this.periodicPublisher = null;
        }
        if (this.periodicPublisherThread != null) {
            this.periodicPublisherThread.interrupt();
            this.periodicPublisherThread = null;
        }
        if (this.edgeClient != null) {
            this.edgeClient.shutdown();
            this.edgeClient = null;
            this.edgeClientThread = null;
        }
    }

    @Override
    public void messageArrived(MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, MqttClientId clientId, String rawTopic, MqttMessage message) {
        block34: {
            SparkplugBPayload payload;
            Topic topic;
            block32: {
                logger.info("{}: ClientCallback messageArrived on topic={}", (Object)clientId, (Object)rawTopic);
                try {
                    topic = TopicUtil.parseTopic(rawTopic);
                }
                catch (SparkplugParsingException e) {
                    logger.error("Error parsing Sparkplug topic {}", (Object)rawTopic, (Object)e);
                    return;
                }
                if (rawTopic.startsWith("spBv1.0/STATE/")) {
                    try {
                        logger.info("Got STATE message: {} :: {}", (Object)rawTopic, (Object)new String(message.getPayload()));
                        ObjectMapper mapper = new ObjectMapper();
                        StatePayload statePayload = mapper.readValue(message.getPayload(), StatePayload.class);
                        this.edgeClient.handleStateMessage(topic.getHostApplicationId(), statePayload);
                    }
                    catch (Exception e) {
                        logger.error("Failed to handle STATE message with topic={} and payload={}", (Object)rawTopic, (Object)new String(message.getPayload()));
                    }
                    return;
                }
                if (!"spBv1.0".equals(TopicUtil.getSplitTopic(rawTopic)[0])) {
                    logger.warn("Message received on erroneous topic: {}", (Object)rawTopic);
                    return;
                }
                try {
                    if (!MessageType.NDEATH.equals((Object)topic.getType()) || !topic.getGroupId().equals(GROUP_ID) || !topic.getEdgeNodeId().equals(EDGE_NODE_ID)) break block32;
                    if (!this.edgeClient.isDisconnectedOrDisconnecting()) {
                        if (this.edgeClient.isConnectedToPrimaryHost()) {
                            SparkplugBPayload payload2 = new SparkplugBPayloadDecoder().buildFromByteArray(message.getPayload(), null);
                            long incomingBdSeq = SparkplugUtil.getBdSequenceNumber(payload2);
                            try {
                                if (this.birthBdSeq == incomingBdSeq) {
                                    logger.info("Got unexpected LWT for {} - publishing BIRTH sequence", (Object)EDGE_NODE_DESCRIPTOR);
                                    this.edgeClient.handleRebirthRequest(true);
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Got unexpected LWT but failed to publish a new BIRTH sequence for {}", (Object)EDGE_NODE_DESCRIPTOR);
                            }
                        } else {
                            logger.debug("Got unexpected LWT but not connected to primary host - ignoring");
                        }
                    } else {
                        logger.debug("Got expected LWT for {}", (Object)EDGE_NODE_DESCRIPTOR);
                    }
                    return;
                }
                catch (Exception e) {
                    logger.error("Failed to handle NDEATH when connected on {}", (Object)topic, (Object)e);
                    return;
                }
            }
            if (!MessageType.NCMD.equals((Object)topic.getType()) && !MessageType.DCMD.equals((Object)topic.getType())) {
                logger.debug("Ignoring unexpected incoming Sparkplug message of type {}", (Object)topic.getType());
                return;
            }
            try {
                logger.debug("Decoding Sparkplug Payload");
                SparkplugBPayloadDecoder decoder = new SparkplugBPayloadDecoder();
                payload = (SparkplugBPayload)decoder.buildFromByteArray(message.getPayload(), null);
                logger.debug("Message Timestamp: {}", (Object)payload.getTimestamp());
            }
            catch (Exception e) {
                logger.error("Failed to parse message - not acting on it", e);
                return;
            }
            if (MessageType.NCMD.equals((Object)topic.getType())) {
                try {
                    receivedMetrics = payload.getMetrics();
                    ArrayList<Metric> responseMetrics = new ArrayList<Metric>();
                    if (receivedMetrics == null || receivedMetrics.isEmpty()) break block34;
                    Date now = new Date();
                    SparkplugBPayloadMap.SparkplugBPayloadMapBuilder payloadBuilder = new SparkplugBPayloadMap.SparkplugBPayloadMapBuilder();
                    payloadBuilder.setTimestamp(now);
                    for (Metric metric : receivedMetrics) {
                        String name = metric.getName();
                        logger.debug("Node Metric Name: {}", (Object)name);
                        Object value = metric.getValue();
                        logger.debug("Metric: {} :: {} :: {}", name, value, metric.getDataType());
                        if ("Node Control/Rebirth".equals(name) && value.equals(true)) {
                            this.edgeClient.handleRebirthRequest(true);
                            continue;
                        }
                        Metric writtenMetric = this.dataSimulator.handleMetricWrite(EDGE_NODE_DESCRIPTOR, metric);
                        if (writtenMetric == null) continue;
                        responseMetrics.add(writtenMetric);
                    }
                    if (!responseMetrics.isEmpty()) {
                        logger.debug("Publishing NDATA based on NCMD message for {}", (Object)EDGE_NODE_DESCRIPTOR);
                        payloadBuilder.addMetrics(responseMetrics);
                        this.edgeClient.publishNodeData(payloadBuilder.createPayload());
                        break block34;
                    }
                    logger.warn("Received NCMD with no valid metrics to write for {}", (Object)EDGE_NODE_DESCRIPTOR);
                }
                catch (Exception e) {
                    logger.error("Error parsing NCMD", e);
                }
            } else if (MessageType.DCMD.equals((Object)topic.getType())) {
                try {
                    receivedMetrics = payload.getMetrics();
                    ArrayList<Metric> responseMetrics = new ArrayList<Metric>();
                    if (receivedMetrics != null && !receivedMetrics.isEmpty()) {
                        Date now = new Date();
                        SparkplugBPayloadMap.SparkplugBPayloadMapBuilder payloadBuilder = new SparkplugBPayloadMap.SparkplugBPayloadMapBuilder();
                        payloadBuilder.setTimestamp(now);
                        for (Metric metric : receivedMetrics) {
                            String name = metric.getName();
                            logger.debug("Device Metric Name: {}", (Object)name);
                            Object value = metric.getValue();
                            logger.debug("Metric: {} :: {} :: {}", name, value, metric.getDataType());
                            Metric writtenMetric = this.dataSimulator.handleMetricWrite(new DeviceDescriptor(EDGE_NODE_DESCRIPTOR, topic.getDeviceId()), metric);
                            if (writtenMetric == null) continue;
                            responseMetrics.add(writtenMetric);
                        }
                        if (!responseMetrics.isEmpty()) {
                            logger.debug("Publishing DDATA based on DCMD message for {}/{}", (Object)EDGE_NODE_DESCRIPTOR, (Object)topic.getDeviceId());
                            payloadBuilder.addMetrics(responseMetrics);
                            this.edgeClient.publishDeviceData(topic.getDeviceId(), payloadBuilder.createPayload());
                        } else {
                            logger.warn("Received DCMD with no valid metrics to write for {}/{}", (Object)EDGE_NODE_DESCRIPTOR, (Object)topic.getDeviceId());
                        }
                    }
                }
                catch (Throwable t) {
                    logger.error("Error parsing DCMD", t);
                }
            }
        }
    }

    @Override
    public void connectionLost(MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, MqttClientId clientId, Throwable cause) {
        logger.info("{}: ClientCallback connectionLost", (Object)clientId);
    }

    @Override
    public void connectComplete(boolean reconnect, MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, MqttClientId clientId) {
        logger.info("{}: ClientCallback connectComplete", (Object)clientId);
    }

    @Override
    public void setDeviceOffline(String deviceId) {
        this.edgeClient.publishDeviceDeath(deviceId);
    }

    @Override
    public void setDeviceOnline(String deviceId) {
        SparkplugBPayload dBirthPayload = this.dataSimulator.getDeviceBirthPayload(new DeviceDescriptor(EDGE_NODE_DESCRIPTOR, deviceId));
        this.edgeClient.publishDeviceBirth(deviceId, dBirthPayload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparkplugBPayload addDeathSeqNum(SparkplugBPayload payload) {
        Object object = this.clientLock;
        synchronized (object) {
            if (payload == null) {
                payload = new SparkplugBPayload.SparkplugBPayloadBuilder().createPayload();
            }
            if (this.deathBdSeq == 256L) {
                this.deathBdSeq = 0L;
            }
            logger.trace("Death bdSeq(before) = {}", (Object)this.deathBdSeq);
            try {
                logger.trace("Set bdSeq number in NDEATH to {}", (Object)this.deathBdSeq);
                payload.addMetric(new Metric.MetricBuilder("bdSeq", MetricDataType.Int64, (Object)this.deathBdSeq).createMetric());
                this.birthBdSeq = this.deathBdSeq++;
                this.defaultBdSeqManager.storeNextDeathBdSeqNum(this.deathBdSeq);
            }
            catch (SparkplugInvalidTypeException e) {
                logger.error("Failed to create death payload", e);
                return null;
            }
            logger.trace("Death bdSeq(after) = {}", (Object)this.deathBdSeq);
            return payload;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparkplugBPayloadMap addBirthSeqNum(SparkplugBPayloadMap nBirthPayload) {
        Object object = this.clientLock;
        synchronized (object) {
            if (nBirthPayload == null) {
                nBirthPayload = new SparkplugBPayloadMap.SparkplugBPayloadMapBuilder().createPayload();
            }
            logger.trace("Birth bdSeq(before) = {}", (Object)this.birthBdSeq);
            try {
                logger.trace("Set bdSeq number in NBIRTH to {}", (Object)this.birthBdSeq);
                nBirthPayload.addMetric(new Metric.MetricBuilder("bdSeq", MetricDataType.Int64, (Object)this.birthBdSeq).createMetric());
            }
            catch (SparkplugInvalidTypeException e) {
                logger.error("Failed to create birth payload", e);
                return null;
            }
            logger.trace("Birth bdSeq(after) = {}", (Object)this.birthBdSeq);
            return nBirthPayload;
        }
    }
}

