/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.github.victools.jsonschema.generator.AnnotationHelper;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import com.github.victools.jsonschema.generator.SchemaGeneratorGeneralConfigPart;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.module.jackson.CustomEnumDefinitionProvider;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.jackson.JsonIdentityReferenceDefinitionProvider;
import com.github.victools.jsonschema.module.jackson.JsonPropertySorter;
import com.github.victools.jsonschema.module.jackson.JsonSubTypesResolver;
import com.github.victools.jsonschema.module.jackson.JsonUnwrappedDefinitionProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class JacksonModule
implements Module {
    static final Predicate<Annotation> NESTED_ANNOTATION_CHECK = annotation -> annotation.annotationType().isAnnotationPresent(JacksonAnnotationsInside.class);
    private final Set<JacksonOption> options;
    private ObjectMapper objectMapper;
    private final Map<Class<?>, BeanDescription> beanDescriptions = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, PropertyNamingStrategy> namingStrategies = Collections.synchronizedMap(new HashMap());

    public JacksonModule() {
        this.options = Collections.emptySet();
    }

    public JacksonModule(JacksonOption ... options) {
        this.options = options == null ? Collections.emptySet() : new HashSet<JacksonOption>(Arrays.asList(options));
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        this.objectMapper = builder.getObjectMapper();
        SchemaGeneratorConfigPart<FieldScope> fieldConfigPart = builder.forFields();
        SchemaGeneratorConfigPart<MethodScope> methodConfigPart = builder.forMethods();
        this.applyToConfigBuilderPart(fieldConfigPart);
        this.applyToConfigBuilderPart(methodConfigPart);
        fieldConfigPart.withIgnoreCheck(this::shouldIgnoreField);
        methodConfigPart.withIgnoreCheck(this::shouldIgnoreMethod);
        if (!this.options.contains((Object)JacksonOption.IGNORE_PROPERTY_NAMING_STRATEGY)) {
            fieldConfigPart.withPropertyNameOverrideResolver(this::getPropertyNameOverrideBasedOnJsonNamingAnnotation);
        }
        SchemaGeneratorGeneralConfigPart generalConfigPart = builder.forTypesInGeneral();
        generalConfigPart.withDescriptionResolver(this::resolveDescriptionForType);
        boolean considerEnumJsonValue = this.options.contains((Object)JacksonOption.FLATTENED_ENUMS_FROM_JSONVALUE);
        boolean considerEnumJsonProperty = this.options.contains((Object)JacksonOption.FLATTENED_ENUMS_FROM_JSONPROPERTY);
        if (considerEnumJsonValue || considerEnumJsonProperty) {
            generalConfigPart.withCustomDefinitionProvider(new CustomEnumDefinitionProvider(considerEnumJsonValue, considerEnumJsonProperty));
        }
        if (this.options.contains((Object)JacksonOption.RESPECT_JSONPROPERTY_ORDER)) {
            generalConfigPart.withPropertySorter(new JsonPropertySorter(true));
        }
        if (this.options.contains((Object)JacksonOption.JSONIDENTITY_REFERENCE_ALWAYS_AS_ID)) {
            JsonIdentityReferenceDefinitionProvider identityReferenceDefinitionProvider = new JsonIdentityReferenceDefinitionProvider();
            generalConfigPart.withCustomDefinitionProvider(identityReferenceDefinitionProvider);
            fieldConfigPart.withCustomDefinitionProvider(identityReferenceDefinitionProvider::provideCustomPropertySchemaDefinition);
            methodConfigPart.withCustomDefinitionProvider(identityReferenceDefinitionProvider::provideCustomPropertySchemaDefinition);
        }
        this.applySubtypeResolverToConfigBuilder(generalConfigPart, fieldConfigPart, methodConfigPart);
        generalConfigPart.withCustomDefinitionProvider(new JsonUnwrappedDefinitionProvider());
    }

    private void applySubtypeResolverToConfigBuilder(SchemaGeneratorGeneralConfigPart generalConfigPart, SchemaGeneratorConfigPart<FieldScope> fieldConfigPart, SchemaGeneratorConfigPart<MethodScope> methodConfigPart) {
        boolean skipLookUpSubtypes = this.options.contains((Object)JacksonOption.SKIP_SUBTYPE_LOOKUP);
        boolean skipTypeInfoTransform = this.options.contains((Object)JacksonOption.IGNORE_TYPE_INFO_TRANSFORM);
        if (skipLookUpSubtypes && skipTypeInfoTransform) {
            return;
        }
        JsonSubTypesResolver subtypeResolver = new JsonSubTypesResolver(this.options);
        if (!skipLookUpSubtypes) {
            generalConfigPart.withSubtypeResolver(subtypeResolver);
            fieldConfigPart.withTargetTypeOverridesResolver(subtypeResolver::findTargetTypeOverrides);
            methodConfigPart.withTargetTypeOverridesResolver(subtypeResolver::findTargetTypeOverrides);
        }
        if (!skipTypeInfoTransform) {
            generalConfigPart.withCustomDefinitionProvider(subtypeResolver);
            fieldConfigPart.withCustomDefinitionProvider(subtypeResolver::provideCustomPropertySchemaDefinition);
            methodConfigPart.withCustomDefinitionProvider(subtypeResolver::provideCustomPropertySchemaDefinition);
        }
    }

    private void applyToConfigBuilderPart(SchemaGeneratorConfigPart<?> configPart) {
        configPart.withDescriptionResolver(this::resolveDescription);
        configPart.withPropertyNameOverrideResolver(this::getPropertyNameOverrideBasedOnJsonPropertyAnnotation);
        configPart.withReadOnlyCheck(this::getReadOnlyCheck);
        configPart.withWriteOnlyCheck(this::getWriteOnlyCheck);
        if (this.options.contains((Object)JacksonOption.RESPECT_JSONPROPERTY_REQUIRED)) {
            configPart.withRequiredCheck(this::getRequiredCheckBasedOnJsonPropertyAnnotation);
        }
    }

    protected String resolveDescription(MemberScope<?, ?> member) {
        JsonPropertyDescription propertyAnnotation = member.getAnnotationConsideringFieldAndGetterIfSupported(JsonPropertyDescription.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        return null;
    }

    protected String resolveDescriptionForType(TypeScope scope) {
        Class<?> rawType = scope.getType().getErasedType();
        return AnnotationHelper.resolveAnnotation(rawType, JsonClassDescription.class, NESTED_ANNOTATION_CHECK).map(JsonClassDescription::value).orElse(null);
    }

    protected String getPropertyNameOverrideBasedOnJsonPropertyAnnotation(MemberScope<?, ?> member) {
        String nameOverride;
        JsonProperty annotation = member.getAnnotationConsideringFieldAndGetter(JsonProperty.class, NESTED_ANNOTATION_CHECK);
        if (annotation != null && (nameOverride = annotation.value()) != null && !nameOverride.isEmpty() && !nameOverride.equals(member.getDeclaredName())) {
            return nameOverride;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPropertyNameOverrideBasedOnJsonNamingAnnotation(FieldScope field) {
        PropertyNamingStrategy strategy;
        Map<Class<?>, PropertyNamingStrategy> map = this.namingStrategies;
        synchronized (map) {
            strategy = this.namingStrategies.computeIfAbsent(field.getDeclaringType().getErasedType(), this::getAnnotatedNamingStrategy);
        }
        if (strategy == null) {
            return null;
        }
        return strategy.nameForField(null, null, field.getName());
    }

    private PropertyNamingStrategy getAnnotatedNamingStrategy(Class<?> declaringType) {
        return AnnotationHelper.resolveAnnotation(declaringType, JsonNaming.class, NESTED_ANNOTATION_CHECK).map(JsonNaming::value).map(strategyType -> {
            try {
                return (PropertyNamingStrategy)strategyType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException | SecurityException ex) {
                return null;
            }
        }).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final BeanDescription getBeanDescriptionForClass(ResolvedType targetType) {
        Map<Class<?>, BeanDescription> map = this.beanDescriptions;
        synchronized (map) {
            return this.beanDescriptions.computeIfAbsent(targetType.getErasedType(), type -> this.objectMapper.getSerializationConfig().introspect(this.objectMapper.getTypeFactory().constructType((Type)type)));
        }
    }

    protected boolean shouldIgnoreField(FieldScope field) {
        String declaredName;
        if (field.getAnnotationConsideringFieldAndGetterIfSupported(JsonBackReference.class, NESTED_ANNOTATION_CHECK) != null) {
            return true;
        }
        JsonUnwrapped unwrappedAnnotation = field.getAnnotationConsideringFieldAndGetterIfSupported(JsonUnwrapped.class, NESTED_ANNOTATION_CHECK);
        if (unwrappedAnnotation != null && unwrappedAnnotation.enabled()) {
            return true;
        }
        HierarchicType topMostHierarchyType = field.getDeclaringTypeMembers().allTypesAndOverrides().get(0);
        BeanDescription beanDescription = this.getBeanDescriptionForClass(topMostHierarchyType.getType());
        Set<String> ignoredProperties = this.objectMapper.getSerializationConfig().getAnnotationIntrospector().findPropertyIgnoralByName(null, beanDescription.getClassInfo()).getIgnored();
        if (ignoredProperties.contains(declaredName = field.getDeclaredName())) {
            return true;
        }
        String fieldName = field.getName();
        return beanDescription.findProperties().stream().noneMatch(propertyDefinition -> declaredName.equals(propertyDefinition.getInternalName()) || fieldName.equals(propertyDefinition.getInternalName()));
    }

    protected boolean shouldIgnoreMethod(MethodScope method) {
        FieldScope getterField = method.findGetterField();
        if (getterField == null) {
            if (method.getAnnotationConsideringFieldAndGetterIfSupported(JsonBackReference.class, NESTED_ANNOTATION_CHECK) != null) {
                return true;
            }
            JsonUnwrapped unwrapped = method.getAnnotationConsideringFieldAndGetterIfSupported(JsonUnwrapped.class, NESTED_ANNOTATION_CHECK);
            if (unwrapped != null && unwrapped.enabled()) {
                return true;
            }
        } else if (this.shouldIgnoreField(getterField)) {
            return true;
        }
        return this.options.contains((Object)JacksonOption.INCLUDE_ONLY_JSONPROPERTY_ANNOTATED_METHODS) && method.getAnnotationConsideringFieldAndGetter(JsonProperty.class, NESTED_ANNOTATION_CHECK) == null;
    }

    protected boolean getRequiredCheckBasedOnJsonPropertyAnnotation(MemberScope<?, ?> member) {
        JsonProperty jsonProperty = member.getAnnotationConsideringFieldAndGetterIfSupported(JsonProperty.class, NESTED_ANNOTATION_CHECK);
        return jsonProperty != null && jsonProperty.required();
    }

    protected boolean getReadOnlyCheck(MemberScope<?, ?> member) {
        JsonProperty jsonProperty = member.getAnnotationConsideringFieldAndGetter(JsonProperty.class, NESTED_ANNOTATION_CHECK);
        return jsonProperty != null && jsonProperty.access() == JsonProperty.Access.READ_ONLY;
    }

    protected boolean getWriteOnlyCheck(MemberScope<?, ?> member) {
        JsonProperty jsonProperty = member.getAnnotationConsideringFieldAndGetter(JsonProperty.class, NESTED_ANNOTATION_CHECK);
        return jsonProperty != null && jsonProperty.access() == JsonProperty.Access.WRITE_ONLY;
    }
}

