/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.LazyValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MethodScope
extends MemberScope<ResolvedMethod, Method> {
    private final LazyValue<FieldScope> getterField = new LazyValue<FieldScope>(this::doFindGetterField);

    protected MethodScope(ResolvedMethod method, MemberScope.DeclarationDetails declarationDetails, MemberScope.OverrideDetails overrideDetails, TypeContext context) {
        super(method, declarationDetails, overrideDetails, context);
    }

    public MethodScope withOverriddenType(ResolvedType overriddenType) {
        MemberScope.OverrideDetails overrideDetails = new MemberScope.OverrideDetails(overriddenType, this.getOverriddenName(), this.getFakeContainerItemIndex());
        return new MethodScope((ResolvedMethod)this.getMember(), this.getDeclarationDetails(), overrideDetails, this.getContext());
    }

    public MethodScope withOverriddenName(String overriddenName) {
        MemberScope.OverrideDetails overrideDetails = new MemberScope.OverrideDetails(this.getOverriddenType(), overriddenName, this.getFakeContainerItemIndex());
        return new MethodScope((ResolvedMethod)this.getMember(), this.getDeclarationDetails(), overrideDetails, this.getContext());
    }

    public MethodScope asFakeContainerItemScope() {
        return (MethodScope)super.asFakeContainerItemScope();
    }

    public boolean isVoid() {
        return this.getType() == null;
    }

    public int getArgumentCount() {
        return ((ResolvedMethod)this.getMember()).getArgumentCount();
    }

    public List<ResolvedType> getArgumentTypes() {
        return IntStream.range(0, this.getArgumentCount()).mapToObj(((ResolvedMethod)this.getMember())::getArgumentType).collect(Collectors.toList());
    }

    public FieldScope findGetterField() {
        return this.getterField.get();
    }

    private FieldScope doFindGetterField() {
        if (this.getType() == null || this.getArgumentCount() > 0) {
            return null;
        }
        if (!this.isPublic()) {
            return null;
        }
        String methodName = this.getDeclaredName();
        Set possibleFieldNames = Stream.of("get", "is").flatMap(prefix -> MethodScope.getPossibleFieldNames(prefix, methodName)).collect(Collectors.toSet());
        if (possibleFieldNames.isEmpty()) {
            return null;
        }
        return Stream.of(this.getDeclaringTypeMembers().getMemberFields()).filter(memberField -> possibleFieldNames.contains(memberField.getName())).findFirst().map(field -> this.getContext().createFieldScope((ResolvedField)field, this.getDeclarationDetails())).orElse(null);
    }

    private static Stream<String> getPossibleFieldNames(String prefix, String methodName) {
        if (!methodName.startsWith(prefix) || prefix.length() == methodName.length()) {
            return Stream.of(new String[0]);
        }
        Stream.Builder<String> possibleFieldNames = Stream.builder();
        String methodNameWithoutPrefix = methodName.substring(prefix.length());
        if (Character.isUpperCase(methodNameWithoutPrefix.charAt(0))) {
            possibleFieldNames.add(methodNameWithoutPrefix.substring(0, 1).toLowerCase() + methodNameWithoutPrefix.substring(1));
            if ("is".equals(prefix)) {
                possibleFieldNames.add(methodName);
            }
        }
        if (methodNameWithoutPrefix.length() > 1 && Character.isUpperCase(methodNameWithoutPrefix.charAt(1))) {
            possibleFieldNames.add(methodNameWithoutPrefix);
        }
        return possibleFieldNames.build();
    }

    public boolean isGetter() {
        return this.findGetterField() != null;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        A annotation = super.getAnnotation(annotationClass, considerOtherAnnotation);
        if (annotation == null) {
            List<Annotation> annotationList = Arrays.asList(((Method)this.getRawMember()).getAnnotatedReturnType().getAnnotations());
            annotation = this.getContext().getAnnotationFromList(annotationClass, annotationList, considerOtherAnnotation);
        }
        return annotation;
    }

    @Override
    public <A extends Annotation> A getContainerItemAnnotation(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        AnnotatedType annotatedReturnType = ((Method)this.getRawMember()).getAnnotatedReturnType();
        return this.getContext().getTypeParameterAnnotation(annotationClass, considerOtherAnnotation, annotatedReturnType, this.getFakeContainerItemIndex());
    }

    @Override
    public <A extends Annotation> A getAnnotationConsideringFieldAndGetter(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        FieldScope associatedField;
        A annotation = this.getAnnotation(annotationClass, considerOtherAnnotation);
        if (annotation == null && (associatedField = this.findGetterField()) != null) {
            annotation = associatedField.getAnnotation(annotationClass, considerOtherAnnotation);
        }
        return annotation;
    }

    @Override
    public <A extends Annotation> A getContainerItemAnnotationConsideringFieldAndGetter(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        FieldScope associatedField;
        A annotation = this.getContainerItemAnnotation(annotationClass, considerOtherAnnotation);
        if (annotation == null && (associatedField = this.findGetterField()) != null) {
            annotation = ((MemberScope)associatedField).getContainerItemAnnotation(annotationClass, considerOtherAnnotation);
        }
        return annotation;
    }

    @Override
    protected String doGetSchemaPropertyName() {
        String result = !this.getContext().isDerivingFieldsFromArgumentFreeMethods() || this.getArgumentCount() > 0 ? this.getName() + this.getArgumentTypes().stream().map(this.getContext()::getMethodPropertyArgumentTypeDescription).collect(Collectors.joining(", ", "(", ")")) : (this.getOverriddenName() == null ? this.deriveFieldName() : this.getName());
        return result;
    }

    private String deriveFieldName() {
        String methodName = this.getDeclaredName();
        Optional<String> possibleFieldName = Stream.of("get", "is").filter(methodName::startsWith).map(prefix -> methodName.substring(prefix.length())).filter(name -> !name.isEmpty()).findFirst();
        if (!possibleFieldName.isPresent()) {
            return methodName + "()";
        }
        String methodNameWithoutPrefix = possibleFieldName.get();
        if (Character.isUpperCase(methodNameWithoutPrefix.charAt(1))) {
            return methodNameWithoutPrefix;
        }
        return Character.toLowerCase(methodNameWithoutPrefix.charAt(0)) + methodNameWithoutPrefix.substring(1);
    }
}

