/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tahu.SparkplugInvalidTypeException;
import org.eclipse.tahu.message.model.DataSet;
import org.eclipse.tahu.message.model.File;
import org.eclipse.tahu.message.model.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricDataType {
    private static final Logger logger = LoggerFactory.getLogger(MetricDataType.class.getName());
    public static final MetricDataType Int8 = new MetricDataType("Int8", 1, Byte.class);
    public static final MetricDataType Int16 = new MetricDataType("Int16", 2, Short.class);
    public static final MetricDataType Int32 = new MetricDataType("Int32", 3, Integer.class);
    public static final MetricDataType Int64 = new MetricDataType("Int64", 4, Long.class);
    public static final MetricDataType UInt8 = new MetricDataType("UInt8", 5, Short.class);
    public static final MetricDataType UInt16 = new MetricDataType("UInt16", 6, Integer.class);
    public static final MetricDataType UInt32 = new MetricDataType("UInt32", 7, Long.class);
    public static final MetricDataType UInt64 = new MetricDataType("UInt64", 8, BigInteger.class);
    public static final MetricDataType Float = new MetricDataType("Float", 9, Float.class);
    public static final MetricDataType Double = new MetricDataType("Double", 10, Double.class);
    public static final MetricDataType Boolean = new MetricDataType("Boolean", 11, Boolean.class);
    public static final MetricDataType String = new MetricDataType("String", 12, String.class);
    public static final MetricDataType DateTime = new MetricDataType("DateTime", 13, Date.class);
    public static final MetricDataType Text = new MetricDataType("Text", 14, String.class);
    public static final MetricDataType UUID = new MetricDataType("UUID", 15, String.class);
    public static final MetricDataType DataSet = new MetricDataType("DataSet", 16, DataSet.class);
    public static final MetricDataType Bytes = new MetricDataType("Bytes", 17, byte[].class);
    public static final MetricDataType File = new MetricDataType("File", 18, File.class);
    public static final MetricDataType Template = new MetricDataType("Template", 19, Template.class);
    public static final MetricDataType Int8Array = new MetricDataType("Int8Array", 22, Byte[].class);
    public static final MetricDataType Int16Array = new MetricDataType("Int16Array", 23, Short[].class);
    public static final MetricDataType Int32Array = new MetricDataType("Int32Array", 24, Integer[].class);
    public static final MetricDataType Int64Array = new MetricDataType("Int64Array", 25, Long[].class);
    public static final MetricDataType UInt8Array = new MetricDataType("UInt8Array", 26, Short[].class);
    public static final MetricDataType UInt16Array = new MetricDataType("UInt16Array", 27, Integer[].class);
    public static final MetricDataType UInt32Array = new MetricDataType("UInt32Array", 28, Long[].class);
    public static final MetricDataType UInt64Array = new MetricDataType("UInt64Array", 29, BigInteger[].class);
    public static final MetricDataType FloatArray = new MetricDataType("FloatArray", 30, Float[].class);
    public static final MetricDataType DoubleArray = new MetricDataType("DoubleArray", 31, Double[].class);
    public static final MetricDataType BooleanArray = new MetricDataType("BooleanArray", 32, Boolean[].class);
    public static final MetricDataType StringArray = new MetricDataType("StringArray", 33, String[].class);
    public static final MetricDataType DateTimeArray = new MetricDataType("DateTimeArray", 34, Date[].class);
    public static final MetricDataType Unknown = new MetricDataType("Unknown", 0, Object.class);
    protected static final Map<String, MetricDataType> types = new HashMap<String, MetricDataType>();
    @JsonInclude
    @JsonValue
    private final String type;
    @JsonIgnore
    private int intValue = 0;
    @JsonIgnore
    private Class<?> clazz = null;

    public MetricDataType() {
        this.type = null;
    }

    public MetricDataType(String type) {
        this.type = type;
        this.intValue = types.get(type).toIntValue();
        this.clazz = types.get(type).getClazz();
    }

    public MetricDataType(MetricDataType metricDataType) {
        this.type = metricDataType.getType();
        this.intValue = types.get(this.type).toIntValue();
        this.clazz = types.get(this.type).getClazz();
    }

    protected MetricDataType(String type, int intValue, Class<?> clazz) {
        this.type = type;
        this.intValue = intValue;
        this.clazz = clazz;
    }

    public void checkType(Object value) throws SparkplugInvalidTypeException {
        if (value != null && !this.clazz.isAssignableFrom(value.getClass())) {
            logger.warn("Failed type check - expected " + this.clazz + " != actual " + (value != null ? value.getClass().toString() : "null"));
            throw new SparkplugInvalidTypeException(value.getClass());
        }
    }

    public int toIntValue() {
        return this.intValue;
    }

    public static MetricDataType fromInteger(int i) {
        switch (i) {
            case 1: {
                return Int8;
            }
            case 2: {
                return Int16;
            }
            case 3: {
                return Int32;
            }
            case 4: {
                return Int64;
            }
            case 5: {
                return UInt8;
            }
            case 6: {
                return UInt16;
            }
            case 7: {
                return UInt32;
            }
            case 8: {
                return UInt64;
            }
            case 9: {
                return Float;
            }
            case 10: {
                return Double;
            }
            case 11: {
                return Boolean;
            }
            case 12: {
                return String;
            }
            case 13: {
                return DateTime;
            }
            case 14: {
                return Text;
            }
            case 15: {
                return UUID;
            }
            case 16: {
                return DataSet;
            }
            case 17: {
                return Bytes;
            }
            case 18: {
                return File;
            }
            case 19: {
                return Template;
            }
            case 22: {
                return Int8Array;
            }
            case 23: {
                return Int16Array;
            }
            case 24: {
                return Int32Array;
            }
            case 25: {
                return Int64Array;
            }
            case 26: {
                return UInt8Array;
            }
            case 27: {
                return UInt16Array;
            }
            case 28: {
                return UInt32Array;
            }
            case 29: {
                return UInt64Array;
            }
            case 30: {
                return FloatArray;
            }
            case 31: {
                return DoubleArray;
            }
            case 32: {
                return BooleanArray;
            }
            case 33: {
                return StringArray;
            }
            case 34: {
                return DateTimeArray;
            }
        }
        return Unknown;
    }

    public String getType() {
        return this.type;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.intValue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricDataType other = (MetricDataType)obj;
        return this.intValue == other.intValue;
    }

    public String toString() {
        return this.type;
    }

    static {
        types.put("Int8", Int8);
        types.put("Int16", Int16);
        types.put("Int32", Int32);
        types.put("Int64", Int64);
        types.put("UInt8", UInt8);
        types.put("UInt16", UInt16);
        types.put("UInt32", UInt32);
        types.put("UInt64", UInt64);
        types.put("Float", Float);
        types.put("Double", Double);
        types.put("Boolean", Boolean);
        types.put("String", String);
        types.put("DateTime", DateTime);
        types.put("Text", Text);
        types.put("UUID", UUID);
        types.put("DataSet", DataSet);
        types.put("Bytes", Bytes);
        types.put("File", File);
        types.put("Template", Template);
        types.put("Int8Array", Int8Array);
        types.put("Int16Array", Int16Array);
        types.put("Int32Array", Int32Array);
        types.put("Int64Array", Int64Array);
        types.put("UInt8Array", UInt8Array);
        types.put("UInt16Array", UInt16Array);
        types.put("UInt32Array", UInt32Array);
        types.put("UInt64Array", UInt64Array);
        types.put("FloatArray", FloatArray);
        types.put("DoubleArray", DoubleArray);
        types.put("BooleanArray", BooleanArray);
        types.put("StringArray", StringArray);
        types.put("DateTimeArray", DateTimeArray);
        types.put("Unknown", Unknown);
    }
}

