/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import org.eclipse.tahu.json.FileSerializer;

@JsonIgnoreProperties(value={"fileName"})
@JsonSerialize(using=FileSerializer.class)
public class File {
    private String fileName;
    private byte[] bytes;

    public File() {
    }

    public File(String fileName, byte[] bytes) {
        this.fileName = fileName == null ? null : fileName.replace("/", System.getProperty("file.separator")).replace("\\", System.getProperty("file.separator"));
        this.bytes = Arrays.copyOf(bytes, bytes.length);
    }

    public File(File file) {
        this(file.getFileName(), file.getBytes());
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("File [fileName=");
        builder.append(this.fileName);
        builder.append(", bytes=");
        builder.append(Arrays.toString(this.bytes));
        builder.append("]");
        return builder.toString();
    }
}

