/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Base64;
import org.eclipse.tahu.message.model.File;
import org.eclipse.tahu.message.model.MetaData;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;

public class MetricDeserializer
extends StdDeserializer<Metric>
implements ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    private final JsonDeserializer<?> defaultDeserializer;

    protected MetricDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(Metric.class);
        this.defaultDeserializer = defaultDeserializer;
    }

    @Override
    public Metric deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Metric metric = (Metric)this.defaultDeserializer.deserialize(parser, ctxt);
        if (metric.getDataType().equals(MetricDataType.File)) {
            MetaData metaData = metric.getMetaData();
            String fileName = metaData == null ? null : metaData.getFileName();
            File file = new File(fileName, Base64.getDecoder().decode((String)metric.getValue()));
            metric.setValue(file);
        }
        return metric;
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        ((ResolvableDeserializer)((Object)this.defaultDeserializer)).resolve(ctxt);
    }
}

