/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.edge;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.eclipse.tahu.edge.CommandCallback;
import org.eclipse.tahu.exception.TahuErrorCode;
import org.eclipse.tahu.exception.TahuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandListener
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(CommandListener.class.getName());
    private static final String SET_DEVICE_OFFLINE = "Set device offline ";
    private static final String SET_DEVICE_ONLINE = "Set device online ";
    private ScheduledExecutorService executor;
    private CommandCallback commandCallback;
    private File fileDirectory;
    private long scanRate;

    public CommandListener(CommandCallback commandCallback, String fileDirectoryPath, long scanRate) {
        this.commandCallback = commandCallback;
        this.fileDirectory = new File(fileDirectoryPath);
        this.scanRate = scanRate;
    }

    public void start() throws TahuException {
        if (!this.fileDirectory.exists()) {
            logger.info("Creating file command listener directory at {}", (Object)this.fileDirectory.getPath());
            this.fileDirectory.mkdirs();
        } else if (!this.fileDirectory.isDirectory()) {
            throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "The specified directory '{}' is not a directory");
        }
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleWithFixedDelay(this, 0L, this.scanRate, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Override
    public void run() {
        try {
            Set fileNames = Stream.of(this.fileDirectory.listFiles()).filter(file -> !file.isDirectory()).map(File::getName).collect(Collectors.toSet());
            if (fileNames != null && !fileNames.isEmpty()) {
                for (String fileName : fileNames) {
                    String deviceId;
                    fileName = this.fileDirectory.getAbsolutePath() + FileSystems.getDefault().getSeparator() + fileName;
                    logger.info("Found file: {}", (Object)fileName);
                    File commandFile = new File(fileName);
                    String fileContents = FileUtils.readFileToString(commandFile, StandardCharsets.UTF_8);
                    if (fileContents != null && fileContents.startsWith(SET_DEVICE_OFFLINE)) {
                        deviceId = fileContents.replace(SET_DEVICE_OFFLINE, "");
                        this.commandCallback.setDeviceOffline(deviceId);
                        commandFile.delete();
                        continue;
                    }
                    if (fileContents != null && fileContents.startsWith(SET_DEVICE_ONLINE)) {
                        deviceId = fileContents.replace(SET_DEVICE_ONLINE, "");
                        this.commandCallback.setDeviceOnline(deviceId);
                        commandFile.delete();
                        continue;
                    }
                    logger.error("Failed to handle input file {}", (Object)fileName);
                }
            }
        }
        catch (Exception e) {
            logger.error("File scanning in the Comamnd Worker failed", e);
        }
    }
}

