/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.Property;
import org.eclipse.tahu.message.model.PropertySet;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.Template;
import org.eclipse.tahu.message.model.TemplateMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkplugBPayloadMap
extends SparkplugBPayload {
    private static Logger logger = LoggerFactory.getLogger(SparkplugBPayloadMap.class.getName());
    private final ConcurrentHashMap<String, Metric> metricMap;
    private final Object mapLock = new Object();

    public SparkplugBPayloadMap() {
        this.metricMap = new ConcurrentHashMap();
    }

    public SparkplugBPayloadMap(Date timestamp, List<Metric> metrics, long seq, String uuid, byte[] body) {
        super(timestamp, null, seq, uuid, body);
        this.metricMap = new ConcurrentHashMap();
        for (Metric metric : metrics) {
            this.metricMap.put(metric.getName(), metric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetric(Metric metric) {
        Object object = this.mapLock;
        synchronized (object) {
            this.metricMap.put(metric.getName(), metric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetric(int index, Metric metric) {
        Object object = this.mapLock;
        synchronized (object) {
            this.metricMap.put(metric.getName(), metric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetrics(List<Metric> metrics) {
        Object object = this.mapLock;
        synchronized (object) {
            for (Metric metric : metrics) {
                this.addMetric(metric);
            }
        }
    }

    @Override
    public Metric removeMetric(int index) {
        logger.error("removeMetric(int index) isn't supported by the SparkplugBPayloadMap");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMetric(Metric metric) {
        Object object = this.mapLock;
        synchronized (object) {
            if (metric != null) {
                return this.removeMetric(metric.getName());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMetric(String metricName) {
        Object object = this.mapLock;
        synchronized (object) {
            Metric removedMetric;
            return metricName != null && (removedMetric = this.metricMap.remove(metricName)) != null;
            {
            }
        }
    }

    @Override
    public List<Metric> getMetrics() {
        return new ArrayList<Metric>(this.metricMap.values());
    }

    @Override
    @JsonIgnore
    public Integer getMetricCount() {
        return this.metricMap.size();
    }

    @Override
    public void setMetrics(List<Metric> metrics) {
        this.metricMap.clear();
        for (Metric metric : metrics) {
            this.metricMap.put(metric.getName(), metric);
        }
    }

    public Metric getMetric(String metricName) {
        return this.metricMap.get(metricName);
    }

    public void updateMetricValue(String newMetricName, Metric newMetric, List<Property<?>> customProperties) {
        if (newMetric == null) {
            logger.info("Metric '{}' is null during update - removing from cache", (Object)newMetricName);
            this.metricMap.put(newMetricName, null);
            return;
        }
        Metric existingMetric = this.metricMap.get(newMetricName);
        try {
            if (existingMetric != null) {
                if (newMetric.getDataType() == MetricDataType.Template && newMetric.getValue() != null) {
                    TemplateMap templateMap = null;
                    if (TemplateMap.class.isAssignableFrom(existingMetric.getValue().getClass())) {
                        templateMap = (TemplateMap)existingMetric.getValue();
                    } else {
                        templateMap = new TemplateMap((Template)existingMetric.getValue());
                        existingMetric.setValue(templateMap);
                    }
                    this.updateTemplateMetricValues(templateMap, newMetric, customProperties);
                } else {
                    existingMetric.setValue(newMetric.getValue());
                }
                this.handleProps(existingMetric, newMetric, customProperties);
                logger.trace("Updated metric in the map: {}", (Object)existingMetric);
            } else {
                logger.trace("Adding new metric to cache when updating: {}", (Object)newMetric);
                this.metricMap.put(newMetricName, newMetric);
            }
        }
        catch (Exception e) {
            logger.error("Failed to update metric value for {}: {} with customProps={}", newMetricName, newMetric, customProperties, e);
        }
    }

    private void updateTemplateMetricValues(TemplateMap existingTemplateMap, Metric newMetric, List<Property<?>> customProperties) {
        try {
            Template newTemplate = (Template)newMetric.getValue();
            List<Metric> newMemberMetrics = newTemplate.getMetrics();
            if (newMemberMetrics != null && !newMemberMetrics.isEmpty()) {
                for (Metric newMemberMetric : newMemberMetrics) {
                    Metric existingMetric = existingTemplateMap.getMetricMap().get(newMemberMetric.getName());
                    if (newMemberMetric.getDataType() == MetricDataType.Template && newMemberMetric.getValue() != null) {
                        TemplateMap templateMap = null;
                        if (TemplateMap.class.isAssignableFrom(existingMetric.getValue().getClass())) {
                            templateMap = (TemplateMap)existingMetric.getValue();
                        } else {
                            templateMap = new TemplateMap((Template)existingMetric.getValue());
                            existingMetric.setValue(templateMap);
                        }
                        this.updateTemplateMetricValues(templateMap, newMemberMetric, customProperties);
                    } else {
                        existingTemplateMap.getMetricMap().get(newMemberMetric.getName()).setValue(newMemberMetric.getValue());
                    }
                    this.handleProps(existingMetric, newMemberMetric, customProperties);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to update Template metric value for {}: {} with customProps={}", newMetric.getName(), newMetric, customProperties, e);
        }
    }

    private void handleProps(Metric existingMetric, Metric newMetric, List<Property<?>> customProperties) {
        PropertySet props = existingMetric.getProperties();
        if (newMetric.getProperties() != null && newMetric.getProperties().getPropertyValue("Quality") != null) {
            if (props == null) {
                props = new PropertySet();
                existingMetric.setProperties(props);
            }
            props.setProperty("Quality", newMetric.getProperties().getPropertyValue("Quality"));
        } else if (props != null) {
            props.remove("Quality");
        }
        existingMetric.setTimestamp(newMetric.getTimestamp());
        if (customProperties != null && !customProperties.isEmpty()) {
            for (Property<?> customProperty : customProperties) {
                if (newMetric.getProperties() == null || newMetric.getProperties().getPropertyValue(customProperty.getName()) == null) continue;
                if (props == null) {
                    props = new PropertySet();
                    existingMetric.setProperties(props);
                }
                props.setProperty(customProperty.getName(), newMetric.getProperties().getPropertyValue(customProperty.getName()));
            }
        }
    }

    public void updateMetricTimestamps(Date date) {
        for (Metric metric : this.metricMap.values()) {
            metric.setTimestamp(date);
            if (metric.getDataType() != MetricDataType.Template || metric.getValue() == null) continue;
            this.updateTemplateTimestamps((Template)metric.getValue(), date);
        }
    }

    private void updateTemplateTimestamps(Template template, Date date) {
        if (template != null && template.getMetrics() != null) {
            for (Metric metric : template.getMetrics()) {
                metric.setTimestamp(date);
                if (metric.getDataType() != MetricDataType.Template || metric.getValue() == null) continue;
                this.updateTemplateTimestamps((Template)metric.getValue(), date);
            }
        }
    }

    public void uptickMetricTimestamps(Date birthTimestamp) {
        for (Metric metric : this.metricMap.values()) {
            Date uptickedTimestamp = new Date(metric.getTimestamp().getTime() + 1L);
            if (birthTimestamp.before(uptickedTimestamp)) {
                metric.setTimestamp(birthTimestamp);
            } else {
                metric.setTimestamp(uptickedTimestamp);
            }
            if (metric.getDataType() != MetricDataType.Template || metric.getValue() == null) continue;
            this.uptickTemplateTimestamps((Template)metric.getValue(), birthTimestamp);
        }
    }

    private void uptickTemplateTimestamps(Template template, Date birthTimestamp) {
        if (template != null && template.getMetrics() != null) {
            for (Metric metric : template.getMetrics()) {
                Date uptickedTimestamp = new Date(metric.getTimestamp().getTime() + 1L);
                if (birthTimestamp.before(uptickedTimestamp)) {
                    metric.setTimestamp(birthTimestamp);
                } else {
                    metric.setTimestamp(uptickedTimestamp);
                }
                if (metric.getDataType() != MetricDataType.Template || metric.getValue() == null) continue;
                this.updateTemplateTimestamps((Template)metric.getValue(), birthTimestamp);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SparkplugBPayloadMap [timestamp=");
        builder.append(super.getTimestamp() != null ? Long.valueOf(super.getTimestamp().getTime()) : "null");
        builder.append(", metrics=");
        builder.append(this.getMetrics());
        builder.append(", seq=");
        builder.append(super.getSeq());
        builder.append(", uuid=");
        builder.append(super.getUuid());
        builder.append(", body=");
        builder.append(Arrays.toString(super.getBody()));
        builder.append("]");
        return builder.toString();
    }

    public static class SparkplugBPayloadMapBuilder {
        private Date timestamp;
        private List<Metric> metrics;
        private long seq = -1L;
        private String uuid;
        private byte[] body;

        public SparkplugBPayloadMapBuilder(long sequenceNumber) {
            this.seq = sequenceNumber;
            this.metrics = new ArrayList<Metric>();
        }

        public SparkplugBPayloadMapBuilder() {
            this.metrics = new ArrayList<Metric>();
        }

        public SparkplugBPayloadMapBuilder addMetric(Metric metric) {
            this.metrics.add(metric);
            return this;
        }

        public SparkplugBPayloadMapBuilder addMetrics(Collection<Metric> metrics) {
            this.metrics.addAll(metrics);
            return this;
        }

        public SparkplugBPayloadMapBuilder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SparkplugBPayloadMapBuilder setSeq(long seq) {
            this.seq = seq;
            return this;
        }

        public SparkplugBPayloadMapBuilder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public SparkplugBPayloadMapBuilder setBody(byte[] body) {
            this.body = body;
            return this;
        }

        public SparkplugBPayloadMap createPayload() {
            return new SparkplugBPayloadMap(this.timestamp, this.metrics, this.seq, this.uuid, this.body);
        }
    }
}

