/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.ProtocolStringList;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.tahu.SparkplugInvalidTypeException;
import org.eclipse.tahu.message.PayloadDecoder;
import org.eclipse.tahu.message.model.DataSet;
import org.eclipse.tahu.message.model.DataSetDataType;
import org.eclipse.tahu.message.model.File;
import org.eclipse.tahu.message.model.MetaData;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.Parameter;
import org.eclipse.tahu.message.model.ParameterDataType;
import org.eclipse.tahu.message.model.PropertyDataType;
import org.eclipse.tahu.message.model.PropertySet;
import org.eclipse.tahu.message.model.PropertyValue;
import org.eclipse.tahu.message.model.Row;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.Template;
import org.eclipse.tahu.message.model.Value;
import org.eclipse.tahu.model.MetricDataTypeMap;
import org.eclipse.tahu.protobuf.SparkplugBProto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkplugBPayloadDecoder
implements PayloadDecoder<SparkplugBPayload> {
    private static final Logger logger = LoggerFactory.getLogger(SparkplugBPayloadDecoder.class.getName());

    @Override
    public SparkplugBPayload buildFromByteArray(byte[] bytes, MetricDataTypeMap metricDataTypeMap) throws Exception {
        SparkplugBProto.Payload protoPayload = SparkplugBProto.Payload.parseFrom(bytes);
        SparkplugBPayload.SparkplugBPayloadBuilder builder = new SparkplugBPayload.SparkplugBPayloadBuilder();
        if (protoPayload.hasTimestamp()) {
            builder.setTimestamp(new Date(protoPayload.getTimestamp()));
        }
        if (protoPayload.hasSeq()) {
            builder.setSeq(protoPayload.getSeq());
        }
        for (SparkplugBProto.Payload.Metric protoMetric : protoPayload.getMetricsList()) {
            builder.addMetric(this.convertMetric(protoMetric, metricDataTypeMap, null));
        }
        if (protoPayload.hasBody()) {
            builder.setBody(protoPayload.getBody().toByteArray());
        }
        if (protoPayload.hasUuid()) {
            builder.setUuid(protoPayload.getUuid());
        }
        return builder.createPayload();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Metric convertMetric(SparkplugBProto.Payload.Metric protoMetric, MetricDataTypeMap metricDataTypeMap, String prefix) throws Exception {
        PropertySet propertySet;
        MetricDataType dataType = MetricDataType.fromInteger(protoMetric.getDatatype());
        if (dataType == MetricDataType.Unknown) {
            if (metricDataTypeMap != null && !metricDataTypeMap.isEmpty()) {
                if (protoMetric.hasName()) {
                    dataType = metricDataTypeMap.getMetricDataType(prefix != null ? prefix + protoMetric.getName() : protoMetric.getName());
                } else {
                    if (!protoMetric.hasAlias()) {
                        logger.error("Failed to decode the payload on metric: {}", (Object)protoMetric);
                        return null;
                    }
                    dataType = metricDataTypeMap.getMetricDataType(protoMetric.getAlias());
                }
            } else {
                logger.error("Failed to decode the payload on metric datatype: {}", (Object)protoMetric);
                return null;
            }
        }
        Metric.MetricBuilder metricBuilder = new Metric.MetricBuilder(protoMetric.hasName() ? protoMetric.getName() : null, dataType, this.getMetricValue(protoMetric, metricDataTypeMap, prefix)).isHistorical(protoMetric.hasIsHistorical() ? Boolean.valueOf(protoMetric.getIsHistorical()) : null).isTransient(protoMetric.hasIsTransient() ? Boolean.valueOf(protoMetric.getIsTransient()) : null).timestamp(protoMetric.hasTimestamp() ? new Date(protoMetric.getTimestamp()) : null).alias(protoMetric.hasAlias() ? Long.valueOf(protoMetric.getAlias()) : null).metaData(protoMetric.hasMetadata() ? new MetaData.MetaDataBuilder().contentType(protoMetric.getMetadata().getContentType()).size(protoMetric.getMetadata().getSize()).seq(protoMetric.getMetadata().getSeq()).fileName(protoMetric.getMetadata().getFileName()).fileType(protoMetric.getMetadata().getFileType()).md5(protoMetric.getMetadata().getMd5()).multiPart(protoMetric.getMetadata().getIsMultiPart()).description(protoMetric.getMetadata().getDescription()).createMetaData() : null);
        if (protoMetric.hasProperties()) {
            propertySet = new PropertySet.PropertySetBuilder().addProperties(this.convertProperties(protoMetric.getProperties())).createPropertySet();
            return metricBuilder.properties(propertySet).createMetric();
        }
        propertySet = null;
        return metricBuilder.properties(propertySet).createMetric();
    }

    protected Map<String, PropertyValue<? extends PropertyDataType>> convertProperties(SparkplugBProto.Payload.PropertySet decodedPropSet) throws SparkplugInvalidTypeException, Exception {
        HashMap<String, PropertyValue<? extends PropertyDataType>> map = new HashMap<String, PropertyValue<? extends PropertyDataType>>();
        ProtocolStringList keys = decodedPropSet.getKeysList();
        List<SparkplugBProto.Payload.PropertyValue> values = decodedPropSet.getValuesList();
        for (int i = 0; i < keys.size(); ++i) {
            SparkplugBProto.Payload.PropertyValue value = values.get(i);
            map.put((String)keys.get(i), new PropertyValue<PropertyDataType>(PropertyDataType.fromInteger(value.getType()), this.getPropertyValue(value)));
        }
        return map;
    }

    protected Object getPropertyValue(SparkplugBProto.Payload.PropertyValue value) throws Exception {
        PropertyDataType type = PropertyDataType.fromInteger(value.getType());
        if (value.getIsNull()) {
            return null;
        }
        if (type.toIntValue() == PropertyDataType.Boolean.toIntValue()) {
            return value.getBooleanValue();
        }
        if (type.toIntValue() == PropertyDataType.DateTime.toIntValue()) {
            return new Date(value.getLongValue());
        }
        if (type.toIntValue() == PropertyDataType.Double.toIntValue()) {
            return value.getDoubleValue();
        }
        if (type.toIntValue() == PropertyDataType.Float.toIntValue()) {
            return Float.valueOf(value.getFloatValue());
        }
        if (type.toIntValue() == PropertyDataType.Int8.toIntValue()) {
            return (byte)value.getIntValue();
        }
        if (type.toIntValue() == PropertyDataType.Int16.toIntValue()) {
            return (short)value.getIntValue();
        }
        if (type.toIntValue() == PropertyDataType.Int32.toIntValue()) {
            return value.getIntValue();
        }
        if (type.toIntValue() == PropertyDataType.Int64.toIntValue()) {
            return value.getLongValue();
        }
        if (type.toIntValue() == PropertyDataType.UInt8.toIntValue()) {
            return (short)value.getIntValue();
        }
        if (type.toIntValue() == PropertyDataType.UInt16.toIntValue()) {
            return value.getIntValue();
        }
        if (type.toIntValue() == PropertyDataType.UInt32.toIntValue()) {
            if (value.hasIntValue()) {
                return Integer.toUnsignedLong(value.getIntValue());
            }
            if (value.hasLongValue()) {
                return value.getLongValue();
            }
            throw new Exception("Failed to decode: Invalid value for UInt32 datatype " + type);
        }
        if (type.toIntValue() == PropertyDataType.UInt64.toIntValue()) {
            return new BigInteger(Long.toUnsignedString(value.getLongValue()));
        }
        if (type.toIntValue() == PropertyDataType.String.toIntValue()) {
            return value.getStringValue();
        }
        if (type.toIntValue() == PropertyDataType.Text.toIntValue()) {
            return value.getStringValue();
        }
        if (type.toIntValue() == PropertyDataType.PropertySet.toIntValue()) {
            return new PropertySet.PropertySetBuilder().addProperties(this.convertProperties(value.getPropertysetValue())).createPropertySet();
        }
        if (type.toIntValue() == PropertyDataType.PropertySetList.toIntValue()) {
            ArrayList<PropertySet> propertySetList = new ArrayList<PropertySet>();
            List<SparkplugBProto.Payload.PropertySet> list = value.getPropertysetsValue().getPropertysetList();
            for (SparkplugBProto.Payload.PropertySet decodedPropSet : list) {
                propertySetList.add(new PropertySet.PropertySetBuilder().addProperties(this.convertProperties(decodedPropSet)).createPropertySet());
            }
            return propertySetList;
        }
        if (type.toIntValue() == PropertyDataType.Unknown.toIntValue()) {
            throw new Exception("Failed to decode: Unknown PropertyDataType " + type);
        }
        throw new Exception("Failed to decode: Unknown PropertyDataType " + type);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object getMetricValue(SparkplugBProto.Payload.Metric protoMetric, MetricDataTypeMap metricDataTypeMap, String prefix) throws Exception {
        block76: {
            block75: {
                block74: {
                    Iterator<GeneratedMessageV3> iterator;
                    ArrayList<Parameter> parameters;
                    ArrayList<Metric> metrics;
                    SparkplugBProto.Payload.Template protoTemplate;
                    block73: {
                        int metricType;
                        block72: {
                            if (protoMetric.getIsNull()) {
                                return null;
                            }
                            metricType = protoMetric.getDatatype();
                            if (metricType == 0) {
                                if (metricDataTypeMap != null && !metricDataTypeMap.isEmpty()) {
                                    if (protoMetric.hasName()) {
                                        metricType = metricDataTypeMap.getMetricDataType(prefix != null ? prefix + protoMetric.getName() : protoMetric.getName()).toIntValue();
                                    } else {
                                        if (!protoMetric.hasAlias()) {
                                            logger.error("Failed to decode the payload on metric: {}", (Object)protoMetric);
                                            return null;
                                        }
                                        metricType = metricDataTypeMap.getMetricDataType(protoMetric.getAlias()).toIntValue();
                                    }
                                } else {
                                    logger.error("Failed to decode the payload on metric datatype: {}", (Object)protoMetric);
                                    return null;
                                }
                            }
                            logger.trace("For metricName={} and alias={} - handling metric type in decoder: {}", protoMetric.getName(), protoMetric.getAlias(), metricType);
                            if (metricType == MetricDataType.Boolean.toIntValue()) {
                                return protoMetric.getBooleanValue();
                            }
                            if (metricType == MetricDataType.DateTime.toIntValue()) {
                                return new Date(protoMetric.getLongValue());
                            }
                            if (metricType == MetricDataType.File.toIntValue()) {
                                String filename = protoMetric.getMetadata().getFileName();
                                byte[] fileBytes = protoMetric.getBytesValue().toByteArray();
                                return new File(filename, fileBytes);
                            }
                            if (metricType == MetricDataType.Float.toIntValue()) {
                                return Float.valueOf(protoMetric.getFloatValue());
                            }
                            if (metricType == MetricDataType.Double.toIntValue()) {
                                return protoMetric.getDoubleValue();
                            }
                            if (metricType == MetricDataType.Int8.toIntValue()) {
                                return (byte)protoMetric.getIntValue();
                            }
                            if (metricType == MetricDataType.Int16.toIntValue()) {
                                return (short)protoMetric.getIntValue();
                            }
                            if (metricType == MetricDataType.Int32.toIntValue()) {
                                return protoMetric.getIntValue();
                            }
                            if (metricType == MetricDataType.Int64.toIntValue()) {
                                return protoMetric.getLongValue();
                            }
                            if (metricType == MetricDataType.UInt8.toIntValue()) {
                                return (short)protoMetric.getIntValue();
                            }
                            if (metricType == MetricDataType.UInt16.toIntValue()) {
                                return protoMetric.getIntValue();
                            }
                            if (metricType == MetricDataType.UInt32.toIntValue()) {
                                if (protoMetric.hasIntValue()) {
                                    return Integer.toUnsignedLong(protoMetric.getIntValue());
                                }
                                if (protoMetric.hasLongValue()) {
                                    return protoMetric.getLongValue();
                                }
                                logger.error("Invalid value for UInt32 datatype");
                                throw new Exception("Failed to decode: UInt32 MetricDataType " + metricType);
                            }
                            if (metricType == MetricDataType.UInt64.toIntValue()) {
                                return new BigInteger(Long.toUnsignedString(protoMetric.getLongValue()));
                            }
                            if (metricType == MetricDataType.String.toIntValue() || metricType == MetricDataType.Text.toIntValue() || metricType == MetricDataType.UUID.toIntValue()) {
                                return protoMetric.getStringValue();
                            }
                            if (metricType == MetricDataType.Bytes.toIntValue()) {
                                return protoMetric.getBytesValue().toByteArray();
                            }
                            if (metricType == MetricDataType.DataSet.toIntValue()) {
                                SparkplugBProto.Payload.DataSet protoDataSet = protoMetric.getDatasetValue();
                                return new DataSet.DataSetBuilder(protoDataSet.getNumOfColumns()).addColumnNames(protoDataSet.getColumnsList()).addTypes(this.convertDataSetDataTypes(protoDataSet.getTypesList())).addRows(this.convertDataSetRows(protoDataSet.getRowsList(), protoDataSet.getTypesList())).createDataSet();
                            }
                            if (metricType != MetricDataType.Template.toIntValue()) break block72;
                            protoTemplate = protoMetric.getTemplateValue();
                            metrics = new ArrayList<Metric>();
                            parameters = new ArrayList<Parameter>();
                            for (SparkplugBProto.Payload.Template.Parameter protoParameter : protoTemplate.getParametersList()) {
                                String name = protoParameter.getName();
                                ParameterDataType type = ParameterDataType.fromInteger(protoParameter.getType());
                                Object value = this.getParameterValue(protoParameter);
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Setting template parameter name: " + name + ", type: " + type + ", value: " + value + ", valueType" + value.getClass());
                                }
                                parameters.add(new Parameter(name, type, value));
                            }
                            iterator = protoTemplate.getMetricsList().iterator();
                            break block73;
                        }
                        if (metricType == MetricDataType.Int8Array.toIntValue()) {
                            ByteBuffer int8ByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
                            ArrayList<Byte> int8List = new ArrayList<Byte>();
                            int8ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            while (true) {
                                if (!int8ByteBuffer.hasRemaining()) {
                                    return int8List.toArray(new Byte[0]);
                                }
                                byte value = int8ByteBuffer.get();
                                int8List.add(value);
                            }
                        }
                        if (metricType == MetricDataType.Int16Array.toIntValue()) {
                            ByteBuffer int16ByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
                            ArrayList<Short> int16List = new ArrayList<Short>();
                            int16ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            while (true) {
                                if (!int16ByteBuffer.hasRemaining()) {
                                    return int16List.toArray(new Short[0]);
                                }
                                short value = int16ByteBuffer.getShort();
                                int16List.add(value);
                            }
                        }
                        if (metricType == MetricDataType.Int32Array.toIntValue()) {
                            ByteBuffer int32ByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
                            ArrayList<Integer> int32List = new ArrayList<Integer>();
                            int32ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            while (true) {
                                if (!int32ByteBuffer.hasRemaining()) {
                                    return int32List.toArray(new Integer[0]);
                                }
                                int value = int32ByteBuffer.getInt();
                                int32List.add(value);
                            }
                        }
                        if (metricType == MetricDataType.Int64Array.toIntValue()) {
                            ByteBuffer int64ByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
                            ArrayList<Long> int64List = new ArrayList<Long>();
                            int64ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            while (true) {
                                if (!int64ByteBuffer.hasRemaining()) {
                                    return int64List.toArray(new Long[0]);
                                }
                                long value = int64ByteBuffer.getLong();
                                int64List.add(value);
                            }
                        }
                        if (metricType == MetricDataType.UInt8Array.toIntValue()) break block74;
                        if (metricType == MetricDataType.UInt16Array.toIntValue()) {
                            ByteBuffer uInt16ByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
                            ArrayList<Integer> uInt16List = new ArrayList<Integer>();
                            uInt16ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            while (true) {
                                if (!uInt16ByteBuffer.hasRemaining()) {
                                    return uInt16List.toArray(new Integer[0]);
                                }
                                short value = uInt16ByteBuffer.getShort();
                                uInt16List.add(Short.toUnsignedInt(value));
                            }
                        }
                        if (metricType == MetricDataType.UInt32Array.toIntValue()) {
                            ByteBuffer uInt32ByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
                            ArrayList<Long> uInt32List = new ArrayList<Long>();
                            uInt32ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            while (true) {
                                if (!uInt32ByteBuffer.hasRemaining()) {
                                    return uInt32List.toArray(new Long[0]);
                                }
                                int value = uInt32ByteBuffer.getInt();
                                uInt32List.add(Integer.toUnsignedLong(value));
                            }
                        }
                        if (metricType == MetricDataType.UInt64Array.toIntValue()) {
                            ByteBuffer uInt64ByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
                            ArrayList<BigInteger> uInt64List = new ArrayList<BigInteger>();
                            uInt64ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            while (true) {
                                if (!uInt64ByteBuffer.hasRemaining()) {
                                    return uInt64List.toArray(new BigInteger[0]);
                                }
                                long value = uInt64ByteBuffer.getLong();
                                uInt64List.add(new BigInteger(Long.toUnsignedString(value)));
                            }
                        }
                        if (metricType == MetricDataType.FloatArray.toIntValue()) {
                            ByteBuffer floatByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
                            ArrayList<Float> floatList = new ArrayList<Float>();
                            floatByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            while (true) {
                                if (!floatByteBuffer.hasRemaining()) {
                                    return floatList.toArray(new Float[0]);
                                }
                                float value = floatByteBuffer.getFloat();
                                floatList.add(Float.valueOf(value));
                            }
                        }
                        if (metricType == MetricDataType.DoubleArray.toIntValue()) {
                            ByteBuffer doubleByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
                            ArrayList<Double> doubleList = new ArrayList<Double>();
                            doubleByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            while (true) {
                                if (!doubleByteBuffer.hasRemaining()) {
                                    return doubleList.toArray(new Double[0]);
                                }
                                double value = doubleByteBuffer.getDouble();
                                doubleList.add(value);
                            }
                        }
                        if (metricType == MetricDataType.BooleanArray.toIntValue()) break block75;
                        if (metricType != MetricDataType.StringArray.toIntValue()) {
                            if (metricType != MetricDataType.DateTimeArray.toIntValue()) {
                                throw new Exception("Failed to decode: Unknown MetricDataType " + metricType);
                            }
                            ByteBuffer dateTimeByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
                            ArrayList<Date> dateTimeList = new ArrayList<Date>();
                            dateTimeByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            while (true) {
                                if (!dateTimeByteBuffer.hasRemaining()) {
                                    return dateTimeList.toArray(new Date[0]);
                                }
                                long value = dateTimeByteBuffer.getLong();
                                Date date = new Date(value);
                                dateTimeList.add(date);
                            }
                        }
                        break block76;
                    }
                    while (iterator.hasNext()) {
                        SparkplugBProto.Payload.Metric protoTemplateMetric = (SparkplugBProto.Payload.Metric)iterator.next();
                        Metric templateMetric = this.convertMetric(protoTemplateMetric, metricDataTypeMap, prefix != null ? prefix + protoMetric.getName() + "/" : protoMetric.getName() + "/");
                        if (logger.isTraceEnabled()) {
                            logger.trace("Setting template parameter name: " + templateMetric.getName() + ", type: " + templateMetric.getDataType() + ", value: " + templateMetric.getValue());
                        }
                        metrics.add(templateMetric);
                    }
                    Template template = new Template.TemplateBuilder().version(protoTemplate.getVersion()).templateRef(protoTemplate.getTemplateRef()).definition(protoTemplate.getIsDefinition()).addMetrics(metrics).addParameters(parameters).createTemplate();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Setting template - name: " + protoMetric.getName() + ", version: " + template.getVersion() + ", ref: " + template.getTemplateRef() + ", isDef: " + template.isDefinition() + ", metrics: " + metrics.size() + ", params: " + parameters.size());
                    }
                    return template;
                }
                ByteBuffer uInt8ByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
                ArrayList<Short> uInt8List = new ArrayList<Short>();
                uInt8ByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                while (true) {
                    if (!uInt8ByteBuffer.hasRemaining()) {
                        return uInt8List.toArray(new Short[0]);
                    }
                    byte value = uInt8ByteBuffer.get();
                    uInt8List.add(value >= 0 ? (short)value : (short)(65536 + value));
                }
            }
            ByteBuffer booleanByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
            ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
            booleanByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int numberOfBooleans = booleanByteBuffer.getInt();
            int numberOfBytes = (int)Math.ceil((double)numberOfBooleans / 8.0);
            int i = 0;
            while (true) {
                if (i >= numberOfBytes) {
                    return booleanList.toArray(new Boolean[0]);
                }
                byte nextByte = booleanByteBuffer.get();
                for (int j = 0; j < 8; ++j) {
                    if (i * 8 + j >= numberOfBooleans) continue;
                    if ((nextByte & 1 << 7 - j) > 0) {
                        booleanList.add(true);
                        continue;
                    }
                    booleanList.add(false);
                }
                ++i;
            }
        }
        ByteBuffer stringByteBuffer = ByteBuffer.wrap(protoMetric.getBytesValue().toByteArray());
        ArrayList<String> stringList = new ArrayList<String>();
        stringByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer subByteBuffer = ByteBuffer.allocate(protoMetric.getBytesValue().toByteArray().length);
        while (stringByteBuffer.hasRemaining()) {
            byte b = stringByteBuffer.get();
            if (b == 0) {
                String string = new String(subByteBuffer.array(), StandardCharsets.UTF_8);
                if (string != null && string.lastIndexOf("\u0000") == string.length() - 1) {
                    string = string.replace("\u0000", "");
                }
                stringList.add(string);
                subByteBuffer = ByteBuffer.allocate(protoMetric.getBytesValue().toByteArray().length);
                continue;
            }
            subByteBuffer.put(b);
        }
        return stringList.toArray(new String[0]);
    }

    protected Collection<Row> convertDataSetRows(List<SparkplugBProto.Payload.DataSet.Row> protoRows, List<Integer> protoTypes) throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        if (protoRows != null) {
            for (SparkplugBProto.Payload.DataSet.Row protoRow : protoRows) {
                List<SparkplugBProto.Payload.DataSet.DataSetValue> protoValues = protoRow.getElementsList();
                ArrayList values = new ArrayList();
                for (int index = 0; index < protoRow.getElementsCount(); ++index) {
                    values.add(this.convertDataSetValue(protoTypes.get(index), protoValues.get(index)));
                }
                rows.add(new Row.RowBuilder().addValues(values).createRow());
            }
        }
        return rows;
    }

    protected Collection<DataSetDataType> convertDataSetDataTypes(List<Integer> protoTypes) {
        ArrayList<DataSetDataType> types = new ArrayList<DataSetDataType>();
        for (int type : protoTypes) {
            types.add(DataSetDataType.fromInteger(type));
        }
        return types;
    }

    private Object getParameterValue(SparkplugBProto.Payload.Template.Parameter protoParameter) throws Exception {
        int type = protoParameter.getType();
        if (type == MetricDataType.Boolean.toIntValue()) {
            return protoParameter.getBooleanValue();
        }
        if (type == MetricDataType.DateTime.toIntValue()) {
            return new Date(protoParameter.getLongValue());
        }
        if (type == MetricDataType.Float.toIntValue()) {
            return Float.valueOf(protoParameter.getFloatValue());
        }
        if (type == MetricDataType.Double.toIntValue()) {
            return protoParameter.getDoubleValue();
        }
        if (type == MetricDataType.Int8.toIntValue()) {
            return (byte)protoParameter.getIntValue();
        }
        if (type == MetricDataType.Int16.toIntValue()) {
            return (short)protoParameter.getIntValue();
        }
        if (type == MetricDataType.Int32.toIntValue()) {
            return protoParameter.getIntValue();
        }
        if (type == MetricDataType.Int64.toIntValue()) {
            return protoParameter.getLongValue();
        }
        if (type == MetricDataType.UInt8.toIntValue()) {
            return (short)protoParameter.getIntValue();
        }
        if (type == MetricDataType.UInt16.toIntValue()) {
            return protoParameter.getIntValue();
        }
        if (type == MetricDataType.UInt32.toIntValue()) {
            if (protoParameter.hasIntValue()) {
                return Integer.toUnsignedLong(protoParameter.getIntValue());
            }
            if (protoParameter.hasLongValue()) {
                return protoParameter.getLongValue();
            }
            logger.error("Invalid value for UInt32 datatype");
            throw new Exception("Failed to decode: UInt32 Parameter Type " + type);
        }
        if (type == MetricDataType.UInt64.toIntValue()) {
            return new BigInteger(Long.toUnsignedString(protoParameter.getLongValue()));
        }
        if (type == MetricDataType.String.toIntValue() || type == MetricDataType.Text.toIntValue()) {
            return protoParameter.getStringValue();
        }
        throw new Exception("Failed to decode: Unknown Parameter Type " + type);
    }

    protected Value<?> convertDataSetValue(int protoType, SparkplugBProto.Payload.DataSet.DataSetValue protoValue) throws Exception {
        DataSetDataType type = DataSetDataType.fromInteger(protoType);
        if (protoType == DataSetDataType.Boolean.toIntValue()) {
            if (protoValue.hasBooleanValue()) {
                return new Value<Boolean>(type, protoValue.getBooleanValue());
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.DateTime.toIntValue()) {
            if (protoValue.hasLongValue()) {
                if (protoValue.getLongValue() == Long.MIN_VALUE) {
                    return new Value<Object>(type, null);
                }
                return new Value<Date>(type, new Date(protoValue.getLongValue()));
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.Float.toIntValue()) {
            if (protoValue.hasFloatValue()) {
                return new Value<Float>(type, Float.valueOf(protoValue.getFloatValue()));
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.Double.toIntValue()) {
            if (protoValue.hasDoubleValue()) {
                return new Value<Double>(type, protoValue.getDoubleValue());
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.Int8.toIntValue()) {
            if (protoValue.hasIntValue()) {
                return new Value<Byte>(type, (byte)protoValue.getIntValue());
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.Int16.toIntValue()) {
            if (protoValue.hasIntValue()) {
                return new Value<Short>(type, (short)protoValue.getIntValue());
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.Int32.toIntValue()) {
            if (protoValue.hasIntValue()) {
                return new Value<Integer>(type, protoValue.getIntValue());
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.Int64.toIntValue()) {
            if (protoValue.hasLongValue()) {
                return new Value<Long>(type, protoValue.getLongValue());
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.UInt8.toIntValue()) {
            if (protoValue.hasIntValue()) {
                return new Value<Short>(type, (short)protoValue.getIntValue());
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.UInt16.toIntValue()) {
            if (protoValue.hasIntValue()) {
                return new Value<Integer>(type, protoValue.getIntValue());
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.UInt32.toIntValue()) {
            if (protoValue.hasIntValue()) {
                return new Value<Long>(type, Integer.toUnsignedLong(protoValue.getIntValue()));
            }
            if (protoValue.hasLongValue()) {
                return new Value<Long>(type, protoValue.getLongValue());
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.UInt64.toIntValue()) {
            if (protoValue.hasLongValue()) {
                return new Value<BigInteger>(type, new BigInteger(Long.toUnsignedString(protoValue.getLongValue())));
            }
            return new Value<Object>(type, null);
        }
        if (protoType == DataSetDataType.String.toIntValue() || protoType == DataSetDataType.Text.toIntValue()) {
            if (protoValue.hasStringValue()) {
                if (protoValue.getStringValue().equals("null")) {
                    return new Value<Object>(type, null);
                }
                return new Value<String>(type, protoValue.getStringValue());
            }
            return new Value<Object>(type, null);
        }
        logger.error("Unknown DataSetDataType: " + protoType);
        throw new Exception("Failed to decode");
    }
}

