/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message;

import java.io.File;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.eclipse.tahu.message.BdSeqManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBdSeqManager
implements BdSeqManager {
    private static Logger logger = LoggerFactory.getLogger(DefaultBdSeqManager.class.getName());
    private static final String SPARKPLUG_DIRNAME = "Tahu_Temp_Dir";
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String BD_SEQ_NUM_FILE_NAME_PREFIX = TMP_DIR + (TMP_DIR.endsWith(FILE_SEPARATOR) ? "" : FILE_SEPARATOR) + "Tahu_Temp_Dir" + FILE_SEPARATOR;
    private final String bdSeqNumFileName;

    public DefaultBdSeqManager(String fileName) {
        this.bdSeqNumFileName = BD_SEQ_NUM_FILE_NAME_PREFIX + fileName;
    }

    @Override
    public long getNextDeathBdSeqNum() {
        try {
            logger.info("bdSeqNumFileName: {}", (Object)this.bdSeqNumFileName);
            File bdSeqNumFile = new File(this.bdSeqNumFileName);
            if (bdSeqNumFile.exists()) {
                int bdSeqNum = Integer.parseInt(FileUtils.readFileToString(bdSeqNumFile, Charset.defaultCharset().toString()));
                logger.info("Next Death bdSeq number: {}", (Object)bdSeqNum);
                return bdSeqNum;
            }
            this.storeNextDeathBdSeqNum(0L);
            return 0L;
        }
        catch (Exception e) {
            logger.error("Failed to get the bdSeq number from the persistent directory", e);
            this.storeNextDeathBdSeqNum(0L);
            return 0L;
        }
    }

    @Override
    public void storeNextDeathBdSeqNum(long bdSeqNum) {
        try {
            File bdSeqNumFile = new File(this.bdSeqNumFileName);
            FileUtils.writeStringToFile(bdSeqNumFile, Long.toString(bdSeqNum), Charset.defaultCharset().toString(), false);
        }
        catch (Exception e) {
            logger.error("Failed to write the bdSeq number to the persistent directory", e);
        }
    }
}

