/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.tahu.SparkplugException;
import org.eclipse.tahu.message.model.DataSet;
import org.eclipse.tahu.message.model.DataSetDataType;
import org.eclipse.tahu.message.model.Row;
import org.eclipse.tahu.message.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetDeserializer
extends StdDeserializer<DataSet> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DataSetDeserializer.class.getName());
    private static final String FIELD_SIZE = "numberOfColumns";
    private static final String FIELD_TYPES = "types";
    private static final String FIELD_NAMES = "columnNames";
    private static final String FIELD_ROWS = "rows";

    protected DataSetDeserializer() {
        super(DataSet.class);
    }

    protected DataSetDeserializer(Class<DataSet> clazz) {
        super(clazz);
    }

    @Override
    public DataSet deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode rowsNode;
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        long size = 0L;
        if (Integer.class.isAssignableFrom(node.get(FIELD_SIZE).numberValue().getClass())) {
            size = ((Integer)node.get(FIELD_SIZE).numberValue()).intValue();
        } else if (Long.class.isAssignableFrom(node.get(FIELD_SIZE).numberValue().getClass())) {
            size = (Long)node.get(FIELD_SIZE).numberValue();
        } else {
            logger.error("Failed to handle class type for {}: {}", (Object)FIELD_SIZE, (Object)node.get(FIELD_SIZE).numberValue().getClass());
        }
        DataSet.DataSetBuilder builder = new DataSet.DataSetBuilder(size);
        JsonNode namesNode = node.get(FIELD_NAMES);
        if (namesNode.isArray()) {
            logger.trace("namesNode: {}", (Object)namesNode);
            if (namesNode != null && namesNode.size() > 1 && namesNode.get(0).isTextual() && namesNode.get(1).isArray() && namesNode.get(0).textValue().startsWith("java.util.")) {
                for (JsonNode columnName : namesNode.get(1)) {
                    logger.trace("Adding column name: {}", (Object)columnName);
                    builder.addColumnName(columnName.textValue());
                }
            } else {
                for (JsonNode columnName : namesNode) {
                    logger.trace("Adding column name: {}", (Object)columnName.textValue());
                    builder.addColumnName(columnName.textValue());
                }
            }
        }
        JsonNode typesNode = node.get(FIELD_TYPES);
        ArrayList<DataSetDataType> typesList = new ArrayList<DataSetDataType>();
        if (typesNode.isArray()) {
            if (typesNode != null && typesNode.size() > 1 && typesNode.get(0).isTextual() && typesNode.get(1).isArray() && "java.util.ArrayList".equals(typesNode.get(0).textValue())) {
                for (JsonNode datatypeNode : typesNode.get(1)) {
                    logger.trace("Adding datatype: {}", (Object)datatypeNode.textValue());
                    typesList.add(DataSetDataType.valueOf(datatypeNode.textValue()));
                }
            } else {
                for (Iterator<JsonNode> typeNode : typesNode) {
                    logger.trace("Adding datatype: {}", (Object)((JsonNode)((Object)typeNode)).textValue());
                    typesList.add(DataSetDataType.valueOf(((JsonNode)((Object)typeNode)).textValue()));
                }
            }
            builder.addTypes(typesList);
        }
        if ((rowsNode = node.get(FIELD_ROWS)).isArray()) {
            if (rowsNode != null && rowsNode.size() > 1 && rowsNode.get(0).isTextual() && rowsNode.get(1).isArray() && "java.util.ArrayList".equals(rowsNode.get(0).textValue())) {
                for (JsonNode subRowsNode : rowsNode.get(1)) {
                    logger.trace("SUB FIELD_ROWS: {}", (Object)subRowsNode);
                    if (subRowsNode == null || subRowsNode.size() <= 1 || !subRowsNode.get(0).isTextual() || !subRowsNode.get(1).isArray() || !"java.util.ArrayList".equals(subRowsNode.get(0).textValue())) continue;
                    ArrayList values = new ArrayList();
                    JsonNode dataRowNode = subRowsNode.get(1);
                    int i = 0;
                    while ((long)i < size) {
                        JsonNode value = dataRowNode.get(i);
                        DataSetDataType type = (DataSetDataType)typesList.get(i);
                        Value<?> valueFromNode = this.getValueFromNode(value, type);
                        logger.trace("Adding value to data row: {} with type={}", (Object)value.toString(), (Object)type);
                        values.add(valueFromNode);
                        ++i;
                    }
                    logger.trace("Adding data row: {}", (Object)values);
                    builder.addRow(new Row(values));
                }
            } else {
                for (JsonNode rowNode : rowsNode) {
                    ArrayList values = new ArrayList();
                    int i = 0;
                    while ((long)i < size) {
                        JsonNode value = rowNode.get(i);
                        logger.trace("Adding value to row: {}", (Object)value.toString());
                        DataSetDataType type = (DataSetDataType)typesList.get(i);
                        values.add(this.getValueFromNode(value, type));
                        ++i;
                    }
                    logger.trace("Adding row: {}", (Object)values);
                    builder.addRow(new Row(values));
                }
            }
        }
        try {
            return builder.createDataSet();
        }
        catch (SparkplugException e) {
            logger.error("Error deserializing DataSet ", e);
            return null;
        }
    }

    private Value<?> getValueFromNode(JsonNode nodeValue, DataSetDataType type) {
        if (nodeValue.isArray() && nodeValue.size() == 2 && nodeValue.get(0).isTextual() && nodeValue.get(0).textValue().startsWith("java.")) {
            logger.debug("Getting value from array: type={} and nodeValue={}", (Object)type, (Object)nodeValue);
            nodeValue = nodeValue.get(1);
        } else {
            logger.debug("Getting value: type={} and nodeValue={}", (Object)type, (Object)nodeValue);
        }
        if (type.toIntValue() == DataSetDataType.Boolean.toIntValue()) {
            return new Value<Boolean>(type, nodeValue.asBoolean());
        }
        if (type.toIntValue() == DataSetDataType.DateTime.toIntValue()) {
            return new Value<Date>(type, new Date(nodeValue.asLong()));
        }
        if (type.toIntValue() == DataSetDataType.Double.toIntValue()) {
            return new Value<Double>(type, nodeValue.asDouble());
        }
        if (type.toIntValue() == DataSetDataType.Float.toIntValue()) {
            return new Value<Float>(type, Float.valueOf((float)nodeValue.asDouble()));
        }
        if (type.toIntValue() == DataSetDataType.Int8.toIntValue()) {
            return new Value<Byte>(type, (byte)nodeValue.asInt());
        }
        if (type.toIntValue() == DataSetDataType.Int16.toIntValue()) {
            return new Value<Short>(type, (short)nodeValue.asInt());
        }
        if (type.toIntValue() == DataSetDataType.Int32.toIntValue()) {
            return new Value<Integer>(type, nodeValue.asInt());
        }
        if (type.toIntValue() == DataSetDataType.Int64.toIntValue()) {
            return new Value<Long>(type, nodeValue.asLong());
        }
        if (type.toIntValue() == DataSetDataType.UInt8.toIntValue()) {
            return new Value<Short>(type, (short)nodeValue.asInt());
        }
        if (type.toIntValue() == DataSetDataType.UInt16.toIntValue()) {
            return new Value<Integer>(type, nodeValue.asInt());
        }
        if (type.toIntValue() == DataSetDataType.UInt32.toIntValue()) {
            return new Value<Long>(type, nodeValue.asLong());
        }
        if (type.toIntValue() == DataSetDataType.UInt64.toIntValue()) {
            return new Value<BigInteger>(type, BigInteger.valueOf(nodeValue.asLong()));
        }
        if (type.toIntValue() == DataSetDataType.String.toIntValue() || type.toIntValue() == DataSetDataType.Text.toIntValue()) {
            return new Value<String>(type, nodeValue.asText());
        }
        return null;
    }
}

