/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.mqtt;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.internal.NetworkModuleService;
import org.eclipse.tahu.exception.TahuErrorCode;
import org.eclipse.tahu.exception.TahuException;
import org.eclipse.tahu.message.model.StatePayload;
import org.eclipse.tahu.mqtt.ClientCallback;
import org.eclipse.tahu.mqtt.MqttClientId;
import org.eclipse.tahu.mqtt.MqttServerName;
import org.eclipse.tahu.mqtt.MqttServerUrl;
import org.eclipse.tahu.mqtt.RandomStartupDelay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TahuClient
implements MqttCallbackExtended {
    private static Logger logger = LoggerFactory.getLogger(TahuClient.class.getName());
    private static final long DEFAULT_CONNECT_RETRY_INTERVAL = 1000L;
    private static final long DEFAULT_CONNECT_MONITOR_INTERVAL = 10000L;
    private static final long DEFAULT_CONNECT_ATTEMPT_TIMEOUT = 30000L;
    private Thread connectRunnableThread;
    private ConnectRunnable connectRunnable;
    private long connectRetryInterval;
    private long connectAttemptTimeout;
    private ConnectingState state = new ConnectingState();
    private boolean useSparkplugStatePayload;
    private Long lastStateDeathPayloadTimestamp;
    private String birthTopic;
    private byte[] birthPayload;
    private boolean birthRetain;
    private String lwtTopic;
    private byte[] lwtPayload;
    private int lwtQoS;
    private boolean lwtRetain;
    private IMqttDeliveryToken lwtDeliveryToken;
    private Object lwtDeliveryLock = new Object();
    private MqttAsyncClient client = null;
    MqttConnectOptions connectOptions = null;
    private MqttServerUrl mqttServerUrl;
    private MqttServerName mqttServerName;
    private final MqttClientId clientId;
    private String username;
    private String password;
    private boolean cleanSession;
    private int keepAlive;
    private ClientCallback callback;
    private SortedMap<String, Integer> subscriptions = new TreeMap<String, Integer>();
    private boolean autoReconnect;
    private RandomStartupDelay randomStartupDelay;
    private int maxInFlightMessages = 10;
    private int maxTopicsPerSubscribe = 256;
    private Date connectTime;
    private Date disconnectTime;
    private Date onlineDate;
    private Date offlineDate;
    private double totalUptime;
    private double totalDowntime;
    private int connectionCount = 0;
    private boolean doLatencyCheck = false;
    private long numMesgsArrived = 0L;
    private long lastNumMesgsArrived = 0L;
    private boolean disconnectInProgress = false;
    private Object clientLock = new Object();
    private ConnectionMonitorThread connectionMonitorThread;
    private boolean trackFirstConnection = false;
    private boolean firstConnection = true;
    private boolean resubscribed = false;
    private boolean onlineState;

    public TahuClient(MqttClientId clientId, MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, String username, String password, boolean cleanSession, int keepAlive, ClientCallback callback, RandomStartupDelay randomStartupDelay, boolean onlineState) {
        this.mqttServerUrl = mqttServerUrl;
        this.mqttServerName = mqttServerName;
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.cleanSession = cleanSession;
        this.keepAlive = keepAlive;
        this.callback = callback;
        this.randomStartupDelay = randomStartupDelay;
        this.lwtRetain = false;
        this.birthRetain = false;
        this.autoReconnect = true;
        this.setConnectRetryInterval(1000L);
        this.setConnectAttemptTimeout(30000L);
        this.renewDisconnectTime();
        this.renewOnlineDate();
        this.renewOfflineDate();
        this.onlineState = onlineState;
    }

    public TahuClient(MqttClientId clientId, MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, String username, String password, boolean cleanSession, int keepAlive, ClientCallback callback, RandomStartupDelay randomStartupDelay, boolean useSparkplugStatePayload, String birthTopic, byte[] birthPayload, String lwtTopic, byte[] lwtPayload, int lwtQoS, boolean onlineState) {
        this(clientId, mqttServerName, mqttServerUrl, username, password, cleanSession, keepAlive, callback, randomStartupDelay, onlineState);
        this.setLifecycleProps(useSparkplugStatePayload, birthTopic, birthPayload, false, lwtTopic, lwtPayload, lwtQoS, false);
    }

    public TahuClient(MqttClientId clientId, MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, String username, String password, boolean cleanSession, int keepAlive, ClientCallback callback, RandomStartupDelay randomStartupDelay, boolean onlineState, boolean useSparkplugStatePayload, String birthTopic, byte[] birthPayload, boolean birthRetain, String lwtTopic, byte[] lwtPayload, int lwtQoS, boolean lwtRetain) {
        this(clientId, mqttServerName, mqttServerUrl, username, password, cleanSession, keepAlive, callback, randomStartupDelay, onlineState);
        this.setLifecycleProps(useSparkplugStatePayload, birthTopic, birthPayload, birthRetain, lwtTopic, lwtPayload, lwtQoS, lwtRetain);
    }

    private void setLifecycleProps(boolean useSparkplugStatePayload, String birthTopic, byte[] birthPayload, boolean birthRetain, String lwtTopic, byte[] lwtPayload, int lwtQoS, boolean lwtRetain) {
        this.useSparkplugStatePayload = useSparkplugStatePayload;
        this.birthTopic = birthTopic;
        this.birthPayload = birthPayload;
        this.birthRetain = birthRetain;
        this.lwtTopic = lwtTopic;
        this.lwtPayload = lwtPayload;
        this.lwtQoS = lwtQoS;
        this.lwtRetain = lwtRetain;
    }

    protected MqttConnectOptions getMqttConnectOptions() {
        return this.connectOptions;
    }

    protected void setMqttConnectOptions(MqttConnectOptions connectOptions) {
        this.connectOptions = connectOptions;
    }

    public long getNumMesgsArrived() {
        return this.numMesgsArrived;
    }

    public long getMesgsArrivedDelta() {
        long delta = this.numMesgsArrived - this.lastNumMesgsArrived;
        this.lastNumMesgsArrived = this.numMesgsArrived;
        return delta;
    }

    public void clearMesgArrivedCount() {
        this.numMesgsArrived = 0L;
        this.lastNumMesgsArrived = 0L;
    }

    public void setMaxInflightMessages(int max) {
        this.maxInFlightMessages = max;
    }

    public int getMaxInflightMessages() {
        return this.maxInFlightMessages;
    }

    public void setDoLatencyCheck(boolean state) {
        this.doLatencyCheck = state;
    }

    public boolean getDoLatencyCheck() {
        return this.doLatencyCheck;
    }

    public void clearConnectionCount() {
        this.connectionCount = 0;
    }

    public void incrementConnectionCount() {
        ++this.connectionCount;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public MqttServerUrl getMqttServerUrl() {
        return this.mqttServerUrl;
    }

    public MqttServerName getMqttServerName() {
        return this.mqttServerName;
    }

    public MqttClientId getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassord(String password) {
        this.password = password;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public Map<String, Integer> getSubscriptions() {
        return Collections.unmodifiableMap(this.subscriptions);
    }

    public int getMaxTopicsPerSubscribe() {
        return this.maxTopicsPerSubscribe;
    }

    public void setMaxTopicsPerSubscribe(int maxTopicsPerSubscribe) {
        this.maxTopicsPerSubscribe = maxTopicsPerSubscribe;
    }

    public ClientCallback getCallback() {
        return this.callback != null ? this.callback : new ClientCallback(){

            @Override
            public void shutdown() {
            }

            @Override
            public void messageArrived(MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, MqttClientId clientId, String topic, MqttMessage message) {
            }

            @Override
            public void connectionLost(MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, MqttClientId clientId, Throwable cause) {
            }

            @Override
            public void connectComplete(boolean reconnect, MqttServerName mqttServerName, MqttServerUrl mqttServerUrl, MqttClientId clientId) {
            }
        };
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public boolean getAutoReconnect() {
        return this.autoReconnect;
    }

    public String getLwtTopic() {
        return this.lwtTopic;
    }

    public void setLwtRetain(boolean retain) {
        this.lwtRetain = retain;
    }

    public boolean getLwtRetain() {
        return this.lwtRetain;
    }

    public Long getLastStateDeathPayloadTimestamp() {
        return this.lastStateDeathPayloadTimestamp;
    }

    public boolean isConnected() {
        if (this.client != null) {
            return this.client.isConnected();
        }
        return false;
    }

    public boolean isConnectedAndResubscribed() {
        if (this.client != null) {
            return this.client.isConnected() && this.resubscribed;
        }
        return false;
    }

    public long getConnectDuration() throws TahuException {
        if (this.getConnectTime() != null) {
            Date now = new Date();
            return now.getTime() - this.getConnectTime().getTime();
        }
        if (this.getDisconnectTime() != null) {
            Date now = new Date();
            return -(now.getTime() - this.getDisconnectTime().getTime());
        }
        throw new TahuException(TahuErrorCode.INTERNAL_ERROR, "Connect time is unknown");
    }

    public double getAvailability() throws TahuException {
        Date now;
        if (this.getConnectTime() != null) {
            now = new Date();
            this.totalUptime += (double)(now.getTime() - this.getConnectTime().getTime());
        }
        if (this.getDisconnectTime() != null) {
            now = new Date();
            this.totalDowntime += (double)(now.getTime() - this.getDisconnectTime().getTime());
        }
        if (this.totalUptime + this.totalDowntime == 0.0) {
            throw new TahuException(TahuErrorCode.INTERNAL_ERROR, "Connect time is unknown");
        }
        return this.totalUptime / (this.totalUptime + this.totalDowntime) * 100.0;
    }

    public void resetAvailability() {
        this.totalUptime = 0.0;
        this.totalDowntime = 0.0;
    }

    public Date getOnlineDateTime() {
        return this.onlineDate;
    }

    public void renewOnlineDate() {
        this.onlineDate = new Date();
    }

    public Date getOfflineDateTime() {
        return this.offlineDate;
    }

    public void renewOfflineDate() {
        this.offlineDate = new Date();
    }

    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained) throws TahuException {
        try {
            if (this.client == null) {
                throw new TahuException(TahuErrorCode.INTERNAL_ERROR, "MQTT client: " + this.clientId.getMqttClientId() + " is null");
            }
            if (this.client.isConnected()) {
                logger.debug("{}: Publishing on Topic {}, Payload Size = {}", this.getClientId(), topic, payload.length);
                return this.client.publish(topic, payload, qos, retained);
            }
            throw new TahuException(TahuErrorCode.INTERNAL_ERROR, "MQTT client: " + this.clientId.getMqttClientId() + " is not connected");
        }
        catch (Exception e) {
            throw new TahuException(TahuErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public void asyncPublish(String topic, byte[] payload, int qos, boolean retained) throws TahuException {
        Thread t = new Thread(new AsyncPublisher(topic, payload, qos, retained, false, 0L, 0));
        t.start();
    }

    public void asyncPublish(String topic, byte[] payload, int qos, boolean retained, boolean retry, long retryDelay, int numAttempts) throws TahuException {
        Thread t = new Thread(new AsyncPublisher(topic, payload, qos, retained, retry, retryDelay, numAttempts));
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int subscribe(String topic, int qos) throws TahuException {
        Object object = this.clientLock;
        synchronized (object) {
            if (this.client != null && this.client.isConnected()) {
                try {
                    logger.debug("{}: server {} - Attempting to subscribe on topic {} with QoS={}", this.getClientId(), this.getMqttServerName(), topic, qos);
                    IMqttToken token = this.client.subscribe(topic, qos);
                    logger.trace("{}: Waiting for subscription on {}", (Object)this.getClientId(), (Object)topic);
                    token.waitForCompletion();
                    logger.trace("{}: Done waiting for subscription on {}", (Object)this.getClientId(), (Object)topic);
                    this.subscriptions.put(topic, qos);
                    int[] grantedQos = token.getGrantedQos();
                    logger.debug("{}: Granted QoS for subcription on {}: {}", this.getClientId(), topic, grantedQos[0]);
                    if (grantedQos != null && grantedQos.length == 1) {
                        return grantedQos[0];
                    }
                    String errorMessage = this.getClientId() + ": server " + this.getMqttServerName() + " - Failed to subscribe to " + topic;
                    logger.error(errorMessage);
                    throw new TahuException(TahuErrorCode.NOT_AUTHORIZED, errorMessage);
                }
                catch (MqttException e) {
                    logger.error(this.getClientId() + ": server " + this.getMqttServerName() + " - Failed to subscribe to " + topic);
                    throw new TahuException(TahuErrorCode.INTERNAL_ERROR, (Throwable)e);
                }
            }
            logger.debug("{}: Not connected and not subscribing to {} - just storing the subscription for now", (Object)this.getClientId(), (Object)topic);
            this.subscriptions.put(topic, qos);
            return qos;
        }
    }

    public int[] subscribe(String[] topics, int[] qos) throws TahuException {
        Object object = this.clientLock;
        synchronized (object) {
            try {
                if (this.client != null && this.client.isConnected()) {
                    logger.debug("{}: Attempting to subscribe on topics {} with QoS={}", this.getClientId(), topics, qos);
                    IMqttToken token = this.client.subscribe(topics, qos);
                    logger.trace("{}: Waiting for subscription on {}", (Object)this.getClientId(), (Object)Arrays.toString(topics));
                    token.waitForCompletion();
                    logger.trace("{}: Done waiting for subscription on {}", (Object)this.getClientId(), (Object)Arrays.toString(topics));
                    int[] grantedQos = token.getGrantedQos();
                    if (grantedQos != null && grantedQos.length > 0) {
                        for (int i = 0; i < topics.length; ++i) {
                            if (grantedQos[i] != qos[i]) {
                                throw new TahuException(TahuErrorCode.NOT_AUTHORIZED, "Failed to subscribe to " + topics[i]);
                            }
                            this.subscriptions.put(topics[i], qos[i]);
                        }
                        return grantedQos;
                    }
                    throw new TahuException(TahuErrorCode.NOT_AUTHORIZED, "Failed to subscribe to " + topics);
                }
                for (int i = 0; i < topics.length; ++i) {
                    this.subscriptions.put(topics[i], qos[i]);
                }
                logger.debug("{}: Not connected and not subscribing to {} - just storing the subscription for now", (Object)this.getClientId(), (Object)Arrays.asList(topics));
                return qos;
            }
            catch (Exception e) {
                throw new TahuException(TahuErrorCode.INTERNAL_ERROR, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String topic) throws TahuException {
        Object object = this.clientLock;
        synchronized (object) {
            if (this.client != null && this.client.isConnected()) {
                try {
                    logger.debug("{}: {} attempting to unsubscribe on topic {}", this.getClientId(), this.mqttServerName, topic);
                    this.client.unsubscribe(topic);
                }
                catch (MqttException e) {
                    throw new TahuException(TahuErrorCode.INTERNAL_ERROR, (Throwable)e);
                }
            }
            this.subscriptions.remove(topic);
        }
    }

    @Override
    public void connectionLost(Throwable cause) {
        logger.debug("{}: MQTT connectionLost() to {} :: {}", this.getClientId(), this.getMqttServerName(), this.getMqttServerUrl());
        if (logger.isTraceEnabled() && this.client != null) {
            this.client.getDebug().dumpClientDebug();
        }
        if (this.getDisconnectTime() == null) {
            this.clearConnectTime();
            this.renewDisconnectTime();
            this.renewOfflineDate();
        }
        this.resubscribed = false;
        if (cause != null) {
            logger.debug("{}: Connection lost due to {}", this.getClientId(), cause.getMessage(), cause);
        }
        this.getCallback().connectionLost(this.getMqttServerName(), this.getMqttServerUrl(), this.getClientId(), cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
        Object object = this.lwtDeliveryLock;
        synchronized (object) {
            if (this.lwtDeliveryToken != null && this.lwtDeliveryToken.getMessageId() == token.getMessageId()) {
                logger.info("{}: LWT Delivery complete for {}", (Object)this.getClientId(), (Object)token.getMessageId());
                this.lwtDeliveryToken = null;
            } else {
                logger.debug("{}: Delivery complete for {}", (Object)this.getClientId(), (Object)token.getMessageId());
            }
        }
    }

    @Override
    public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
        logger.debug("{}: MQTT message arrived on topic {}", (Object)this.getClientId(), (Object)topic);
        ++this.numMesgsArrived;
        this.getCallback().messageArrived(this.getMqttServerName(), this.getMqttServerUrl(), this.getClientId(), topic, mqttMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        try {
            NetworkModuleService.validateURI(this.mqttServerUrl.getMqttServerUrl());
        }
        catch (Exception e) {
            logger.error("{}: Invalid MQTT Server URL: {}", (Object)this.getClientId(), (Object)this.mqttServerUrl.getMqttServerUrl());
            return;
        }
        logger.debug("{}: Starting new connect, autoReconnect: {}", (Object)this.getClientId(), (Object)this.autoReconnect);
        Object object = this.clientLock;
        synchronized (object) {
            logger.debug("{}: Got lock for new connect", (Object)this.getClientId());
            try {
                if (this.getDisconnectTime() == null) {
                    this.clearConnectTime();
                    this.renewDisconnectTime();
                }
                if (this.getAutoReconnect() && this.state.inProgress()) {
                    logger.debug("{}: Connect attempt already in progress", (Object)this.getClientId());
                    return;
                }
                this.disconnect(0L, 0L, false, true);
                this.state.setInProgress(true);
                logger.debug("{}: Starting ConnectThread", (Object)this.getClientId());
                this.connectRunnable = new ConnectRunnable(this);
                this.connectRunnableThread = new Thread(this.connectRunnable);
                this.connectRunnableThread.start();
            }
            catch (Throwable t) {
                logger.error("{}: Error connectiong", (Object)this.getClientId(), (Object)t);
            }
        }
    }

    public boolean isDisconnectInProgress() {
        return this.disconnectInProgress;
    }

    public void disconnect(long disconnectQuieseTime, long disconnectTimeout, boolean sendDisconnect, boolean waitForLwt) throws TahuException {
        this.disconnect(disconnectQuieseTime, disconnectTimeout, sendDisconnect, true, waitForLwt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(long disconnectQuieseTime, long disconnectTimeout, boolean sendDisconnect, boolean publishLwt, boolean waitForLwt) throws TahuException {
        Object object = this.clientLock;
        synchronized (object) {
            this.disconnectInProgress = true;
            try {
                this.shutdownConnectionMonitorThread();
            }
            catch (Exception e) {
                logger.error("{}: Failed to shutdown connection monitor thread", (Object)this.getClientId());
            }
            try {
                if (this.connectRunnable != null && this.connectRunnableThread != null) {
                    this.connectRunnable.stopConnectAttempts();
                    this.connectRunnableThread.interrupt();
                }
            }
            catch (Exception e) {
                logger.error("{}: Failed to shut down the connect runnable", (Object)this.getClientId());
            }
            if (this.client != null) {
                try {
                    if (publishLwt) {
                        this.publishLwt(waitForLwt);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    logger.debug("{}: Disconnecting...", (Object)this.getClientId());
                    this.client.disconnectForcibly(disconnectQuieseTime, disconnectTimeout, sendDisconnect);
                    logger.debug("{}: Done disconecting", (Object)this.getClientId());
                    this.client.close();
                    logger.debug("{}: Client closed", (Object)this.getClientId());
                }
                catch (MqttException e) {
                    throw new TahuException(TahuErrorCode.INTERNAL_ERROR, (Throwable)e);
                }
                finally {
                    this.client = null;
                    this.state.setInProgress(false);
                    this.disconnectInProgress = false;
                    this.lwtDeliveryToken = null;
                    this.resubscribed = false;
                }
            }
            logger.debug("{}: Disconnect: Client is already null", (Object)this.getClientId());
            if (this.getDisconnectTime() == null) {
                this.clearConnectTime();
                this.renewDisconnectTime();
                this.renewOfflineDate();
            }
            this.disconnectInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMqttToken attemptConnect(MqttAsyncClient client, MqttConnectOptions options, String ctx) throws MqttSecurityException, MqttException {
        Object object = this.clientLock;
        synchronized (object) {
            if (this.isConnected()) {
                logger.trace("{} is already connected - not trying again", (Object)this.getClientId());
                return null;
            }
            if (this.randomStartupDelay != null && this.randomStartupDelay.isValid()) {
                long randomDelay = this.randomStartupDelay.getRandomDelay();
                logger.debug("{}: Waiting random delay of {} ms before reconnect attempt", (Object)this.getClientId(), (Object)randomDelay);
                try {
                    Thread.sleep(randomDelay);
                }
                catch (InterruptedException e) {
                    logger.warn("{}: Sleep interrupted", (Object)this.getClientId(), (Object)e);
                }
            }
            logger.debug("{}: Attempting {} to {}", this.getClientId(), ctx, this.getMqttServerUrl());
            logger.trace("{}: Thread {} :: {}", this.getClientId(), Thread.currentThread().getName(), Thread.currentThread().getId());
            return client.connect(options, ctx, new IMqttActionListener(){

                @Override
                public void onSuccess(IMqttToken token) {
                    logger.info("{}: {} succeeded", (Object)TahuClient.this.getClientId(), token.getUserContext());
                    TahuClient.this.state.setInProgress(false);
                }

                @Override
                public void onFailure(IMqttToken token, Throwable throwable) {
                    logger.warn("{}: {} failed due to {}", TahuClient.this.getClientId(), token.getUserContext(), throwable != null ? throwable.getMessage() : "?", throwable);
                    logger.warn("{}: MQTT Client details: {}", (Object)TahuClient.this.getClientId(), (Object)this.getTahuClientDetails());
                    TahuClient.this.state.setInProgress(false);
                }

                private String getTahuClientDetails() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("MQTT Server Name = ").append(TahuClient.this.mqttServerName).append(" :: ");
                    sb.append("MQTT Server URL = ").append(TahuClient.this.mqttServerUrl).append(" :: ");
                    sb.append("MQTT Client ID = ").append(TahuClient.this.clientId).append(" :: ");
                    sb.append("Using Birth = ").append(TahuClient.this.birthTopic == null || TahuClient.this.birthTopic.isEmpty() ? "false" : "true").append(" :: ");
                    sb.append("Using LWT = ").append(TahuClient.this.lwtTopic == null || TahuClient.this.lwtTopic.isEmpty() ? "false" : "true");
                    return sb.toString();
                }
            });
        }
    }

    private void attemptRecovery() {
        logger.warn("{}: Connect failed - retrying", (Object)this.getClientId());
        try {
            if (this.randomStartupDelay != null && this.randomStartupDelay.isValid()) {
                long randomDelay = this.randomStartupDelay.getRandomDelay();
                logger.info("{}: Sleeping {} before reconnect attempt", (Object)this.getClientId(), (Object)randomDelay);
                Thread.sleep(randomDelay);
            } else {
                Thread.sleep(this.getConnectRetryInterval());
            }
        }
        catch (InterruptedException ie) {
            logger.warn("{}: InterruptedException while preparing to reconnect", (Object)this.getClientId(), (Object)ie);
            return;
        }
        if (!this.autoReconnect) {
            logger.warn("{}: AutoReconnect canceled - No longer going to retry", (Object)this.getClientId());
            return;
        }
        this.connect();
    }

    private void shutdownConnectionMonitorThread() {
        if (this.connectionMonitorThread == null) {
            logger.debug("{}: Not shutting down ConnectionMonitorThread - its null", (Object)this.getClientId());
            return;
        }
        if (this.connectionMonitorThread.isAlive()) {
            logger.debug("{}: Shutting down ConnectionMonitorThread", (Object)this.getClientId());
            this.connectionMonitorThread.shutdown();
            this.connectionMonitorThread = null;
        } else {
            logger.debug("{}: Not shutting down ConnectionMonitorThread - its not alive", (Object)this.getClientId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectComplete(boolean reconnect, String serverURI) {
        if (this.disconnectInProgress) {
            logger.warn("{}: Ignoring connect complete to {}, disconnect in progress", (Object)this.getClientId(), (Object)serverURI);
            return;
        }
        Object object = this.clientLock;
        synchronized (object) {
            if (reconnect) {
                logger.debug("{}: SUCCESSFULLY RECONNECTED to {}", (Object)this.getClientId(), (Object)this.getMqttServerUrl());
            }
            if (this.autoReconnect && (this.connectionMonitorThread == null || !this.connectionMonitorThread.isAlive())) {
                this.connectionMonitorThread = new ConnectionMonitorThread(new ConnectionMonitor(this.client, this.getClientId()));
                this.connectionMonitorThread.start();
            }
            this.renewOnlineDate();
            this.renewConnectTime();
            this.clearDisconnectTime();
            logger.info("{}: Connected to {}", (Object)this.getClientId(), (Object)this.getMqttServerUrl());
            this.getCallback().connectComplete(reconnect, this.getMqttServerName(), this.getMqttServerUrl(), this.getClientId());
            if (!this.subscriptions.isEmpty()) {
                int size;
                int totalCount = this.subscriptions.size();
                ArrayList<String> topicsList = new ArrayList<String>(this.subscriptions.keySet());
                for (int subscribedCount = 0; subscribedCount < totalCount; subscribedCount += size) {
                    int topicsRemaining = totalCount - subscribedCount;
                    size = topicsRemaining > this.maxTopicsPerSubscribe ? this.maxTopicsPerSubscribe : topicsRemaining;
                    Object[] topics = new String[size];
                    final int[] qosLevels = new int[size];
                    for (int i = 0; i < size; ++i) {
                        String topic = topicsList.get(i + subscribedCount);
                        topics[i] = topic;
                        qosLevels[i] = (Integer)this.subscriptions.get(topic);
                    }
                    final String topicStr = Arrays.toString(topics);
                    final String qosStr = Arrays.toString(qosLevels);
                    logger.debug("{}: server {} - Attempting to subscribe on topic {} with QoS={}", this.getClientId(), this.getMqttServerName(), topicStr, qosStr);
                    try {
                        this.client.subscribe((String[])topics, qosLevels, null, new IMqttActionListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onSuccess(IMqttToken asyncActionToken) {
                                int[] grantedQos = asyncActionToken.getGrantedQos();
                                if (Arrays.equals(qosLevels, grantedQos)) {
                                    logger.debug("{}: server {} - Successfully subscribed on {} on QoS={}", TahuClient.this.getClientId(), TahuClient.this.getMqttServerName(), topicStr, qosStr);
                                } else {
                                    try {
                                        String grantedQosStr = Arrays.toString(grantedQos);
                                        logger.error("{}: server {} - Failed subscribe on {} granted QoS {} != {}", TahuClient.this.getClientId(), TahuClient.this.getMqttServerName(), topicStr, qosStr, grantedQosStr);
                                        Thread.sleep(1000L);
                                        Object object = TahuClient.this.clientLock;
                                        synchronized (object) {
                                            TahuClient.this.client.disconnectForcibly(0L, 1L, false);
                                        }
                                        return;
                                    }
                                    catch (Exception e) {
                                        logger.error("{}: server {} - Failed disconnect on failed subscribe granted QoS", TahuClient.this.getClientId(), TahuClient.this.getMqttServerName(), e);
                                    }
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                                Object object = TahuClient.this.clientLock;
                                synchronized (object) {
                                    try {
                                        logger.error("{}: server {} - Failed to subscribe on {}", TahuClient.this.getClientId(), TahuClient.this.getMqttServerName(), topicStr);
                                        TahuClient.this.client.disconnectForcibly(0L, 1L, false);
                                    }
                                    catch (MqttException e) {
                                        logger.error("{}: server {} - Failed disconnect on failed subscribe", TahuClient.this.getClientId(), TahuClient.this.getMqttServerName(), e);
                                    }
                                }
                            }
                        });
                        continue;
                    }
                    catch (MqttException e) {
                        logger.error("{}: server {} - Failed to subscribe on {} with QoS={}", this.getClientId(), this.getMqttServerName(), topicStr, qosStr, e);
                        break;
                    }
                }
            } else if (this.trackFirstConnection && !this.firstConnection) {
                logger.warn("{}: No subscriptions for {}", (Object)this.getClientId(), (Object)this.getClientId());
            }
            this.resubscribed = true;
            if (this.onlineState) {
                this.publishBirthMessage();
            } else {
                try {
                    this.publishLwt(true);
                }
                catch (Exception e) {
                    logger.error("Failed to publish the LWT", e);
                }
            }
            this.firstConnection = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackFirstConnection(boolean trackFirstConnection) {
        Object object = this.clientLock;
        synchronized (object) {
            this.trackFirstConnection = trackFirstConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnlineState(boolean newOnlineState) {
        Object object = this.clientLock;
        synchronized (object) {
            if (this.onlineState == newOnlineState) {
                return;
            }
            this.onlineState = newOnlineState;
            if (this.onlineState) {
                this.publishBirthMessage();
            } else {
                try {
                    this.publishLwt(true);
                }
                catch (Exception e) {
                    logger.error("Failed to publish the LWT when setting the online state", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishBirthMessage() {
        Object object = this.clientLock;
        synchronized (object) {
            if (this.birthTopic != null && this.client.isConnected()) {
                try {
                    logger.debug("{}: Publishing BIRTH on {} with retain {}", this.getClientId(), this.birthTopic, this.birthRetain);
                    if (this.useSparkplugStatePayload) {
                        try {
                            ObjectMapper mapper = new ObjectMapper();
                            StatePayload statePayload = new StatePayload(true, this.lastStateDeathPayloadTimestamp);
                            byte[] payload = mapper.writeValueAsString(statePayload).getBytes();
                            this.publish(this.birthTopic, payload, 1, this.birthRetain);
                        }
                        catch (Exception e) {
                            logger.error("{}: Failed to publish the BIRTH message on {}", this.getClientId(), this.birthTopic, e);
                        }
                    } else {
                        this.publish(this.birthTopic, this.birthPayload, 1, this.birthRetain);
                    }
                }
                catch (TahuException ce) {
                    logger.error("{}: Error in birth topic publish on connect", (Object)this.getClientId(), (Object)ce);
                    try {
                        this.client.disconnectForcibly(0L, 1L, false);
                    }
                    catch (Exception e) {
                        logger.error("{}: Failed to disconnect after failed BIRTH publish", (Object)this.getClientId(), (Object)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishLwt(boolean waitForLwt) throws MqttException, TahuException {
        Object object = this.clientLock;
        synchronized (object) {
            boolean clientConnected = this.client != null && this.client.isConnected();
            boolean lwtDeliveryComplete = false;
            if (this.lwtTopic != null && clientConnected) {
                logger.info("{}: Publishing LWT on {} with qos={} and retain={}", this.getClientId(), this.lwtTopic, this.lwtQoS, this.lwtRetain);
                Object object2 = this.lwtDeliveryLock;
                synchronized (object2) {
                    if (this.useSparkplugStatePayload) {
                        try {
                            ObjectMapper mapper = new ObjectMapper();
                            StatePayload statePayload = new StatePayload(false, new Date().getTime());
                            byte[] payload = mapper.writeValueAsString(statePayload).getBytes();
                            this.lwtDeliveryToken = this.publish(this.lwtTopic, payload, this.lwtQoS, this.lwtRetain);
                        }
                        catch (Exception e) {
                            logger.error("{}: Failed to publish the LWT message on {}", this.getClientId(), this.lwtTopic, e);
                        }
                    } else {
                        this.lwtDeliveryToken = this.publish(this.lwtTopic, this.lwtPayload, this.lwtQoS, this.lwtRetain);
                    }
                    logger.debug("{}: published on LWT Topic={}, messageId={}", this.getClientId(), this.lwtTopic, this.lwtDeliveryToken.getMessageId());
                }
                if (waitForLwt) {
                    lwtDeliveryComplete = this.isLwtDeliveryComplete();
                    logger.trace("{}: Completed LWT Delivery? {}", (Object)this.getClientId(), (Object)lwtDeliveryComplete);
                } else {
                    logger.trace("{}: Not waiting for LWT", (Object)this.getClientId());
                }
            } else {
                logger.debug("{}: Not publishing LWT, client connected state: {}", (Object)this.getClientId(), (Object)clientConnected);
            }
        }
    }

    private Date getConnectTime() {
        return this.connectTime;
    }

    private Date getDisconnectTime() {
        return this.disconnectTime;
    }

    private void clearConnectTime() {
        this.connectTime = null;
    }

    private void clearDisconnectTime() {
        this.disconnectTime = null;
    }

    private void renewConnectTime() {
        this.connectTime = new Date();
    }

    private void renewDisconnectTime() {
        this.disconnectTime = new Date();
    }

    private long getConnectRetryInterval() {
        return this.connectRetryInterval;
    }

    public void setConnectRetryInterval(long connectRetryInterval) {
        this.connectRetryInterval = connectRetryInterval;
    }

    private long getConnectAttemptTimeout() {
        return this.connectAttemptTimeout;
    }

    public void setConnectAttemptTimeout(long connectAttemptTimeout) {
        this.connectAttemptTimeout = connectAttemptTimeout;
    }

    public boolean isAttemptingConnect() {
        return this.state.inProgress();
    }

    private String getErrorMessage(String prefix, Throwable throwable) {
        return prefix + ": " + this.getErrorMessage(throwable);
    }

    private String getErrorMessage(Throwable throwable) {
        StringBuilder sb = new StringBuilder(throwable.getMessage());
        Throwable cause = throwable.getCause();
        if (cause != null) {
            sb.append(": ").append(this.getErrorMessage(cause));
        }
        return sb.toString();
    }

    private void logException(String message, Throwable throwable) {
        String errorMessage = this.getErrorMessage(message, throwable);
        if (logger.isTraceEnabled()) {
            logger.error("{}: {}", this.getClientId(), errorMessage, throwable);
        } else {
            logger.error("{}: {}", (Object)this.getClientId(), (Object)errorMessage);
        }
    }

    private boolean isLwtDeliveryComplete() {
        int counter = this.keepAlive * 4;
        for (int i = 0; i < counter; ++i) {
            try {
                if (this.lwtDeliveryToken == null) {
                    logger.info("{}: LWT delivery confirmation - done waiting", (Object)this.getClientId());
                    return true;
                }
                Thread.sleep(250L);
                continue;
            }
            catch (InterruptedException e) {
                logger.warn("{}: Interrupted while waiting for LWT", (Object)this.getClientId());
            }
        }
        this.lwtDeliveryToken = null;
        logger.warn("{}: LWT delivery confirmation - timeout", (Object)this.getClientId());
        return false;
    }

    private class ConnectionMonitor
    implements Runnable {
        private final MqttAsyncClient monitoredClient;
        private final MqttClientId monitoredClientId;
        private boolean keepRunning = true;

        public ConnectionMonitor(MqttAsyncClient client, MqttClientId clientId) {
            this.monitoredClient = client;
            this.monitoredClientId = clientId;
        }

        public void setKeepRunning(boolean keepRunning) {
            this.keepRunning = keepRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int connectionLostCounter = 0;
                while (this.keepRunning) {
                    Object object = TahuClient.this.clientLock;
                    synchronized (object) {
                        if (this.monitoredClient != null) {
                            if (!this.monitoredClient.isConnected()) {
                                if (TahuClient.this.state.inProgress()) {
                                    logger.debug("{}: ConnectionMonitor - Attempting to connect", (Object)this.monitoredClientId);
                                    connectionLostCounter = 0;
                                } else {
                                    logger.debug("{}: ConnectionMonitor - Not connected, incrementing counter", (Object)this.monitoredClientId);
                                    ++connectionLostCounter;
                                }
                            } else {
                                logger.trace("{}: ConnectionMonitor - Already connected", (Object)this.monitoredClientId);
                                connectionLostCounter = 0;
                            }
                        } else {
                            logger.debug("{}: ConnectionMonitor - Client is null - Uncaught connectionLost", (Object)TahuClient.this.getClientId());
                            connectionLostCounter = 5;
                        }
                    }
                    if (connectionLostCounter == 5 && TahuClient.this.callback != null) {
                        TahuClient.this.callback.connectionLost(TahuClient.this.mqttServerName, TahuClient.this.mqttServerUrl, this.monitoredClientId, new Throwable(this.monitoredClientId + ": Uncaught paho disconnect"));
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ie) {
                        logger.debug("{}: ConnectionMonitor interrupted", (Object)this.monitoredClientId);
                    }
                }
            }
            catch (Exception e) {
                logger.error("{}: ConnectionMonitor failed to keep running", (Object)this.monitoredClientId, (Object)e);
            }
        }
    }

    private class ConnectionMonitorThread
    extends Thread {
        private ConnectionMonitor connectionMonitor;

        public ConnectionMonitorThread(ConnectionMonitor connectionMonitor) {
            super(connectionMonitor);
            this.connectionMonitor = connectionMonitor;
        }

        public void shutdown() {
            this.connectionMonitor.setKeepRunning(false);
            this.interrupt();
        }
    }

    private class AsyncPublisher
    implements Runnable {
        private String topic;
        private byte[] payload;
        private int qos;
        private boolean retained;
        private boolean retry = false;
        private long retryDelay;
        private int numAttempts;

        public AsyncPublisher(String topic, byte[] payload, int qos, boolean retained, boolean retry, long retryDelay, int numAttempts) {
            this.topic = topic;
            this.payload = payload;
            this.qos = qos;
            this.retained = retained;
            this.retry = retry;
            this.retryDelay = retryDelay;
            this.numAttempts = numAttempts;
        }

        @Override
        public void run() {
            try {
                if (this.retry) {
                    for (int i = 0; i < this.numAttempts; ++i) {
                        if (TahuClient.this.client == null || !TahuClient.this.client.isConnected()) {
                            Thread.sleep(this.retryDelay);
                            continue;
                        }
                        logger.debug("{}: Publishing on {}, Payload size = {}", TahuClient.this.getClientId(), this.topic, this.payload.length);
                        TahuClient.this.client.publish(this.topic, this.payload, this.qos, this.retained);
                    }
                    logger.error("{}: Failed to publish message on {} after {} attempts", TahuClient.this.getClientId(), this.topic, this.numAttempts);
                    throw new TahuException(TahuErrorCode.INTERNAL_ERROR, "Failed to publish message on " + this.topic + " after " + this.numAttempts + " attempts");
                }
                if (TahuClient.this.client == null) {
                    throw new TahuException(TahuErrorCode.INTERNAL_ERROR, "MQTT client is null");
                }
                if (!TahuClient.this.client.isConnected()) {
                    throw new TahuException(TahuErrorCode.INTERNAL_ERROR, "MQTT client not connected");
                }
                logger.debug("{}: Publishing on {}, Payload size = {}", TahuClient.this.getClientId(), this.topic, this.payload.length);
                TahuClient.this.client.publish(this.topic, this.payload, this.qos, this.retained);
            }
            catch (Exception e) {
                logger.error("{}: Failed to publish", (Object)TahuClient.this.getClientId(), (Object)e);
            }
        }
    }

    protected class ConnectRunnable
    implements Runnable {
        private MqttCallback callback;
        private boolean attemptConnects = true;

        public ConnectRunnable(MqttCallback callback) {
            this.callback = callback;
        }

        public void stopConnectAttempts() {
            this.attemptConnects = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (TahuClient.this.client != null) {
                try {
                    if (TahuClient.this.client.isConnected()) {
                        TahuClient.this.client.disconnectForcibly(0L, 1L, false);
                        TahuClient.this.shutdownConnectionMonitorThread();
                    }
                    TahuClient.this.client.close();
                }
                catch (MqttException e) {
                    logger.error("{}: Error while disconnecting client", (Object)TahuClient.this.getClientId(), (Object)e);
                }
                finally {
                    TahuClient.this.client = null;
                }
            }
            try {
                TahuClient.this.resubscribed = false;
                if (TahuClient.this.connectOptions == null) {
                    TahuClient.this.connectOptions = new MqttConnectOptions();
                }
                TahuClient.this.connectOptions.setMqttVersion(4);
                TahuClient.this.connectOptions.setCleanSession(TahuClient.this.cleanSession);
                TahuClient.this.connectOptions.setConnectionTimeout(30);
                if (TahuClient.this.getUsername() != null && !TahuClient.this.getUsername().trim().isEmpty()) {
                    logger.debug("{}: Setting username to {}", (Object)TahuClient.this.getClientId(), (Object)TahuClient.this.getUsername());
                    TahuClient.this.connectOptions.setUserName(TahuClient.this.getUsername());
                }
                if (TahuClient.this.getPassword() != null && !TahuClient.this.getPassword().trim().isEmpty()) {
                    logger.debug("{}: Setting password to ****", (Object)TahuClient.this.getClientId());
                    TahuClient.this.connectOptions.setPassword(TahuClient.this.getPassword().toCharArray());
                }
                TahuClient.this.connectOptions.setKeepAliveInterval(TahuClient.this.keepAlive);
                if (TahuClient.this.lwtTopic != null) {
                    logger.debug("{}: Setting WILL on {} with retain {}", TahuClient.this.getClientId(), TahuClient.this.lwtTopic, TahuClient.this.lwtRetain);
                    if (TahuClient.this.useSparkplugStatePayload) {
                        ObjectMapper mapper = new ObjectMapper();
                        TahuClient.this.lastStateDeathPayloadTimestamp = new Date().getTime();
                        StatePayload statePayload = new StatePayload(false, TahuClient.this.lastStateDeathPayloadTimestamp);
                        byte[] payload = mapper.writeValueAsString(statePayload).getBytes();
                        TahuClient.this.connectOptions.setWill(TahuClient.this.lwtTopic, payload, 1, TahuClient.this.lwtRetain);
                    } else {
                        TahuClient.this.connectOptions.setWill(TahuClient.this.lwtTopic, TahuClient.this.lwtPayload, 1, TahuClient.this.lwtRetain);
                    }
                }
                TahuClient.this.connectOptions.setMaxInflight(TahuClient.this.getMaxInflightMessages());
                logger.info("{}: Creating the MQTT Client to {} on thread {}", TahuClient.this.getClientId(), TahuClient.this.getMqttServerUrl(), Thread.currentThread().getName());
                TahuClient.this.client = new MqttAsyncClient(TahuClient.this.getMqttServerUrl().toString(), TahuClient.this.getClientId().toString(), null);
                TahuClient.this.client.setCallback(this.callback);
                IMqttToken connectToken = null;
                long attemptTimestamp = System.currentTimeMillis();
                if (TahuClient.this.autoReconnect) {
                    try {
                        while (!TahuClient.this.isConnected() && this.attemptConnects) {
                            try {
                                Object object = TahuClient.this.clientLock;
                                synchronized (object) {
                                    if (!this.attemptConnects) {
                                        logger.info("{}: No longer attempting to connect", (Object)TahuClient.this.getClientId());
                                        TahuClient.this.state.setInProgress(false);
                                        return;
                                    }
                                    connectToken = TahuClient.this.attemptConnect(TahuClient.this.client, TahuClient.this.connectOptions, "connect with retry");
                                    attemptTimestamp = System.currentTimeMillis();
                                }
                                Thread.sleep(TahuClient.this.getConnectRetryInterval());
                            }
                            catch (InterruptedException ie) {
                                logger.info("{}: Connect thread {} interrupted - giving up", (Object)Thread.currentThread().getName(), (Object)TahuClient.this.getClientId());
                                return;
                            }
                            catch (MqttException e) {
                                if (e.getReasonCode() == 32110) {
                                    if (connectToken != null) {
                                        logger.debug("{}: Still trying to connect - isComplete? {}, sessionPresent? {}", TahuClient.this.getClientId(), connectToken.isComplete(), connectToken.getSessionPresent());
                                    } else {
                                        logger.debug("{}: Still trying to connect", (Object)TahuClient.this.getClientId());
                                    }
                                    if (System.currentTimeMillis() - attemptTimestamp > TahuClient.this.connectAttemptTimeout) {
                                        Object object = TahuClient.this.clientLock;
                                        synchronized (object) {
                                            logger.warn("{}: Connect attempt has timed out - forcing close", (Object)TahuClient.this.getClientId());
                                            TahuClient.this.client.close(true);
                                            continue;
                                        }
                                    }
                                    Thread.sleep(500L);
                                    continue;
                                }
                                logger.debug("{}: Unable to connect due to {}, next connect attempt in {} ms", TahuClient.this.getClientId(), e.getMessage(), TahuClient.this.getConnectRetryInterval());
                                Thread.sleep(TahuClient.this.getConnectRetryInterval());
                            }
                        }
                        logger.info("{}: MQTT Client connected to {} on thread {}", TahuClient.this.getClientId(), TahuClient.this.getMqttServerUrl(), Thread.currentThread().getName());
                        TahuClient.this.state.setInProgress(false);
                        return;
                    }
                    catch (InterruptedException ie) {
                        logger.info("{}: Connect thread 2 interrupted - giving up", (Object)TahuClient.this.getClientId());
                        TahuClient.this.state.setInProgress(false);
                        return;
                    }
                    catch (Throwable throwable) {
                        TahuClient.this.logException("Error while attempting connect (with autoReconnect=true) to " + TahuClient.this.getMqttServerUrl(), throwable);
                        TahuClient.this.state.setInProgress(false);
                        if (!TahuClient.this.autoReconnect) return;
                        if (TahuClient.this.isConnected()) return;
                        if (!this.attemptConnects) return;
                        TahuClient.this.attemptRecovery();
                        return;
                    }
                }
                try {
                    Object throwable = TahuClient.this.clientLock;
                    synchronized (throwable) {
                        if (!this.attemptConnects) {
                            logger.info("{}: No longer attempting to connect", (Object)TahuClient.this.getClientId());
                            TahuClient.this.state.setInProgress(false);
                            return;
                        }
                        TahuClient.this.attemptConnect(TahuClient.this.client, TahuClient.this.connectOptions, "connect");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    TahuClient.this.logException("Error while attempting connect (with autoReconnect=false) to " + TahuClient.this.getMqttServerUrl(), throwable);
                    return;
                }
            }
            catch (Exception e) {
                logger.error("{}: Error while connecting client", (Object)TahuClient.this.getClientId(), (Object)e);
                TahuClient.this.state.setInProgress(false);
                if (!TahuClient.this.autoReconnect) return;
                if (TahuClient.this.isConnected()) return;
                if (!this.attemptConnects) return;
                TahuClient.this.attemptRecovery();
            }
        }
    }

    private class ConnectingState {
        private boolean inProgress = false;

        private ConnectingState() {
        }

        protected void setInProgress(boolean inProgress) {
            this.inProgress = inProgress;
        }

        protected boolean inProgress() {
            return this.inProgress;
        }
    }
}

