/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.edge.sim;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.RandomStringUtils;
import org.eclipse.tahu.SparkplugException;
import org.eclipse.tahu.edge.sim.DataSimulator;
import org.eclipse.tahu.message.model.DataSet;
import org.eclipse.tahu.message.model.DataSetDataType;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.File;
import org.eclipse.tahu.message.model.MetaData;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.MetricDataType;
import org.eclipse.tahu.message.model.Parameter;
import org.eclipse.tahu.message.model.ParameterDataType;
import org.eclipse.tahu.message.model.Row;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.SparkplugBPayloadMap;
import org.eclipse.tahu.message.model.SparkplugDescriptor;
import org.eclipse.tahu.message.model.Template;
import org.eclipse.tahu.message.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomDataSimulator
implements DataSimulator {
    private static Logger logger = LoggerFactory.getLogger(RandomDataSimulator.class.getName());
    private final int numNodeMetrics;
    private final Map<SparkplugDescriptor, Integer> numDeviceMetrics;
    private final Random random = new Random();
    private final Map<SparkplugDescriptor, Map<String, Metric>> metricMaps = new HashMap<SparkplugDescriptor, Map<String, Metric>>();
    private final Map<SparkplugDescriptor, Long> lastUpdateMap = new HashMap<SparkplugDescriptor, Long>();

    public RandomDataSimulator(int numNodeMetrics, Map<SparkplugDescriptor, Integer> numDeviceMetrics) {
        this.numNodeMetrics = numNodeMetrics;
        this.numDeviceMetrics = numDeviceMetrics;
    }

    @Override
    public SparkplugBPayloadMap getNodeBirthPayload(EdgeNodeDescriptor edgeNodeDescriptor) {
        try {
            Date now = new Date();
            HashMap<String, Metric> metricMap = new HashMap<String, Metric>();
            SparkplugBPayloadMap.SparkplugBPayloadMapBuilder payloadBuilder = new SparkplugBPayloadMap.SparkplugBPayloadMapBuilder();
            payloadBuilder.setTimestamp(now);
            payloadBuilder.addMetric(new Metric.MetricBuilder("simpleType", MetricDataType.Template, (Object)this.newSimpleTemplate(true, null)).createMetric());
            payloadBuilder.addMetrics(this.newComplexTemplateDefs());
            for (int i = 0; i < this.numNodeMetrics; ++i) {
                Metric metric = this.getRandomMetric("NT", i, true);
                metricMap.put(metric.getName(), metric);
                payloadBuilder.addMetric(metric);
            }
            this.metricMaps.put(edgeNodeDescriptor, metricMap);
            this.lastUpdateMap.put(edgeNodeDescriptor, now.getTime());
            return payloadBuilder.createPayload();
        }
        catch (Exception e) {
            logger.error("Failed to get the NBIRTH", e);
            return null;
        }
    }

    @Override
    public SparkplugBPayload getNodeDataPayload(EdgeNodeDescriptor edgeNodeDescriptor) {
        try {
            Date now = new Date();
            HashMap<String, Metric> metricMap = new HashMap<String, Metric>();
            SparkplugBPayload.SparkplugBPayloadBuilder payloadBuilder = new SparkplugBPayload.SparkplugBPayloadBuilder();
            payloadBuilder.setTimestamp(now);
            logger.info("Getting number of metrics for {}", (Object)edgeNodeDescriptor);
            for (int i = 0; i < this.numNodeMetrics; ++i) {
                Metric metric = this.getRandomMetric("NT", i, true);
                if (metric == null) continue;
                metricMap.put(metric.getName(), metric);
                payloadBuilder.addMetric(metric);
            }
            this.metricMaps.put(edgeNodeDescriptor, metricMap);
            this.lastUpdateMap.put(edgeNodeDescriptor, now.getTime());
            return payloadBuilder.createPayload();
        }
        catch (Exception e) {
            logger.error("Failed to get the NDATA", e);
            return null;
        }
    }

    @Override
    public SparkplugBPayload getDeviceBirthPayload(DeviceDescriptor deviceDescriptor) {
        try {
            Date now = new Date();
            HashMap<String, Metric> metricMap = new HashMap<String, Metric>();
            SparkplugBPayload.SparkplugBPayloadBuilder payloadBuilder = new SparkplugBPayload.SparkplugBPayloadBuilder();
            payloadBuilder.setTimestamp(now);
            logger.info("Getting number of metrics for {}", (Object)deviceDescriptor);
            for (int i = 0; i < this.numDeviceMetrics.get(deviceDescriptor); ++i) {
                Metric metric = this.getRandomMetric("DT", i, true);
                if (metric == null) continue;
                metricMap.put(metric.getName(), metric);
                payloadBuilder.addMetric(metric);
            }
            this.metricMaps.put(deviceDescriptor, metricMap);
            this.lastUpdateMap.put(deviceDescriptor, now.getTime());
            return payloadBuilder.createPayload();
        }
        catch (Exception e) {
            logger.error("Failed to get the DBIRTH", e);
            return null;
        }
    }

    @Override
    public SparkplugBPayload getDeviceDataPayload(DeviceDescriptor deviceDescriptor) {
        try {
            Date now = new Date();
            HashMap<String, Metric> metricMap = new HashMap<String, Metric>();
            SparkplugBPayload.SparkplugBPayloadBuilder payloadBuilder = new SparkplugBPayload.SparkplugBPayloadBuilder();
            payloadBuilder.setTimestamp(now);
            logger.info("Getting number of metrics for {}", (Object)deviceDescriptor);
            for (int i = 0; i < this.numDeviceMetrics.get(deviceDescriptor); ++i) {
                Metric metric = this.getRandomMetric("DT", i, true);
                if (metric == null) continue;
                metricMap.put(metric.getName(), metric);
                payloadBuilder.addMetric(metric);
            }
            this.metricMaps.put(deviceDescriptor, metricMap);
            this.lastUpdateMap.put(deviceDescriptor, now.getTime());
            return payloadBuilder.createPayload();
        }
        catch (Exception e) {
            logger.error("Failed to get the DDATA", e);
            return null;
        }
    }

    @Override
    public boolean hasMetric(SparkplugDescriptor sparkplugDescriptor, String metricName) {
        return this.metricMaps.containsKey(sparkplugDescriptor) && this.metricMaps.get(sparkplugDescriptor).get(metricName) != null;
    }

    @Override
    public Metric handleMetricWrite(SparkplugDescriptor sparkplugDescriptor, Metric metric) {
        return null;
    }

    private Metric getRandomMetric(String namePrefix, int index, boolean isBirth) throws Exception {
        int remainder = index % 34;
        int dataType = remainder + 1;
        if (dataType == 20 || dataType == 21) {
            return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Int32, (Object)this.getRandomInt32()).createMetric();
        }
        switch (dataType) {
            case 1: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Int8, (Object)this.getRandomInt8()).createMetric();
            }
            case 2: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Int16, (Object)this.getRandomInt16()).createMetric();
            }
            case 3: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Int32, (Object)this.getRandomInt32()).createMetric();
            }
            case 4: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Int64, (Object)this.getRandomInt64()).createMetric();
            }
            case 5: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.UInt8, (Object)this.getRandomUInt8()).createMetric();
            }
            case 6: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.UInt16, (Object)this.getRandomUInt16()).createMetric();
            }
            case 7: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.UInt32, (Object)this.getRandomUInt32()).createMetric();
            }
            case 8: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.UInt64, (Object)this.getRandomUInt64()).createMetric();
            }
            case 9: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Float, (Object)Float.valueOf(this.random.nextFloat())).createMetric();
            }
            case 10: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Double, (Object)this.random.nextDouble()).createMetric();
            }
            case 11: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Boolean, (Object)this.random.nextBoolean()).createMetric();
            }
            case 12: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.String, (Object)this.getRandomString(8)).createMetric();
            }
            case 13: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.DateTime, (Object)new Date(this.random.nextLong())).createMetric();
            }
            case 14: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Text, (Object)this.getRandomString(8)).createMetric();
            }
            case 15: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.UUID, (Object)UUID.randomUUID().toString()).createMetric();
            }
            case 16: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.DataSet, (Object)this.newDataSet()).createMetric();
            }
            case 17: {
                byte[] byteArray = new byte[10];
                this.random.nextBytes(byteArray);
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Bytes, (Object)byteArray).createMetric();
            }
            case 18: {
                byte[] fileDataArray = new byte[10];
                this.random.nextBytes(fileDataArray);
                byte[] md5 = MessageDigest.getInstance("MD5").digest(fileDataArray);
                String hashString = DatatypeConverter.printHexBinary(md5);
                MetaData metaData = new MetaData.MetaDataBuilder().fileName("Fake_File.bin").md5(hashString).fileType("bin").createMetaData();
                File file = new File("Fake_File.bin", fileDataArray);
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.File, (Object)file).metaData(metaData).createMetric();
            }
            case 19: {
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Template, (Object)this.newComplexTemplateInstance()).createMetric();
            }
            case 22: {
                Byte[] int8ArrayValue = new Byte[5];
                for (int i = 0; i < 5; ++i) {
                    int8ArrayValue[i] = this.getRandomInt8();
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Int8Array, (Object)int8ArrayValue).createMetric();
            }
            case 23: {
                Short[] int16ArrayValue = new Short[5];
                for (int i = 0; i < 5; ++i) {
                    int16ArrayValue[i] = this.getRandomInt16();
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Int16Array, (Object)int16ArrayValue).createMetric();
            }
            case 24: {
                Integer[] int32ArrayValue = new Integer[5];
                for (int i = 0; i < 5; ++i) {
                    int32ArrayValue[i] = this.getRandomInt32();
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Int32Array, (Object)int32ArrayValue).createMetric();
            }
            case 25: {
                Long[] int64ArrayValue = new Long[5];
                for (int i = 0; i < 5; ++i) {
                    int64ArrayValue[i] = this.getRandomInt64();
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.Int64Array, (Object)int64ArrayValue).createMetric();
            }
            case 26: {
                Short[] uInt8ArrayValue = new Short[5];
                for (int i = 0; i < 5; ++i) {
                    uInt8ArrayValue[i] = this.getRandomUInt8();
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.UInt8Array, (Object)uInt8ArrayValue).createMetric();
            }
            case 27: {
                Integer[] uInt16rrayValue = new Integer[5];
                for (int i = 0; i < 5; ++i) {
                    uInt16rrayValue[i] = this.getRandomUInt16();
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.UInt16Array, (Object)uInt16rrayValue).createMetric();
            }
            case 28: {
                Long[] uInt32ArrayValue = new Long[5];
                for (int i = 0; i < 5; ++i) {
                    uInt32ArrayValue[i] = this.getRandomUInt32();
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.UInt32Array, (Object)uInt32ArrayValue).createMetric();
            }
            case 29: {
                BigInteger[] uInt64ArrayValue = new BigInteger[5];
                for (int i = 0; i < 5; ++i) {
                    uInt64ArrayValue[i] = this.getRandomUInt64();
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.UInt64Array, (Object)uInt64ArrayValue).createMetric();
            }
            case 30: {
                Float[] floatArrayValue = new Float[5];
                for (int i = 0; i < 5; ++i) {
                    floatArrayValue[i] = Float.valueOf(this.random.nextFloat());
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.FloatArray, (Object)floatArrayValue).createMetric();
            }
            case 31: {
                Double[] doubleArrayValue = new Double[5];
                for (int i = 0; i < 5; ++i) {
                    doubleArrayValue[i] = this.random.nextDouble();
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.DoubleArray, (Object)doubleArrayValue).createMetric();
            }
            case 32: {
                Boolean[] booleanArrayValue = new Boolean[5];
                for (int i = 0; i < 5; ++i) {
                    booleanArrayValue[i] = this.random.nextBoolean();
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.BooleanArray, (Object)booleanArrayValue).createMetric();
            }
            case 33: {
                String[] stringArrayValue = new String[5];
                for (int i = 0; i < 5; ++i) {
                    stringArrayValue[i] = this.getRandomString(8);
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.StringArray, (Object)stringArrayValue).createMetric();
            }
            case 34: {
                Date[] dateTimeArrayValue = new Date[5];
                for (int i = 0; i < 5; ++i) {
                    dateTimeArrayValue[i] = new Date(this.getRandomInt64());
                }
                return new Metric.MetricBuilder(namePrefix + "-" + index, MetricDataType.DateTimeArray, (Object)dateTimeArrayValue).createMetric();
            }
        }
        logger.error("Failed to get a metric for dataType {}", (Object)dataType);
        return null;
    }

    private DataSet newDataSet() throws SparkplugException {
        return new DataSet.DataSetBuilder(14L).addColumnName("Int8s").addColumnName("Int16s").addColumnName("Int32s").addColumnName("Int64s").addColumnName("UInt8s").addColumnName("UInt16s").addColumnName("UInt32s").addColumnName("UInt64s").addColumnName("Floats").addColumnName("Doubles").addColumnName("Booleans").addColumnName("Strings").addColumnName("Dates").addColumnName("Texts").addType(DataSetDataType.Int8).addType(DataSetDataType.Int16).addType(DataSetDataType.Int32).addType(DataSetDataType.Int64).addType(DataSetDataType.UInt8).addType(DataSetDataType.UInt16).addType(DataSetDataType.UInt32).addType(DataSetDataType.UInt64).addType(DataSetDataType.Float).addType(DataSetDataType.Double).addType(DataSetDataType.Boolean).addType(DataSetDataType.String).addType(DataSetDataType.DateTime).addType(DataSetDataType.Text).addRow(new Row.RowBuilder().addValue(new Value<Byte>(DataSetDataType.Int8, this.getRandomInt8())).addValue(new Value<Short>(DataSetDataType.Int16, this.getRandomInt16())).addValue(new Value<Integer>(DataSetDataType.Int32, this.getRandomInt32())).addValue(new Value<Long>(DataSetDataType.Int64, this.getRandomInt64())).addValue(new Value<Short>(DataSetDataType.UInt8, this.getRandomUInt8())).addValue(new Value<Integer>(DataSetDataType.UInt16, this.getRandomUInt16())).addValue(new Value<Long>(DataSetDataType.UInt32, this.getRandomUInt32())).addValue(new Value<BigInteger>(DataSetDataType.UInt64, this.getRandomUInt64())).addValue(new Value<Float>(DataSetDataType.Float, Float.valueOf(this.random.nextFloat()))).addValue(new Value<Double>(DataSetDataType.Double, this.random.nextDouble())).addValue(new Value<Boolean>(DataSetDataType.Boolean, this.random.nextBoolean())).addValue(new Value<String>(DataSetDataType.String, UUID.randomUUID().toString())).addValue(new Value<Date>(DataSetDataType.DateTime, new Date())).addValue(new Value<String>(DataSetDataType.Text, UUID.randomUUID().toString())).createRow()).addRow(new Row.RowBuilder().addValue(new Value<Byte>(DataSetDataType.Int8, this.getRandomInt8())).addValue(new Value<Short>(DataSetDataType.Int16, this.getRandomInt16())).addValue(new Value<Integer>(DataSetDataType.Int32, this.getRandomInt32())).addValue(new Value<Long>(DataSetDataType.Int64, this.getRandomInt64())).addValue(new Value<Short>(DataSetDataType.UInt8, this.getRandomUInt8())).addValue(new Value<Integer>(DataSetDataType.UInt16, this.getRandomUInt16())).addValue(new Value<Long>(DataSetDataType.UInt32, this.getRandomUInt32())).addValue(new Value<BigInteger>(DataSetDataType.UInt64, this.getRandomUInt64())).addValue(new Value<Float>(DataSetDataType.Float, Float.valueOf(this.random.nextFloat()))).addValue(new Value<Double>(DataSetDataType.Double, this.random.nextDouble())).addValue(new Value<Boolean>(DataSetDataType.Boolean, this.random.nextBoolean())).addValue(new Value<String>(DataSetDataType.String, UUID.randomUUID().toString())).addValue(new Value<Date>(DataSetDataType.DateTime, new Date())).addValue(new Value<String>(DataSetDataType.Text, UUID.randomUUID().toString())).createRow()).createDataSet();
    }

    private Template newSimpleTemplate(boolean isDef, String templatRef) throws SparkplugException {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        metrics.add(new Metric.MetricBuilder("MyInt8", MetricDataType.Int8, (Object)this.getRandomInt8()).createMetric());
        metrics.add(new Metric.MetricBuilder("MyInt16", MetricDataType.Int16, (Object)this.getRandomInt16()).createMetric());
        metrics.add(new Metric.MetricBuilder("MyInt32", MetricDataType.Int32, (Object)this.getRandomInt32()).createMetric());
        metrics.add(new Metric.MetricBuilder("MyInt64", MetricDataType.Int64, (Object)this.getRandomInt64()).createMetric());
        metrics.add(new Metric.MetricBuilder("MyUInt8", MetricDataType.UInt8, (Object)this.getRandomUInt8()).createMetric());
        metrics.add(new Metric.MetricBuilder("MyUInt16", MetricDataType.UInt16, (Object)this.getRandomUInt16()).createMetric());
        metrics.add(new Metric.MetricBuilder("MyUInt32", MetricDataType.UInt32, (Object)this.getRandomUInt32()).createMetric());
        metrics.add(new Metric.MetricBuilder("MyUInt64", MetricDataType.UInt64, (Object)this.getRandomUInt64()).createMetric());
        metrics.add(new Metric.MetricBuilder("MyFloat", MetricDataType.Float, (Object)Float.valueOf(this.random.nextFloat())).createMetric());
        metrics.add(new Metric.MetricBuilder("MyDouble", MetricDataType.Double, (Object)this.random.nextDouble()).createMetric());
        metrics.add(new Metric.MetricBuilder("MyBoolean", MetricDataType.Boolean, (Object)this.random.nextBoolean()).createMetric());
        metrics.add(new Metric.MetricBuilder("MyString", MetricDataType.String, (Object)this.getRandomString(10)).createMetric());
        metrics.add(new Metric.MetricBuilder("MyDateTime", MetricDataType.DateTime, (Object)new Date()).createMetric());
        metrics.add(new Metric.MetricBuilder("MyText", MetricDataType.Text, (Object)this.getRandomString(10)).createMetric());
        metrics.add(new Metric.MetricBuilder("MyUUID", MetricDataType.UUID, (Object)UUID.randomUUID().toString()).createMetric());
        return new Template.TemplateBuilder().version("v1.0").templateRef(templatRef).definition(isDef).addParameters(this.newParams()).addMetrics(metrics).createTemplate();
    }

    private List<Parameter> newParams() throws SparkplugException {
        Random random = new Random();
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(new Parameter("ParamInt32", ParameterDataType.Int32, random.nextInt()));
        params.add(new Parameter("ParamFloat", ParameterDataType.Float, Float.valueOf(random.nextFloat())));
        params.add(new Parameter("ParamDouble", ParameterDataType.Double, random.nextDouble()));
        params.add(new Parameter("ParamBoolean", ParameterDataType.Boolean, random.nextBoolean()));
        params.add(new Parameter("ParamString", ParameterDataType.String, UUID.randomUUID().toString()));
        return params;
    }

    private List<Metric> newComplexTemplateDefs() throws Exception {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        metrics.add(new Metric.MetricBuilder("subType", MetricDataType.Template, (Object)new Template.TemplateBuilder().definition(true).addParameters(this.newParams()).addMetric(new Metric.MetricBuilder("StringMember", MetricDataType.String, (Object)"value").createMetric()).addMetric(new Metric.MetricBuilder("IntegerMember", MetricDataType.Int32, (Object)0).createMetric()).createTemplate()).createMetric());
        metrics.add(new Metric.MetricBuilder("complexType", MetricDataType.Template, (Object)new Template.TemplateBuilder().definition(true).addParameters(this.newParams()).addMetric(new Metric.MetricBuilder("subType", MetricDataType.Template, (Object)new Template.TemplateBuilder().definition(false).templateRef("subType").addMetric(new Metric.MetricBuilder("StringMember", MetricDataType.String, (Object)"value").createMetric()).addMetric(new Metric.MetricBuilder("IntegerMember", MetricDataType.Int32, (Object)0).createMetric()).createTemplate()).createMetric()).createTemplate()).createMetric());
        return metrics;
    }

    private Template newComplexTemplateInstance() throws Exception {
        return new Template.TemplateBuilder().definition(false).templateRef("complexType").addParameters(this.newParams()).addMetric(new Metric.MetricBuilder("subType", MetricDataType.Template, (Object)new Template.TemplateBuilder().definition(false).templateRef("subType").addParameters(this.newParams()).addMetric(new Metric.MetricBuilder("StringMember", MetricDataType.String, (Object)"myValue").createMetric()).addMetric(new Metric.MetricBuilder("IntegerMember", MetricDataType.Int32, (Object)1).createMetric()).createTemplate()).createMetric()).createTemplate();
    }

    private byte getRandomInt8() {
        byte[] bytes = new byte[1];
        this.random.nextBytes(bytes);
        return bytes[0];
    }

    private short getRandomInt16() {
        return (short)this.random.nextInt(65536);
    }

    private int getRandomInt32() {
        return this.random.nextInt();
    }

    private long getRandomInt64() {
        return this.random.nextLong();
    }

    private short getRandomUInt8() {
        return (short)this.random.nextInt(32768);
    }

    private int getRandomUInt16() {
        return ThreadLocalRandom.current().nextInt(0, 64535);
    }

    private long getRandomUInt32() {
        return ThreadLocalRandom.current().nextLong(0x100000000L);
    }

    private BigInteger getRandomUInt64() {
        BigInteger minSize = new BigInteger("0");
        BigInteger maxSize = new BigInteger("18446744073709551616");
        BigInteger randomResult = new BigInteger(64, this.random);
        while (randomResult.compareTo(minSize) <= 0 || randomResult.compareTo(maxSize) >= 0) {
            randomResult = new BigInteger(64, this.random);
        }
        return randomResult;
    }

    private String getRandomString(int length) {
        return RandomStringUtils.randomAlphanumeric(length).toUpperCase();
    }
}

