/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.edge;

import java.util.List;
import org.eclipse.tahu.edge.EdgeClient;
import org.eclipse.tahu.edge.sim.DataSimulator;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicPublisher
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(PeriodicPublisher.class.getName());
    private final long period;
    private final DataSimulator dataSimulator;
    private final EdgeClient edgeClient;
    private final EdgeNodeDescriptor edgeNodeDescriptor;
    private final List<DeviceDescriptor> deviceDescriptors;
    private volatile boolean stayRunning;

    public PeriodicPublisher(long period, DataSimulator dataSimulator, EdgeClient edgeClient, EdgeNodeDescriptor edgeNodeDescriptor, List<DeviceDescriptor> deviceDescriptors) {
        this.period = period;
        this.dataSimulator = dataSimulator;
        this.edgeClient = edgeClient;
        this.edgeNodeDescriptor = edgeNodeDescriptor;
        this.deviceDescriptors = deviceDescriptors;
        this.stayRunning = true;
    }

    @Override
    public void run() {
        try {
            while (this.stayRunning) {
                Thread.sleep(this.period);
                SparkplugBPayload nDataPayload = this.dataSimulator.getNodeDataPayload(this.edgeNodeDescriptor);
                this.edgeClient.publishNodeData(nDataPayload);
                for (DeviceDescriptor deviceDescriptor : this.deviceDescriptors) {
                    SparkplugBPayload dDataPayload = this.dataSimulator.getDeviceDataPayload(deviceDescriptor);
                    this.edgeClient.publishDeviceData(deviceDescriptor.getDeviceId(), dDataPayload);
                }
            }
        }
        catch (InterruptedException e) {
            logger.error("Failed to continue periodic publishing");
        }
    }

    public void shutdown() {
        this.stayRunning = false;
    }
}

