/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import java.util.Collections;
import java.util.Map;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.Weak;
import org.eclipse.sisu.launch.SisuTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class SisuExtender
implements BundleActivator {
    private static final Map<Long, MutableBeanLocator> locators = Collections.synchronizedMap(Weak.values());
    protected SisuTracker tracker;

    public void start(BundleContext context) {
        this.tracker = this.createTracker(context);
        this.tracker.open();
    }

    public void stop(BundleContext context) {
        this.tracker.close();
        this.tracker = null;
    }

    protected int bundleStateMask() {
        return 40;
    }

    protected SisuTracker createTracker(BundleContext context) {
        return new SisuTracker(context, this.bundleStateMask(), this.findLocator(context));
    }

    protected MutableBeanLocator createLocator(BundleContext context) {
        return new DefaultBeanLocator();
    }

    protected final MutableBeanLocator findLocator(BundleContext context) {
        Long extenderId = context.getBundle().getBundleId();
        MutableBeanLocator locator = locators.get(extenderId);
        if (locator == null) {
            locator = this.createLocator(context);
            locators.put(extenderId, locator);
        }
        return locator;
    }
}

