/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import java.util.Timer;
import org.eclipse.rdf4j.common.iteration.InterruptTask;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeLimitIteration<E, X extends Exception>
extends IterationWrapper<E, X> {
    private static final Timer timer = new Timer("TimeLimitIteration", true);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InterruptTask<E, X> interruptTask;
    private volatile boolean isInterrupted = false;

    public TimeLimitIteration(Iteration<? extends E, ? extends X> iter, long timeLimit) {
        super(iter);
        assert (timeLimit > 0L) : "time limit must be a positive number, is: " + timeLimit;
        this.interruptTask = new InterruptTask(this);
        timer.schedule(this.interruptTask, timeLimit);
    }

    @Override
    public boolean hasNext() throws X {
        this.checkInterrupted();
        try {
            boolean result = super.hasNext();
            this.checkInterrupted();
            return result;
        }
        catch (NoSuchElementException e) {
            this.checkInterrupted();
            throw e;
        }
    }

    @Override
    public E next() throws X {
        this.checkInterrupted();
        try {
            return super.next();
        }
        catch (NoSuchElementException e) {
            this.checkInterrupted();
            throw e;
        }
    }

    @Override
    public void remove() throws X {
        this.checkInterrupted();
        super.remove();
    }

    @Override
    protected void handleClose() throws X {
        this.interruptTask.cancel();
        super.handleClose();
    }

    private final void checkInterrupted() throws X {
        if (this.isInterrupted) {
            this.throwInterruptedException();
        }
    }

    protected abstract void throwInterruptedException() throws X;

    void interrupt() {
        this.isInterrupted = true;
        if (!this.isClosed()) {
            try {
                this.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close iteration", (Throwable)e);
            }
        }
    }
}

