/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;

public abstract class DelayedIteration<E, X extends Exception>
extends AbstractCloseableIteration<E, X> {
    private Iteration<? extends E, ? extends X> iter;

    protected abstract Iteration<? extends E, ? extends X> createIteration() throws X;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() throws X {
        if (this.iter == null) {
            DelayedIteration delayedIteration = this;
            synchronized (delayedIteration) {
                if (this.isClosed()) {
                    return false;
                }
                this.iter = this.createIteration();
            }
        }
        return this.iter.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() throws X {
        if (this.iter == null) {
            DelayedIteration delayedIteration = this;
            synchronized (delayedIteration) {
                if (this.isClosed()) {
                    throw new NoSuchElementException("Iteration has been closed");
                }
                this.iter = this.createIteration();
            }
        }
        return this.iter.next();
    }

    @Override
    public void remove() throws X {
        if (this.iter == null || this.isClosed()) {
            throw new IllegalStateException();
        }
        this.iter.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClose() throws X {
        super.handleClose();
        DelayedIteration delayedIteration = this;
        synchronized (delayedIteration) {
            Iterations.closeCloseable(this.iter);
        }
    }
}

