/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.turtle;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.rdf4j.common.io.IndentingWriter;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleIRI;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class TurtleWriter
extends AbstractRDFWriter
implements RDFWriter {
    private static final int LINE_WRAP = 80;
    private static final IRI FIRST = new SimpleIRI(RDF.FIRST.stringValue()){
        private static final long serialVersionUID = -7951518099940758898L;
    };
    private static final IRI REST = new SimpleIRI(RDF.REST.stringValue()){
        private static final long serialVersionUID = -7951518099940758898L;
    };
    protected ParsedIRI baseIRI;
    protected IndentingWriter writer;
    protected boolean writingStarted;
    protected boolean statementClosed;
    protected Resource lastWrittenSubject;
    protected IRI lastWrittenPredicate;
    @Deprecated
    protected Model prettyPrintModel;
    private final Deque<Resource> stack = new LinkedList<Resource>();
    private final Deque<IRI> path = new LinkedList<IRI>();
    private Boolean xsdStringToPlainLiteral;
    private Boolean prettyPrint;
    private boolean inlineBNodes;

    public TurtleWriter(OutputStream out) {
        this(out, null);
    }

    public TurtleWriter(OutputStream out, ParsedIRI baseIRI) {
        this(new OutputStreamWriter(out, StandardCharsets.UTF_8), baseIRI);
    }

    public TurtleWriter(Writer writer) {
        this(writer, null);
    }

    public TurtleWriter(Writer writer, ParsedIRI baseIRI) {
        this.baseIRI = baseIRI;
        this.writer = new IndentingWriter(writer);
        this.namespaceTable = new LinkedHashMap();
        this.writingStarted = false;
        this.statementClosed = true;
        this.lastWrittenSubject = null;
        this.lastWrittenPredicate = null;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.TURTLE;
    }

    public void startRDF() throws RDFHandlerException {
        if (this.writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        this.writingStarted = true;
        try {
            this.xsdStringToPlainLiteral = (Boolean)this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
            this.prettyPrint = (Boolean)this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT);
            this.inlineBNodes = (Boolean)this.getWriterConfig().get(BasicWriterSettings.INLINE_BLANK_NODES);
            if (this.prettyPrint.booleanValue()) {
                this.writer.setIndentationString("  ");
            } else {
                this.writer.setIndentationString("");
            }
            if (this.baseIRI != null && ((Boolean)this.getWriterConfig().get(BasicWriterSettings.BASE_DIRECTIVE)).booleanValue()) {
                this.writeBase(this.baseIRI.toString());
            }
            for (Map.Entry entry : this.namespaceTable.entrySet()) {
                String name = (String)entry.getKey();
                String prefix = (String)entry.getValue();
                this.writeNamespace(prefix, name);
            }
            if (!this.namespaceTable.isEmpty()) {
                this.writer.writeEOL();
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            this.closePreviousStatement();
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        finally {
            this.writingStarted = false;
        }
    }

    public void handleNamespace(String prefix, String name) throws RDFHandlerException {
        try {
            if (!this.namespaceTable.containsKey(name)) {
                boolean isLegalPrefix;
                boolean bl = isLegalPrefix = prefix.length() == 0 || TurtleUtil.isPN_PREFIX(prefix);
                if (!isLegalPrefix || this.namespaceTable.containsValue(prefix)) {
                    if (prefix.length() == 0 || !isLegalPrefix) {
                        prefix = "ns";
                    }
                    int number = 1;
                    while (this.namespaceTable.containsValue(prefix + number)) {
                        ++number;
                    }
                    prefix = prefix + number;
                }
                this.namespaceTable.put(name, prefix);
                if (this.writingStarted) {
                    this.closePreviousStatement();
                    this.writeNamespace(prefix, name);
                }
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        try {
            Resource subj = st.getSubject();
            IRI pred = st.getPredicate();
            if (this.inlineBNodes && (pred.equals((Object)RDF.FIRST) || pred.equals((Object)RDF.REST))) {
                this.handleList(st);
            } else if (this.inlineBNodes && !subj.equals(this.lastWrittenSubject) && this.stack.contains(subj)) {
                this.handleInlineNode(st);
            } else {
                this.closeHangingResource();
                this.handleStatementInternal(st, false, this.inlineBNodes, this.inlineBNodes);
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    protected void handleStatementInternal(Statement st, boolean endRDFCalled, boolean canShortenSubjectBNode, boolean canShortenObjectBNode) {
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        try {
            if (subj.equals(this.lastWrittenSubject)) {
                if (pred.equals((Object)this.lastWrittenPredicate)) {
                    this.writer.write(",");
                    this.wrapLine(this.prettyPrint);
                } else {
                    this.writer.write(";");
                    this.writer.writeEOL();
                    this.writer.decreaseIndentation();
                    this.writePredicate(pred);
                    this.writer.increaseIndentation();
                    this.wrapLine(true);
                    this.path.removeLast();
                    this.path.addLast(pred);
                    this.lastWrittenPredicate = pred;
                }
            } else {
                this.closePreviousStatement();
                this.stack.addLast(subj);
                if (this.prettyPrint.booleanValue()) {
                    this.writer.writeEOL();
                }
                this.writeResource(subj, canShortenSubjectBNode);
                this.wrapLine(true);
                this.writer.increaseIndentation();
                this.lastWrittenSubject = subj;
                this.writePredicate(pred);
                this.wrapLine(true);
                this.path.addLast(pred);
                this.lastWrittenPredicate = pred;
                this.statementClosed = false;
                this.writer.increaseIndentation();
            }
            this.writeValue(obj, canShortenObjectBNode);
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        try {
            this.closePreviousStatement();
            if (comment.indexOf(13) != -1 || comment.indexOf(10) != -1) {
                StringTokenizer st = new StringTokenizer(comment, "\r\n");
                while (st.hasMoreTokens()) {
                    this.writeCommentLine(st.nextToken());
                }
            } else {
                this.writeCommentLine(comment);
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    protected void writeCommentLine(String line) throws IOException {
        this.writer.write("# ");
        this.writer.write(line);
        this.writer.writeEOL();
    }

    protected void writeBase(String baseURI) throws IOException {
        this.writer.write("@base <");
        this.writer.write(TurtleUtil.encodeURIString(baseURI));
        this.writer.write("> .");
        this.writer.writeEOL();
    }

    protected void writeNamespace(String prefix, String name) throws IOException {
        this.writer.write("@prefix ");
        this.writer.write(prefix);
        this.writer.write(": <");
        this.writer.write(TurtleUtil.encodeURIString(name));
        this.writer.write("> .");
        this.writer.writeEOL();
    }

    protected void writePredicate(IRI predicate) throws IOException {
        if (predicate.equals((Object)RDF.TYPE)) {
            this.writer.write("a");
        } else {
            this.writeURI(predicate);
        }
    }

    @Deprecated
    protected void writeValue(Value val) throws IOException {
        this.writeValue(val, false);
    }

    protected void writeValue(Value val, boolean canShorten) throws IOException {
        if (val instanceof BNode && canShorten && !val.equals(this.stack.peekLast()) && !val.equals(this.lastWrittenSubject)) {
            this.stack.addLast((Resource)((BNode)val));
        } else if (val instanceof Resource) {
            this.writeResource((Resource)val, canShorten);
        } else {
            this.writeLiteral((Literal)val);
        }
    }

    @Deprecated
    protected void writeResource(Resource res) throws IOException {
        this.writeResource(res, false);
    }

    protected void writeResource(Resource res, boolean canShorten) throws IOException {
        if (res instanceof IRI) {
            this.writeURI((IRI)res);
        } else {
            this.writeBNode((BNode)res, canShorten);
        }
    }

    protected void writeURI(IRI uri) throws IOException {
        String uriString = uri.toString();
        String prefix = null;
        int splitIdx = TurtleUtil.findURISplitIndex(uriString);
        if (splitIdx > 0) {
            String namespace = uriString.substring(0, splitIdx);
            prefix = (String)this.namespaceTable.get(namespace);
        }
        if (prefix != null) {
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write(uriString.substring(splitIdx));
        } else if (this.baseIRI != null) {
            this.writer.write("<");
            this.writer.write(TurtleUtil.encodeURIString(this.baseIRI.relativize(uriString)));
            this.writer.write(">");
        } else {
            this.writer.write("<");
            this.writer.write(TurtleUtil.encodeURIString(uriString));
            this.writer.write(">");
        }
    }

    @Deprecated
    protected void writeBNode(BNode bNode) throws IOException {
        this.writeBNode(bNode, false);
    }

    protected void writeBNode(BNode bNode, boolean canShorten) throws IOException {
        if (canShorten) {
            this.writer.write("[]");
            return;
        }
        this.writer.write("_:");
        String id = bNode.getID();
        if (id.isEmpty()) {
            if (((Boolean)this.getWriterConfig().get(BasicParserSettings.PRESERVE_BNODE_IDS)).booleanValue()) {
                throw new IOException("Cannot consistently write blank nodes with empty internal identifiers");
            }
            this.writer.write("genid-hash-");
            this.writer.write(Integer.toHexString(System.identityHashCode(bNode)));
        } else {
            if (!TurtleUtil.isNameStartChar(id.charAt(0))) {
                this.writer.write("genid-start-");
                this.writer.write(Integer.toHexString(id.charAt(0)));
            } else {
                this.writer.write((int)id.charAt(0));
            }
            for (int i = 1; i < id.length() - 1; ++i) {
                if (TurtleUtil.isPN_CHARS(id.charAt(i))) {
                    this.writer.write((int)id.charAt(i));
                    continue;
                }
                this.writer.write(Integer.toHexString(id.charAt(i)));
            }
            if (id.length() > 1) {
                if (!TurtleUtil.isNameEndChar(id.charAt(id.length() - 1))) {
                    this.writer.write(Integer.toHexString(id.charAt(id.length() - 1)));
                } else {
                    this.writer.write((int)id.charAt(id.length() - 1));
                }
            }
        }
    }

    protected void writeLiteral(Literal lit) throws IOException {
        String label = lit.getLabel();
        IRI datatype = lit.getDatatype();
        if (this.prettyPrint.booleanValue() && (XMLSchema.INTEGER.equals((Object)datatype) || XMLSchema.DECIMAL.equals((Object)datatype) || XMLSchema.DOUBLE.equals((Object)datatype) || XMLSchema.BOOLEAN.equals((Object)datatype))) {
            try {
                String normalized = XMLDatatypeUtil.normalize((String)label, (IRI)datatype);
                if (!(normalized.equals("INF") || normalized.equals("-INF") || normalized.equals("NaN"))) {
                    this.writer.write(normalized);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (label.indexOf(10) != -1 || label.indexOf(13) != -1 || label.indexOf(9) != -1) {
            this.writer.write("\"\"\"");
            this.writer.write(TurtleUtil.encodeLongString(label));
            this.writer.write("\"\"\"");
        } else {
            this.writer.write("\"");
            this.writer.write(TurtleUtil.encodeString(label));
            this.writer.write("\"");
        }
        if (Literals.isLanguageLiteral((Literal)lit)) {
            this.writer.write("@");
            this.writer.write((String)lit.getLanguage().get());
        } else if (!this.xsdStringToPlainLiteral.booleanValue() || !XMLSchema.STRING.equals((Object)datatype)) {
            this.writer.write("^^");
            this.writeURI(datatype);
        }
    }

    protected void closePreviousStatement() throws IOException {
        this.closeNestedResources(null);
        if (!this.statementClosed) {
            this.writer.write(" .");
            this.writer.writeEOL();
            this.writer.decreaseIndentation();
            this.writer.decreaseIndentation();
            this.stack.pollLast();
            this.path.pollLast();
            assert (this.stack.isEmpty());
            assert (this.path.isEmpty());
            this.statementClosed = true;
            this.lastWrittenSubject = null;
            this.lastWrittenPredicate = null;
        }
    }

    private boolean isHanging() {
        return !this.stack.isEmpty() && this.lastWrittenSubject != null && !this.lastWrittenSubject.equals(this.stack.peekLast());
    }

    private void closeHangingResource() throws IOException {
        if (this.isHanging()) {
            Value val = (Value)this.stack.pollLast();
            if (val instanceof Resource) {
                this.writeResource((Resource)val, this.inlineBNodes);
            } else {
                this.writeLiteral((Literal)val);
            }
            assert (this.lastWrittenSubject.equals(this.stack.peekLast()));
        }
    }

    private void closeNestedResources(Resource subj) throws IOException {
        this.closeHangingResource();
        while (this.stack.size() > 1 && !this.stack.peekLast().equals(subj)) {
            if (this.prettyPrint.booleanValue()) {
                this.writer.writeEOL();
            }
            this.writer.decreaseIndentation();
            this.writer.decreaseIndentation();
            this.writer.write("]");
            this.stack.pollLast();
            this.path.pollLast();
            this.lastWrittenSubject = this.stack.peekLast();
            this.lastWrittenPredicate = this.path.peekLast();
        }
    }

    private void handleInlineNode(Statement st) throws IOException {
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        if (this.isHanging() && subj.equals(this.stack.peekLast())) {
            this.lastWrittenSubject = subj;
            this.writer.write("[");
            if (this.prettyPrint.booleanValue() && !RDF.TYPE.equals((Object)pred)) {
                this.writer.writeEOL();
            } else {
                this.wrapLine(this.prettyPrint);
            }
            this.writer.increaseIndentation();
            this.writePredicate(pred);
            this.writer.increaseIndentation();
            this.wrapLine(true);
            this.path.addLast(pred);
            this.lastWrittenPredicate = pred;
            this.writeValue(st.getObject(), this.inlineBNodes);
        } else if (!subj.equals(this.lastWrittenSubject) && this.stack.contains(subj)) {
            this.closeNestedResources(subj);
            this.handleStatementInternal(st, false, this.inlineBNodes, this.inlineBNodes);
        } else assert (false);
    }

    private void handleList(Statement st) throws IOException {
        boolean nil;
        Resource subj = st.getSubject();
        boolean first = RDF.FIRST.equals((Object)st.getPredicate());
        boolean rest = RDF.REST.equals((Object)st.getPredicate()) && !RDF.NIL.equals((Object)st.getObject());
        boolean bl = nil = RDF.REST.equals((Object)st.getPredicate()) && RDF.NIL.equals((Object)st.getObject());
        if (first && REST != this.lastWrittenPredicate && this.isHanging()) {
            this.writer.write("(");
            this.writer.increaseIndentation();
            this.wrapLine(false);
            this.lastWrittenSubject = subj;
            this.path.addLast(FIRST);
            this.lastWrittenPredicate = FIRST;
            this.writeValue(st.getObject(), this.inlineBNodes);
        } else if (first && REST == this.lastWrittenPredicate) {
            this.lastWrittenSubject = subj;
            this.path.addLast(FIRST);
            this.lastWrittenPredicate = FIRST;
            this.writeValue(st.getObject(), this.inlineBNodes);
        } else {
            this.closeNestedResources(subj);
            if (rest && FIRST == this.lastWrittenPredicate) {
                this.wrapLine(true);
                this.path.removeLast();
                this.path.addLast(REST);
                this.lastWrittenPredicate = REST;
                this.writeValue(st.getObject(), this.inlineBNodes);
            } else if (nil && FIRST == this.lastWrittenPredicate) {
                this.writer.decreaseIndentation();
                this.writer.write(")");
                this.path.removeLast();
                this.path.addLast(REST);
                while (REST == this.path.peekLast()) {
                    this.stack.pollLast();
                    this.path.pollLast();
                    this.lastWrittenSubject = this.stack.peekLast();
                    this.lastWrittenPredicate = this.path.peekLast();
                }
            } else {
                this.handleStatementInternal(st, false, this.inlineBNodes, this.inlineBNodes);
            }
        }
    }

    private void wrapLine(boolean space) throws IOException {
        if (this.prettyPrint.booleanValue() && this.writer.getCharactersSinceEOL() > 80) {
            this.writer.writeEOL();
        } else if (space) {
            this.writer.write(" ");
        }
    }
}

