/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql.ast;

import java.util.Map;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOperationContainer;
import org.eclipse.rdf4j.query.parser.sparql.ast.Node;
import org.eclipse.rdf4j.query.parser.sparql.ast.SimpleNode;
import org.eclipse.rdf4j.query.parser.sparql.ast.SyntaxTreeBuilder;
import org.eclipse.rdf4j.query.parser.sparql.ast.SyntaxTreeBuilderVisitor;
import org.eclipse.rdf4j.query.parser.sparql.ast.VisitorException;

public class ASTServiceGraphPattern
extends SimpleNode {
    private boolean silent;
    private String patternString;
    private Map<String, String> prefixDeclarations;
    private String baseURI;
    private int beginTokenLinePos;
    private int beginTokenColumnPos;
    private int endTokenLinePos;
    private int endTokenColumnPos;

    public ASTServiceGraphPattern(int id) {
        super(id);
    }

    public ASTServiceGraphPattern(SyntaxTreeBuilder p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(SyntaxTreeBuilderVisitor visitor, Object data) throws VisitorException {
        return visitor.visit(this, data);
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public String getPatternString() {
        if (this.patternString == null) {
            String sourceString;
            ASTOperationContainer parentContainer = (ASTOperationContainer)this.getParentContainer(this);
            String substring = sourceString = parentContainer.getSourceString();
            for (int i = 1; i < this.getBeginTokenLinePos(); ++i) {
                substring = substring.substring(substring.indexOf("\n") + 1);
            }
            substring = substring.substring(this.getBeginTokenColumnPos() - 1);
            String toTrimSuffix = sourceString;
            for (int i = 1; i < this.getEndTokenLinePos(); ++i) {
                toTrimSuffix = toTrimSuffix.substring(toTrimSuffix.indexOf("\n") + 1);
            }
            toTrimSuffix = toTrimSuffix.substring(this.getEndTokenColumnPos() - 1);
            this.patternString = substring.substring(0, substring.lastIndexOf(toTrimSuffix) + 1);
        }
        return this.patternString;
    }

    private Node getParentContainer(Node node) {
        if (node instanceof ASTOperationContainer || node == null) {
            return node;
        }
        return this.getParentContainer(node.jjtGetParent());
    }

    public void setPrefixDeclarations(Map<String, String> prefixDeclarations) {
        this.prefixDeclarations = prefixDeclarations;
    }

    public Map<String, String> getPrefixDeclarations() {
        return this.prefixDeclarations;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setEndTokenColumnPos(int endTokenColumnPos) {
        this.endTokenColumnPos = endTokenColumnPos;
    }

    public int getEndTokenColumnPos() {
        return this.endTokenColumnPos;
    }

    public void setEndTokenLinePos(int endTokenLinePos) {
        this.endTokenLinePos = endTokenLinePos;
    }

    public int getEndTokenLinePos() {
        return this.endTokenLinePos;
    }

    public void setBeginTokenColumnPos(int beginTokenColumnPos) {
        this.beginTokenColumnPos = beginTokenColumnPos;
    }

    public int getBeginTokenColumnPos() {
        return this.beginTokenColumnPos;
    }

    public void setBeginTokenLinePos(int beginTokenLinePos) {
        this.beginTokenLinePos = beginTokenLinePos;
    }

    public int getBeginTokenLinePos() {
        return this.beginTokenLinePos;
    }
}

