/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.dawg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.GraphImpl;
import org.eclipse.rdf4j.model.util.GraphUtil;
import org.eclipse.rdf4j.model.util.GraphUtilException;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetSchema;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class DAWGTestResultSetParser
extends AbstractRDFHandler {
    private final TupleQueryResultHandler tqrHandler;
    private Graph graph = new GraphImpl();

    public DAWGTestResultSetParser(TupleQueryResultHandler tqrHandler) {
        this.tqrHandler = tqrHandler;
    }

    public void startRDF() throws RDFHandlerException {
        this.graph.clear();
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.graph.add((Object)st);
    }

    public void endRDF() throws RDFHandlerException {
        try {
            Resource resultSetNode = GraphUtil.getUniqueSubject((Graph)this.graph, (IRI)RDF.TYPE, (Value)DAWGTestResultSetSchema.RESULTSET, (Resource[])new Resource[0]);
            List<String> bindingNames = this.getBindingNames(resultSetNode);
            this.tqrHandler.startQueryResult(bindingNames);
            Iterator solIter = GraphUtil.getObjectIterator((Graph)this.graph, (Resource)resultSetNode, (IRI)DAWGTestResultSetSchema.SOLUTION, (Resource[])new Resource[0]);
            while (solIter.hasNext()) {
                Value solutionNode = (Value)solIter.next();
                if (solutionNode instanceof Resource) {
                    this.reportSolution((Resource)solutionNode, bindingNames);
                    continue;
                }
                throw new RDFHandlerException("Value for " + DAWGTestResultSetSchema.SOLUTION + " is not a resource: " + solutionNode);
            }
            this.tqrHandler.endQueryResult();
        }
        catch (GraphUtilException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)e);
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private List<String> getBindingNames(Resource resultSetNode) throws RDFHandlerException {
        ArrayList<String> bindingNames = new ArrayList<String>(16);
        Iterator varIter = GraphUtil.getObjectIterator((Graph)this.graph, (Resource)resultSetNode, (IRI)DAWGTestResultSetSchema.RESULTVARIABLE, (Resource[])new Resource[0]);
        while (varIter.hasNext()) {
            Value varName = (Value)varIter.next();
            if (varName instanceof Literal) {
                bindingNames.add(((Literal)varName).getLabel());
                continue;
            }
            throw new RDFHandlerException("Value for " + DAWGTestResultSetSchema.RESULTVARIABLE + " is not a literal: " + varName);
        }
        return bindingNames;
    }

    private void reportSolution(Resource solutionNode, List<String> bindingNames) throws RDFHandlerException, GraphUtilException {
        MapBindingSet bindingSet = new MapBindingSet(bindingNames.size());
        Iterator bindingIter = GraphUtil.getObjectIterator((Graph)this.graph, (Resource)solutionNode, (IRI)DAWGTestResultSetSchema.BINDING, (Resource[])new Resource[0]);
        while (bindingIter.hasNext()) {
            Value bindingNode = (Value)bindingIter.next();
            if (bindingNode instanceof Resource) {
                Binding binding = this.getBinding((Resource)bindingNode);
                bindingSet.addBinding(binding);
                continue;
            }
            throw new RDFHandlerException("Value for " + DAWGTestResultSetSchema.BINDING + " is not a resource: " + bindingNode);
        }
        try {
            this.tqrHandler.handleSolution(bindingSet);
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RDFHandlerException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private Binding getBinding(Resource bindingNode) throws GraphUtilException {
        Literal name = GraphUtil.getUniqueObjectLiteral((Graph)this.graph, (Resource)bindingNode, (IRI)DAWGTestResultSetSchema.VARIABLE);
        Value value = GraphUtil.getUniqueObject((Graph)this.graph, (Resource)bindingNode, (IRI)DAWGTestResultSetSchema.VALUE, (Resource[])new Resource[0]);
        return new SimpleBinding(name.getLabel(), value);
    }
}

