/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

public class SimpleStatement
implements Statement {
    private static final long serialVersionUID = 8707542157460228077L;
    private final Resource subject;
    private final IRI predicate;
    private final Value object;

    protected SimpleStatement(Resource subject, IRI predicate, Value object) {
        this.subject = Objects.requireNonNull(subject, "subject must not be null");
        this.predicate = Objects.requireNonNull(predicate, "predicate must not be null");
        this.object = Objects.requireNonNull(object, "object must not be null");
    }

    @Override
    public Resource getSubject() {
        return this.subject;
    }

    @Override
    public IRI getPredicate() {
        return this.predicate;
    }

    @Override
    public Value getObject() {
        return this.object;
    }

    @Override
    public Resource getContext() {
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Statement) {
            Statement that = (Statement)other;
            return this.object.equals(that.getObject()) && this.subject.equals(that.getSubject()) && this.predicate.equals(that.getPredicate()) && Objects.equals(this.getContext(), that.getContext());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subject, this.predicate, this.object, this.getContext());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("(");
        sb.append(this.getSubject());
        sb.append(", ");
        sb.append(this.getPredicate());
        sb.append(", ");
        sb.append(this.getObject());
        sb.append(")");
        return sb.toString();
    }
}

