/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Timeout(value=1000L, unit=TimeUnit.MILLISECONDS)
public abstract class ModelTest {
    protected Literal literal1;
    protected Literal literal2;
    protected Literal literal3;
    protected IRI uri1;
    protected IRI uri2;
    protected IRI uri3;
    protected BNode bnode1;
    protected BNode bnode2;
    protected BNode bnode3;
    protected final ValueFactory vf = SimpleValueFactory.getInstance();

    protected abstract Model getNewModel();

    protected Model getNewEmptyModel() {
        Model model = this.getNewModel();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)model.isEmpty());
        return model;
    }

    protected Model getNewModelObjectSingleLiteral() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleURI() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri2, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleBNode() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectDoubleLiteral() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal2, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectDoubleURI() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri2, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri3, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectDoubleBNode() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode2, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleLiteralSingleURI() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri2, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleLiteralSingleBNode() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleURISingleBNode() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectTripleLiteral() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal2, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal3, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectTripleURI() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri2, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri3, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectTripleBNode() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode2, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode3, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleLiteralSingleURISingleBNode() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri2, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleLiteralDoubleURI() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri2, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri3, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleLiteralDoubleBNode() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode2, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleURIDoubleBNode() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode2, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleURIDoubleLiteral() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal2, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleBNodeDoubleURI() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri2, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri3, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)model.size());
        return model;
    }

    protected Model getNewModelObjectSingleBNodeDoubleLiteral() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal2, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)model.size());
        return model;
    }

    protected Model getNewModelTwoContexts() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.bnode1, new Resource[]{this.uri1});
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[]{this.uri1});
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal2, new Resource[]{this.uri2});
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)model.size());
        return model;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.uri1 = this.vf.createIRI("urn:test:uri:1");
        this.uri2 = this.vf.createIRI("urn:test:uri:2");
        this.uri3 = this.vf.createIRI("urn:test:uri:3");
        this.bnode1 = this.vf.createBNode();
        this.bnode2 = this.vf.createBNode("bnode2");
        this.bnode3 = this.vf.createBNode("bnode3");
        this.literal1 = this.vf.createLiteral("test literal 1");
        this.literal2 = this.vf.createLiteral("test literal 2");
        this.literal3 = this.vf.createLiteral("test literal 3");
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetStatements_SingleLiteral() {
        Model model = this.getNewModelObjectSingleLiteral();
        Iterator selection = model.getStatements(null, null, (Value)this.literal1, new Resource[0]).iterator();
        Assertions.assertThat((boolean)selection.hasNext()).isTrue();
        Assertions.assertThat((Object)((Statement)selection.next()).getObject()).isEqualTo((Object)this.literal1);
        Assertions.assertThat((boolean)selection.hasNext()).isFalse();
    }

    @Test
    public void testGetStatements_IteratorModification() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri2, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri3, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal2, new Resource[0]);
        Iterator selection = model.getStatements((Resource)this.uri1, null, null, new Resource[0]).iterator();
        while (selection.hasNext()) {
            Statement st = (Statement)selection.next();
            if (!st.getObject().equals(this.uri2)) continue;
            selection.remove();
        }
        Assertions.assertThat((boolean)model.contains((Resource)this.uri1, RDFS.LABEL, (Value)this.uri2, new Resource[0])).isFalse();
        Assertions.assertThat((boolean)model.contains((Resource)this.uri1, RDFS.LABEL, (Value)this.uri3, new Resource[0])).isTrue();
    }

    @Test
    public void testGetStatements_ConcurrentModificationOfModel() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri2, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.uri3, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal2, new Resource[0]);
        Iterator selection = model.getStatements((Resource)this.uri1, null, null, new Resource[0]).iterator();
        try {
            while (selection.hasNext()) {
                Statement st = (Statement)selection.next();
                if (!st.getObject().equals(this.uri2)) continue;
                model.remove((Resource)this.uri1, RDFS.LABEL, (Value)this.uri3, new Resource[0]);
            }
            org.junit.jupiter.api.Assertions.fail((String)"should have resulted in ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetStatements_AddToEmptyModel() {
        Model model = this.getNewEmptyModel();
        Iterator selection = model.getStatements(null, null, null, new Resource[0]).iterator();
        Assertions.assertThat((boolean)selection.hasNext()).isFalse();
        model.add((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        Assertions.assertThat((boolean)model.contains((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0])).isTrue();
        Assertions.assertThat((boolean)selection.hasNext()).isFalse();
        Iterator newSelection = model.getStatements(null, null, null, new Resource[0]).iterator();
        Assertions.assertThat((boolean)newSelection.hasNext()).isTrue();
    }

    @Test
    public void testFilterSingleLiteral() {
        Model model = this.getNewModelObjectSingleLiteral();
        Model filter1 = model.filter(null, null, (Value)this.literal1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter1.isEmpty());
        Model filter2 = model.filter(null, null, (Value)this.literal1, new Resource[]{null});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter2.isEmpty());
    }

    @Test
    public void testFilter_AddToEmptyFilteredModel() {
        Model model = this.getNewEmptyModel();
        Model filter = model.filter(null, null, null, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.isEmpty());
        filter.add((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)model.contains((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.contains((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
    }

    @Test
    public void testFilter_RemoveFromFilter() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[]{this.uri1});
        Model filter = model.filter((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[]{this.uri1});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.contains((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
        filter.remove((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[]{this.uri1});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)model.contains((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.contains((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
    }

    @Test
    public void testFilter_AddToNonEmptyFilteredModel() {
        Model model = this.getNewModelObjectSingleLiteral();
        Model filter = model.filter(null, null, (Value)this.literal1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.isEmpty());
        filter.add((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)model.contains((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
    }

    @Test
    public void testFilter_AddToEmptyOriginalModel() {
        Model model = this.getNewEmptyModel();
        Model filter = model.filter(null, null, null, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.isEmpty());
        model.add((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)model.contains((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.contains((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
    }

    @Test
    public void testFilter_RemoveFromOriginal() {
        Model model = this.getNewEmptyModel();
        model.add((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[]{this.uri1});
        Model filter = model.filter((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[]{this.uri1});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.contains((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
        model.remove((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[]{this.uri1});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)model.contains((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.contains((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
    }

    @Test
    public void testFilter_AddToOriginalModel() {
        Model model = this.getNewModelObjectSingleLiteral();
        Model filter = model.filter(null, null, (Value)this.literal1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.contains((Resource)this.uri1, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.contains((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
        model.add((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.contains((Resource)this.uri2, RDFS.LABEL, (Value)this.literal1, new Resource[0]));
    }

    @Test
    public void testContainsSingleLiteral() {
        Model model = this.getNewModelObjectSingleLiteral();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)model.contains(null, null, (Value)this.literal1, new Resource[0]));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)model.contains(null, null, (Value)this.literal1, new Resource[]{null}));
    }

    @Test
    public void testSubjects() {
        Model m = this.getNewModelObjectDoubleLiteral();
        int modelSizeBefore = m.size();
        Set subjects = m.subjects();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)subjects);
        int setSizeBefore = subjects.size();
        Value predicate = (Value)subjects.iterator().next();
        subjects.remove(predicate);
        org.junit.jupiter.api.Assertions.assertEquals((int)(setSizeBefore - 1), (int)subjects.size());
        org.junit.jupiter.api.Assertions.assertTrue((m.size() < modelSizeBefore ? 1 : 0) != 0);
    }

    @Test
    public void testPredicates() {
        Model m = this.getNewModelObjectDoubleLiteral();
        int modelSizeBefore = m.size();
        Set predicates = m.predicates();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)predicates);
        int setSizeBefore = predicates.size();
        Value predicate = (Value)predicates.iterator().next();
        predicates.remove(predicate);
        org.junit.jupiter.api.Assertions.assertEquals((int)(setSizeBefore - 1), (int)predicates.size());
        org.junit.jupiter.api.Assertions.assertTrue((m.size() < modelSizeBefore ? 1 : 0) != 0);
    }

    @Test
    public void testObjects() {
        Model m = this.getNewModelObjectDoubleLiteral();
        int modelSizeBefore = m.size();
        Set objects = m.objects();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)objects);
        int setSizeBefore = objects.size();
        Value object = (Value)objects.iterator().next();
        objects.remove(object);
        org.junit.jupiter.api.Assertions.assertEquals((int)(setSizeBefore - 1), (int)objects.size());
        org.junit.jupiter.api.Assertions.assertTrue((m.size() < modelSizeBefore ? 1 : 0) != 0);
    }

    @Test
    public void testContexts() {
        Model m = this.getNewModelTwoContexts();
        int modelSizeBefore = m.size();
        Set contexts = m.contexts();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)contexts);
        int setSizeBefore = contexts.size();
        Value predicate = (Value)contexts.iterator().next();
        contexts.remove(predicate);
        org.junit.jupiter.api.Assertions.assertEquals((int)(setSizeBefore - 1), (int)contexts.size());
        org.junit.jupiter.api.Assertions.assertTrue((m.size() < modelSizeBefore ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsVsIsomorphic() {
        Model x = this.getNewEmptyModel();
        x.add((Resource)this.vf.createBNode("node1ejfmfm4dx1"), RDF.VALUE, (Value)this.vf.createBNode("node1ejfmfm4dx2"), new Resource[0]);
        Model y = this.getNewEmptyModel();
        y.add((Resource)this.vf.createBNode("node1ejfmfm4dx3"), RDF.VALUE, (Value)this.vf.createBNode("node1ejfmfm4dx4"), new Resource[0]);
        Assertions.assertThat((boolean)Models.isomorphic((Iterable)x, (Iterable)y));
        Assertions.assertThat((boolean)x.equals(y)).isFalse();
    }

    @Test
    public void testEqualsHashcode() {
        Model x = this.getNewEmptyModel();
        x.add((Resource)this.vf.createBNode("node1ejfmfm4dx1"), RDF.VALUE, (Value)this.vf.createBNode("node1ejfmfm4dx2"), new Resource[0]);
        Model y = this.getNewEmptyModel();
        y.add((Resource)this.vf.createBNode("node1ejfmfm4dx1"), RDF.VALUE, (Value)this.vf.createBNode("node1ejfmfm4dx2"), new Resource[0]);
        Assertions.assertThat((boolean)x.equals(y)).isTrue();
        Assertions.assertThat((int)x.hashCode()).isEqualTo(y.hashCode());
    }
}

