/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.eclipse.rdf4j.http.client.QueueCursor;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;

public class BackgroundGraphResult
extends IterationWrapper<Statement, QueryEvaluationException>
implements GraphQueryResult,
Runnable,
RDFHandler {
    private volatile boolean closed;
    private RDFParser parser;
    private Charset charset;
    private InputStream in;
    private String baseURI;
    private CountDownLatch namespacesReady = new CountDownLatch(1);
    private Map<String, String> namespaces = new ConcurrentHashMap<String, String>();
    private QueueCursor<Statement> queue;

    public BackgroundGraphResult(RDFParser parser, InputStream in, Charset charset, String baseURI) {
        this(new QueueCursor<Statement>(10), parser, in, charset, baseURI);
    }

    public BackgroundGraphResult(QueueCursor<Statement> queue, RDFParser parser, InputStream in, Charset charset, String baseURI) {
        super(queue);
        this.queue = queue;
        this.parser = parser;
        this.in = in;
        this.charset = charset;
        this.baseURI = baseURI;
    }

    public boolean hasNext() throws QueryEvaluationException {
        return this.queue.hasNext();
    }

    public Statement next() throws QueryEvaluationException {
        return (Statement)this.queue.next();
    }

    public void remove() throws QueryEvaluationException {
        this.queue.remove();
    }

    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            this.closed = true;
            try {
                this.in.close();
            }
            catch (IOException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
            finally {
                this.queue.close();
            }
        }
    }

    @Override
    public void run() {
        try {
            this.parser.setRDFHandler((RDFHandler)this);
            if (this.charset == null) {
                this.parser.parse(this.in, this.baseURI);
            } else {
                this.parser.parse((Reader)new InputStreamReader(this.in, this.charset), this.baseURI);
            }
        }
        catch (RDFHandlerException rDFHandlerException) {
        }
        catch (RDFParseException e) {
            this.queue.toss((Exception)((Object)e));
        }
        catch (IOException e) {
            this.queue.toss(e);
        }
        finally {
            this.queue.done();
            this.namespacesReady.countDown();
        }
    }

    public void startRDF() throws RDFHandlerException {
    }

    public Map<String, String> getNamespaces() {
        try {
            this.namespacesReady.await();
            return this.namespaces;
        }
        catch (InterruptedException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaces.put(prefix, uri);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.namespacesReady.countDown();
        try {
            this.queue.put(st);
        }
        catch (InterruptedException e) {
            throw new RDFHandlerException((Throwable)e);
        }
        if (this.closed) {
            throw new RDFHandlerException("Result closed");
        }
    }

    public void endRDF() throws RDFHandlerException {
        this.namespacesReady.countDown();
    }
}

