/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import jakarta.xml.bind.Unmarshaller;
import java.lang.reflect.Method;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class UnmarshalCallback {
    private Class<?> domainClass;
    private String domainClassName;
    private Method afterUnmarshalCallback;
    private Method beforeUnmarshalCallback;
    private boolean hasAfterUnmarshalCallback = false;
    private boolean hasBeforeUnmarshalCallback = false;

    public Method getAfterUnmarshalCallback() {
        return this.afterUnmarshalCallback;
    }

    public Method getBeforeUnmarshalCallback() {
        return this.beforeUnmarshalCallback;
    }

    public Class<?> getDomainClass() {
        return this.domainClass;
    }

    public void initialize(ClassLoader loader) {
        try {
            this.domainClass = (Class)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName((String)this.domainClassName, (boolean)true, (ClassLoader)loader));
        }
        catch (ClassNotFoundException ex) {
            return;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed initialization of %s class", this.domainClassName), ex);
        }
        Class[] params = new Class[]{Unmarshaller.class, Object.class};
        if (this.hasBeforeUnmarshalCallback) {
            try {
                Method beforeUnmarshal = (Method)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getMethod(this.domainClass, (String)"beforeUnmarshal", (Class[])params, (boolean)false));
                this.setBeforeUnmarshalCallback(beforeUnmarshal);
            }
            catch (NoSuchMethodException beforeUnmarshal) {
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Failed initialization of beforeMarshal method of %s class", this.domainClassName), ex);
            }
        }
        if (this.hasAfterUnmarshalCallback) {
            try {
                Method afterUnmarshal = (Method)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getMethod(this.domainClass, (String)"afterUnmarshal", (Class[])params, (boolean)false));
                this.setAfterUnmarshalCallback(afterUnmarshal);
            }
            catch (NoSuchMethodException afterUnmarshal) {
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Failed initialization of afterMarshal method of %s class", this.domainClassName), ex);
            }
        }
    }

    public void setAfterUnmarshalCallback(Method method) {
        this.afterUnmarshalCallback = method;
    }

    public void setHasAfterUnmarshalCallback() {
        this.hasAfterUnmarshalCallback = true;
    }

    public void setBeforeUnmarshalCallback(Method method) {
        this.beforeUnmarshalCallback = method;
    }

    public void setHasBeforeUnmarshalCallback() {
        this.hasBeforeUnmarshalCallback = true;
    }

    public void setDomainClass(Class<?> clazz) {
        this.domainClass = clazz;
        this.setDomainClassName(clazz.getName());
    }

    public void setDomainClassName(String className) {
        this.domainClassName = className;
    }
}

