/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.signature;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.eclipse.packager.rpm.HashAlgorithm;
import org.eclipse.packager.rpm.RpmSignatureTag;
import org.eclipse.packager.rpm.header.Header;
import org.eclipse.packager.rpm.signature.SignatureProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaSignatureProcessor
implements SignatureProcessor {
    private static final Logger logger = LoggerFactory.getLogger(RsaSignatureProcessor.class);
    private final PGPSignatureGenerator signatureGenerator;

    protected RsaSignatureProcessor(PGPPrivateKey privateKey, int hashAlgorithm) {
        Objects.requireNonNull(privateKey);
        BcPGPContentSignerBuilder contentSignerBuilder = new BcPGPContentSignerBuilder(privateKey.getPublicKeyPacket().getAlgorithm(), hashAlgorithm);
        this.signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)contentSignerBuilder);
        try {
            this.signatureGenerator.init(0, privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RsaSignatureProcessor(PGPPrivateKey privateKey, HashAlgorithm hashAlgorithm) {
        this(privateKey, Objects.requireNonNull(hashAlgorithm).getValue());
    }

    public RsaSignatureProcessor(PGPPrivateKey privateKey) {
        this(privateKey, 8);
    }

    @Override
    public void feedHeader(ByteBuffer header) {
        this.feedData(header);
    }

    @Override
    public void feedPayloadData(ByteBuffer data) {
        this.feedData(data);
    }

    private void feedData(ByteBuffer data) {
        if (data.hasArray()) {
            this.signatureGenerator.update(data.array(), data.position(), data.remaining());
        } else {
            byte[] buffer = new byte[data.remaining()];
            data.get(buffer);
            this.signatureGenerator.update(buffer);
        }
    }

    @Override
    public void finish(Header<RpmSignatureTag> signature) {
        try {
            byte[] value = this.signatureGenerator.generate().getEncoded();
            logger.info("RSA: {}", (Object)value);
            signature.putBlob(RpmSignatureTag.PGP, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

