/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import java.net.ConnectException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.milo.opcua.stack.client.ClientChannelManager;
import org.eclipse.milo.opcua.stack.client.config.UaTcpStackClientConfig;
import org.eclipse.milo.opcua.stack.client.handlers.UaRequestFuture;
import org.eclipse.milo.opcua.stack.client.handlers.UaTcpClientAcknowledgeHandler;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.UaServiceFaultException;
import org.eclipse.milo.opcua.stack.core.application.UaStackClient;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.channel.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;
import org.eclipse.milo.opcua.stack.core.util.LongSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTcpStackClient
implements UaStackClient {
    private static final long DEFAULT_TIMEOUT_MS = 60000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LongSequence requestHandles = new LongSequence(0L, 0xFFFFFFFFL);
    private final Map<UInteger, CompletableFuture<UaResponseMessage>> pending = Maps.newConcurrentMap();
    private final Map<UInteger, Timeout> timeouts = Maps.newConcurrentMap();
    private final ExecutionQueue deliveryQueue;
    private final HashedWheelTimer wheelTimer;
    private final ApplicationDescription application;
    private final ClientChannelManager channelManager;
    private final UaTcpStackClientConfig config;

    public UaTcpStackClient(UaTcpStackClientConfig config) {
        this.config = config;
        this.deliveryQueue = new ExecutionQueue(config.getExecutor());
        this.wheelTimer = config.getWheelTimer();
        this.application = new ApplicationDescription(config.getApplicationUri(), config.getProductUri(), config.getApplicationName(), ApplicationType.Client, null, null, null);
        this.channelManager = new ClientChannelManager(this);
    }

    public UaTcpStackClientConfig getConfig() {
        return this.config;
    }

    public CompletableFuture<UaStackClient> connect() {
        CompletableFuture<UaStackClient> future = new CompletableFuture<UaStackClient>();
        this.channelManager.connect().whenComplete((ch, ex) -> {
            if (ch != null) {
                future.complete(this);
            } else {
                future.completeExceptionally((Throwable)ex);
            }
        });
        return future;
    }

    public CompletableFuture<UaStackClient> disconnect() {
        return ((CompletableFuture)this.channelManager.disconnect().whenComplete((u, ex) -> this.pending.forEach((h, cf) -> cf.completeExceptionally(new UaException(2158821376L, "client disconnect"))))).thenApply(v -> this);
    }

    public RequestHeader newRequestHeader(UInteger requestTimeout) {
        return this.newRequestHeader(NodeId.NULL_VALUE, requestTimeout);
    }

    public RequestHeader newRequestHeader(NodeId authToken, UInteger requestTimeout) {
        return new RequestHeader(authToken, DateTime.now(), Unsigned.uint((long)this.requestHandles.getAndIncrement()), Unsigned.uint((int)0), null, requestTimeout, null);
    }

    public UInteger nextRequestHandle() {
        return Unsigned.uint((long)this.requestHandles.getAndIncrement());
    }

    public <T extends UaResponseMessage> CompletableFuture<T> sendRequest(UaRequestMessage request) {
        return this.channelManager.getChannel().thenCompose(sc -> this.sendRequest(request, (ClientSecureChannel)sc, true));
    }

    private <T extends UaResponseMessage> CompletionStage<T> sendRequest(UaRequestMessage request, ClientSecureChannel sc, boolean firstAttempt) {
        Channel channel = sc.getChannel();
        CompletableFuture future = new CompletableFuture();
        UaRequestFuture requestFuture = new UaRequestFuture(request);
        RequestHeader requestHeader = request.getRequestHeader();
        this.pending.put(requestHeader.getRequestHandle(), future);
        this.scheduleRequestTimeout(requestHeader);
        requestFuture.getFuture().whenComplete((r, x) -> {
            if (r != null) {
                this.receiveResponse((UaResponseMessage)r);
            } else {
                UInteger requestHandle = request.getRequestHeader().getRequestHandle();
                this.pending.remove(requestHandle);
                future.completeExceptionally((Throwable)x);
            }
        });
        channel.writeAndFlush((Object)requestFuture).addListener(f -> {
            if (!f.isSuccess()) {
                Throwable cause = f.cause();
                if (cause instanceof ClosedChannelException && firstAttempt) {
                    this.logger.debug("Channel closed; retrying...");
                    Stack.sharedScheduledExecutor().schedule(() -> this.config.getExecutor().execute(() -> {
                        CompletionStage sendAgain = this.channelManager.getChannel().thenCompose(ch -> this.sendRequest(request, (ClientSecureChannel)ch, false));
                        ((CompletableFuture)sendAgain).whenComplete((r, ex) -> {
                            if (r != null) {
                                future.complete(r);
                            } else {
                                future.completeExceptionally((Throwable)ex);
                            }
                        });
                    }), 1L, TimeUnit.SECONDS);
                } else {
                    UInteger requestHandle = request.getRequestHeader().getRequestHandle();
                    this.pending.remove(requestHandle);
                    future.completeExceptionally(f.cause());
                    this.logger.debug("Write failed, requestHandle={}", (Object)requestHandle, (Object)cause);
                }
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("writeAndFlush succeeded for request={}, requestHandle={}", (Object)request.getClass().getSimpleName(), (Object)requestHeader.getRequestHandle());
            }
        });
        return future;
    }

    public void sendRequests(List<? extends UaRequestMessage> requests, List<CompletableFuture<? extends UaResponseMessage>> futures) {
        Preconditions.checkArgument((requests.size() == futures.size() ? 1 : 0) != 0, (Object)"requests and futures parameters must be same size");
        this.channelManager.getChannel().whenComplete((sc, ex) -> {
            if (sc != null) {
                this.sendRequests(requests, futures, (ClientSecureChannel)sc);
            } else {
                futures.forEach(f -> f.completeExceptionally((Throwable)ex));
            }
        });
    }

    private void sendRequests(List<? extends UaRequestMessage> requests, List<CompletableFuture<? extends UaResponseMessage>> futures, ClientSecureChannel sc) {
        Channel channel = sc.getChannel();
        Iterator<? extends UaRequestMessage> requestIterator = requests.iterator();
        Iterator<CompletableFuture<? extends UaResponseMessage>> futureIterator = futures.iterator();
        ArrayList<UaRequestFuture> pendingRequests = new ArrayList<UaRequestFuture>(requests.size());
        while (requestIterator.hasNext() && futureIterator.hasNext()) {
            UaRequestMessage request = requestIterator.next();
            CompletableFuture<UaResponseMessage> future = futureIterator.next();
            UaRequestFuture pendingRequest = new UaRequestFuture(request, future);
            pendingRequests.add(pendingRequest);
            RequestHeader requestHeader = request.getRequestHeader();
            this.pending.put(requestHeader.getRequestHandle(), future);
            this.scheduleRequestTimeout(requestHeader);
            pendingRequest.getFuture().thenAccept(this::receiveResponse);
        }
        channel.eventLoop().execute(() -> {
            for (UaRequestFuture pendingRequest : pendingRequests) {
                channel.write((Object)pendingRequest).addListener(f -> {
                    if (!f.isSuccess()) {
                        UInteger requestHandle = pendingRequest.getRequest().getRequestHeader().getRequestHandle();
                        CompletableFuture<UaResponseMessage> future = this.pending.remove(requestHandle);
                        if (future != null) {
                            future.completeExceptionally(f.cause());
                        }
                        this.logger.debug("Write failed, requestHandle={}", (Object)requestHandle, (Object)f.cause());
                    }
                });
            }
            channel.flush();
        });
    }

    public CompletableFuture<ClientSecureChannel> getChannelFuture() {
        return this.channelManager.getChannel();
    }

    private void scheduleRequestTimeout(RequestHeader requestHeader) {
        UInteger requestHandle = requestHeader.getRequestHandle();
        long timeoutHint = requestHeader.getTimeoutHint() != null ? requestHeader.getTimeoutHint().longValue() : 60000L;
        Timeout timeout = this.wheelTimer.newTimeout(t -> {
            CompletableFuture<UaResponseMessage> f;
            if (this.timeouts.remove(requestHandle) != null && !t.isCancelled() && (f = this.pending.remove(requestHandle)) != null) {
                String message = "request timed out after " + timeoutHint + "ms";
                f.completeExceptionally(new UaException(0x800A0000L, message));
            }
        }, timeoutHint, TimeUnit.MILLISECONDS);
        this.timeouts.put(requestHandle, timeout);
    }

    private void receiveResponse(UaResponseMessage response) {
        this.deliveryQueue.submit(() -> {
            ResponseHeader header = response.getResponseHeader();
            UInteger requestHandle = header.getRequestHandle();
            CompletableFuture<UaResponseMessage> future = this.pending.remove(requestHandle);
            if (future != null) {
                if (header.getServiceResult().isGood()) {
                    future.complete(response);
                } else {
                    ServiceFault serviceFault = response instanceof ServiceFault ? (ServiceFault)response : new ServiceFault(header);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Received ServiceFault requestHandle={}, result={}", (Object)requestHandle, (Object)serviceFault.getResponseHeader().getServiceResult());
                    }
                    future.completeExceptionally((Throwable)new UaServiceFaultException(serviceFault));
                }
                Timeout timeout = this.timeouts.remove(requestHandle);
                if (timeout != null) {
                    timeout.cancel();
                }
            } else {
                this.logger.warn("Received unmatched {} with requestHandle={}, timestamp={}", new Object[]{response.getClass().getSimpleName(), requestHandle, response.getResponseHeader().getTimestamp()});
            }
        });
    }

    public Optional<X509Certificate> getCertificate() {
        return this.config.getCertificate();
    }

    public Optional<KeyPair> getKeyPair() {
        return this.config.getKeyPair();
    }

    public ChannelConfig getChannelConfig() {
        return this.config.getChannelConfig();
    }

    public UInteger getChannelLifetime() {
        return this.config.getChannelLifetime();
    }

    public ApplicationDescription getApplication() {
        return this.application;
    }

    public Optional<EndpointDescription> getEndpoint() {
        return this.config.getEndpoint();
    }

    public String getEndpointUrl() {
        return this.config.getEndpoint().map(EndpointDescription::getEndpointUrl).orElse(this.config.getEndpointUrl().orElse(""));
    }

    public ExecutorService getExecutorService() {
        return this.config.getExecutor();
    }

    public static CompletableFuture<ClientSecureChannel> bootstrap(final UaTcpStackClient client) {
        final CompletableFuture<ClientSecureChannel> handshake = new CompletableFuture<ClientSecureChannel>();
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                ClientSecureChannel secureChannel;
                UaTcpStackClientConfig config = client.getConfig();
                EndpointDescription endpoint = config.getEndpoint().orElseGet(() -> {
                    String endpointUrl = config.getEndpointUrl().orElseThrow(() -> new UaRuntimeException(0x80890000L, "no endpoint or endpoint URL configured"));
                    return new EndpointDescription(endpointUrl, null, null, MessageSecurityMode.None, SecurityPolicy.None.getSecurityPolicyUri(), null, null, null);
                });
                SecurityPolicy securityPolicy = SecurityPolicy.fromUri((String)endpoint.getSecurityPolicyUri());
                if (securityPolicy == SecurityPolicy.None) {
                    secureChannel = new ClientSecureChannel(securityPolicy, endpoint.getSecurityMode());
                } else {
                    KeyPair keyPair = config.getKeyPair().orElseThrow(() -> new UaException(0x80890000L, "no KeyPair configured"));
                    X509Certificate certificate = config.getCertificate().orElseThrow(() -> new UaException(0x80890000L, "no certificate configured"));
                    List<Object> certificateChain = Arrays.asList((Object[])config.getCertificateChain().orElseThrow(() -> new UaException(0x80890000L, "no certificate chain configured")));
                    X509Certificate remoteCertificate = CertificateUtil.decodeCertificate((byte[])endpoint.getServerCertificate().bytes());
                    List remoteCertificateChain = CertificateUtil.decodeCertificates((byte[])endpoint.getServerCertificate().bytes());
                    secureChannel = new ClientSecureChannel(keyPair, certificate, certificateChain, remoteCertificate, remoteCertificateChain, securityPolicy, endpoint.getSecurityMode());
                }
                UaTcpClientAcknowledgeHandler acknowledgeHandler = new UaTcpClientAcknowledgeHandler(client, secureChannel, handshake);
                channel.pipeline().addLast(new ChannelHandler[]{acknowledgeHandler});
            }
        };
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)client.getConfig().getEventLoop())).channel(NioSocketChannel.class)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)initializer);
        try {
            URI uri = new URI(client.getEndpointUrl()).parseServerAuthority();
            bootstrap.connect(uri.getHost(), uri.getPort()).addListener(f -> {
                if (!f.isSuccess()) {
                    Throwable cause = f.cause();
                    if (cause instanceof ConnectTimeoutException) {
                        handshake.completeExceptionally(new UaException(0x800A0000L, f.cause()));
                    } else if (cause instanceof ConnectException) {
                        handshake.completeExceptionally(new UaException(2158755840L, f.cause()));
                    } else {
                        handshake.completeExceptionally(cause);
                    }
                }
            });
        }
        catch (Throwable e) {
            UaException failure = new UaException(0x80830000L, e);
            handshake.completeExceptionally(failure);
        }
        return handshake;
    }

    public static CompletableFuture<ApplicationDescription[]> findServers(String endpointUrl) {
        UaTcpStackClientConfig config = UaTcpStackClientConfig.builder().setEndpointUrl(endpointUrl).build();
        UaTcpStackClient client = new UaTcpStackClient(config);
        FindServersRequest request = new FindServersRequest(new RequestHeader(null, DateTime.now(), Unsigned.uint((int)1), Unsigned.uint((int)0), null, Unsigned.uint((int)5000), null), endpointUrl, null, null);
        return ((CompletableFuture)client.sendRequest((UaRequestMessage)request).whenComplete((r, ex) -> client.disconnect())).thenApply(FindServersResponse::getServers);
    }

    public static CompletableFuture<EndpointDescription[]> getEndpoints(String endpointUrl) {
        UaTcpStackClientConfig config = UaTcpStackClientConfig.builder().setEndpointUrl(endpointUrl).build();
        UaTcpStackClient client = new UaTcpStackClient(config);
        GetEndpointsRequest request = new GetEndpointsRequest(new RequestHeader(null, DateTime.now(), Unsigned.uint((int)1), Unsigned.uint((int)0), null, Unsigned.uint((int)5000), null), endpointUrl, null, new String[]{"http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary"});
        return client.connect().thenCompose(c -> ((CompletableFuture)c.sendRequest((UaRequestMessage)request).whenComplete((r, ex) -> client.disconnect())).thenApply(GetEndpointsResponse::getEndpoints));
    }
}

