/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeHistoryServices;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.services.ServiceCounter;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResult;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.server.services.AttributeHistoryServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;

public class DefaultAttributeHistoryServiceSet
implements AttributeHistoryServiceSet {
    private final ServiceCounter historyReadMetric = new ServiceCounter();
    private final ServiceCounter historyUpdateMetric = new ServiceCounter();

    public void onHistoryRead(ServiceRequest service) {
        this.historyReadMetric.record(service);
        HistoryReadRequest request = (HistoryReadRequest)service.getRequest();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        List nodesToRead = ConversionUtil.l((Object[])request.getNodesToRead());
        if (nodesToRead.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)nodesToRead.size() > server.getConfig().getLimits().getMaxNodesPerRead().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        if (request.getTimestampsToReturn() == null) {
            service.setServiceFault(2150301696L);
            return;
        }
        DiagnosticsContext<HistoryReadValueId> diagnosticsContext = new DiagnosticsContext<HistoryReadValueId>();
        AttributeHistoryServices.HistoryReadContext context = new AttributeHistoryServices.HistoryReadContext(server, session, diagnosticsContext);
        HistoryReadDetails details = (HistoryReadDetails)request.getHistoryReadDetails().decode(server.getSerializationContext());
        server.getAddressSpaceManager().historyRead(context, details, request.getTimestampsToReturn(), nodesToRead);
        context.getFuture().thenAccept(values -> {
            ResponseHeader header = service.createResponseHeader();
            DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToRead);
            HistoryReadResponse response = new HistoryReadResponse(header, (HistoryReadResult[])ConversionUtil.a((List)values, HistoryReadResult.class), diagnosticInfos);
            service.setResponse((UaResponseMessage)response);
        });
    }

    public void onHistoryUpdate(ServiceRequest service) throws UaException {
        this.historyUpdateMetric.record(service);
        HistoryUpdateRequest request = (HistoryUpdateRequest)service.getRequest();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        List<HistoryUpdateDetails> historyUpdateDetailsList = ConversionUtil.l((Object[])request.getHistoryUpdateDetails()).stream().map(e -> (HistoryUpdateDetails)e.decode(server.getSerializationContext())).collect(Collectors.toList());
        if (historyUpdateDetailsList.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if (historyUpdateDetailsList.size() > server.getConfig().getLimits().getMaxNodesPerWrite().intValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        DiagnosticsContext<HistoryUpdateDetails> diagnosticsContext = new DiagnosticsContext<HistoryUpdateDetails>();
        AttributeHistoryServices.HistoryUpdateContext context = new AttributeHistoryServices.HistoryUpdateContext(server, session, diagnosticsContext);
        server.getAddressSpaceManager().historyUpdate(context, historyUpdateDetailsList);
        context.getFuture().thenAccept(values -> {
            ResponseHeader header = service.createResponseHeader();
            DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(historyUpdateDetailsList);
            HistoryUpdateResponse response = new HistoryUpdateResponse(header, (HistoryUpdateResult[])ConversionUtil.a((List)values, HistoryUpdateResult.class), diagnosticInfos);
            service.setResponse((UaResponseMessage)response);
        });
    }
}

