/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.factories;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.BrowsePath;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeTable;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.ReferenceTable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class InstanceDeclarationHierarchy {
    private final NodeId typeId;
    private final NodeTable nodeTable;
    private final ReferenceTable referenceTable;

    private InstanceDeclarationHierarchy(NodeId typeId, NodeTable nodeTable, ReferenceTable referenceTable) {
        this.typeId = typeId;
        this.nodeTable = nodeTable;
        this.referenceTable = referenceTable;
    }

    NodeTable getNodeTable() {
        return this.nodeTable;
    }

    ReferenceTable getReferenceTable() {
        return this.referenceTable;
    }

    private InstanceDeclarationHierarchy merge(InstanceDeclarationHierarchy parent) {
        NodeTable mergedNodeTable = NodeTable.merge(this.nodeTable, parent.nodeTable);
        ReferenceTable mergedReferenceTable = ReferenceTable.merge(this.referenceTable, parent.referenceTable);
        return new InstanceDeclarationHierarchy(this.typeId, mergedNodeTable, mergedReferenceTable);
    }

    public static InstanceDeclarationHierarchy create(AddressSpaceManager addressSpaceManager, NamespaceTable namespaceTable, NodeId typeDefinitionId, boolean includeOptionalNodes) {
        Builder builder = new Builder(addressSpaceManager, namespaceTable, includeOptionalNodes);
        return builder.build(typeDefinitionId, includeOptionalNodes);
    }

    static class Builder {
        private final NodeTable nodeTable = new NodeTable();
        private final ReferenceTable referenceTable = new ReferenceTable();
        private final AddressSpaceManager addressSpaceManager;
        private final NamespaceTable namespaceTable;
        private final boolean includeOptionalNodes;

        Builder(AddressSpaceManager addressSpaceManager, NamespaceTable namespaceTable, boolean includeOptionalNodes) {
            this.addressSpaceManager = addressSpaceManager;
            this.namespaceTable = namespaceTable;
            this.includeOptionalNodes = includeOptionalNodes;
        }

        public InstanceDeclarationHierarchy build(NodeId typeDefinitionId, boolean includeOptionalNodes) {
            Optional<InstanceDeclarationHierarchy> parentIdh = this.addressSpaceManager.getManagedReferences(typeDefinitionId).stream().filter(r -> r.isInverse() && Identifiers.HasSubtype.equals((Object)r.getReferenceTypeId())).findFirst().flatMap(r -> r.getTargetNodeId().local(this.namespaceTable)).map(parentTypeId -> InstanceDeclarationHierarchy.create(this.addressSpaceManager, this.namespaceTable, parentTypeId, includeOptionalNodes));
            InstanceDeclarationHierarchy idh = this.buildHierarchyForType(typeDefinitionId);
            return parentIdh.map(x$0 -> idh.merge((InstanceDeclarationHierarchy)x$0)).orElse(idh);
        }

        private InstanceDeclarationHierarchy buildHierarchyForType(NodeId typeDefinitionId) {
            BrowsePath browsePath = BrowsePath.ROOT;
            this.nodeTable.addNode(browsePath, typeDefinitionId);
            this.referenceTable.addReference(browsePath, Identifiers.HasTypeDefinition, typeDefinitionId.expanded());
            this.addModeledNodes(typeDefinitionId, browsePath);
            return new InstanceDeclarationHierarchy(typeDefinitionId, this.nodeTable, this.referenceTable);
        }

        private void addModeledNodes(NodeId nodeId, BrowsePath parentPath) {
            List<Reference> forwardReferences = this.addressSpaceManager.getManagedReferences(nodeId).stream().filter(Reference::isForward).collect(Collectors.toList());
            forwardReferences.forEach(reference -> this.addressSpaceManager.getManagedNode(reference.getTargetNodeId()).ifPresent(node -> {
                BrowsePath browsePath = new BrowsePath(parentPath, node.getBrowseName());
                if (Builder.isInstanceDeclaration(node, this.includeOptionalNodes)) {
                    this.nodeTable.addNode(browsePath, node.getNodeId());
                    this.referenceTable.addReference(parentPath, reference.getReferenceTypeId(), browsePath);
                    node.getReferences().stream().filter(r -> r.subtypeOf(Identifiers.NonHierarchicalReferences)).forEach(r -> this.referenceTable.addReference(browsePath, r.getReferenceTypeId(), r.getTargetNodeId()));
                    this.addModeledNodes(node.getNodeId(), browsePath);
                }
            }));
        }

        private static boolean isInstanceDeclaration(UaNode node, boolean includeOptionalNodes) {
            NodeClass nodeClass = node.getNodeClass();
            boolean methodOrObjectOrVariable = nodeClass == NodeClass.Method || nodeClass == NodeClass.Object || nodeClass == NodeClass.Variable;
            return methodOrObjectOrVariable && Builder.hasModellingRule(node, includeOptionalNodes);
        }

        private static boolean hasModellingRule(UaNode node, boolean includeOptionalNodes) {
            return node.getReferences().stream().anyMatch(r -> {
                boolean rule = Identifiers.ModellingRule_Mandatory.expanded().equals((Object)r.getTargetNodeId()) || includeOptionalNodes && Identifiers.ModellingRule_Optional.expanded().equals((Object)r.getTargetNodeId());
                return Identifiers.HasModellingRule.equals((Object)r.getReferenceTypeId()) && rule;
            });
        }
    }
}

