/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.namespaces;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Optional;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

public class VendorServerInfoNodes {
    public static void add(UaNodeContext context) {
        VendorServerInfoNodes.addVendorServerInfoNodes(context);
    }

    private static void addVendorServerInfoNodes(UaNodeContext context) {
        Optional<UaNode> maybeVendorServerInfo = context.getServer().getAddressSpaceManager().getManagedNode(Identifiers.Server_VendorServerInfo);
        maybeVendorServerInfo.ifPresent(node -> {
            UaObjectNode vendorServerInfo = (UaObjectNode)node;
            VendorServerInfoNodes.addVendorInfoPlainJava(context, vendorServerInfo);
            VendorServerInfoNodes.addVendorInfoJmx(context, vendorServerInfo);
            VendorServerInfoNodes.addVendorInfoSunJmx(context, vendorServerInfo);
        });
    }

    private static void addVendorInfoPlainJava(UaNodeContext context, UaObjectNode vendorServerInfo) {
        UaVariableNode availableProcessors = new UaVariableNode(context, new NodeId(1, "VendorServerInfo/AvailableProcessors"), new QualifiedName(1, "AvailableProcessors"), LocalizedText.english((String)"AvailableProcessors")){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)Runtime.getRuntime().availableProcessors()));
            }
        };
        availableProcessors.setDataType(Identifiers.Int32);
        context.getNodeManager().addNode(availableProcessors);
        vendorServerInfo.addComponent(availableProcessors);
    }

    private static void addVendorInfoJmx(UaNodeContext context, UaObjectNode vendorServerInfo) {
        final java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        UaVariableNode usedMemory = new UaVariableNode(context, new NodeId(1, "VendorServerInfo/UsedMemory"), new QualifiedName(1, "UsedMemory"), LocalizedText.english((String)"UsedMemory")){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)(memoryBean.getHeapMemoryUsage().getUsed() / 1000L)));
            }
        };
        usedMemory.setDataType(Identifiers.Int64);
        context.getNodeManager().addNode(usedMemory);
        UaVariableNode maxMemory = new UaVariableNode(context, new NodeId(1, "VendorServerInfo/MaxMemory"), new QualifiedName(1, "MaxMemory"), LocalizedText.english((String)"MaxMemory")){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)memoryBean.getHeapMemoryUsage().getMax()));
            }
        };
        maxMemory.setDataType(Identifiers.Int64);
        context.getNodeManager().addNode(maxMemory);
        UaVariableNode osName = new UaVariableNode(context, new NodeId(1, "VendorServerInfo/OsName"), new QualifiedName(1, "OsName"), LocalizedText.english((String)"OsName")){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)osBean.getName()));
            }
        };
        osName.setDataType(Identifiers.String);
        context.getNodeManager().addNode(osName);
        UaVariableNode osArch = new UaVariableNode(context, new NodeId(1, "VendorServerInfo/OsArch"), new QualifiedName(1, "OsArch"), LocalizedText.english((String)"OsArch")){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)osBean.getArch()));
            }
        };
        osArch.setDataType(Identifiers.String);
        context.getNodeManager().addNode(osArch);
        UaVariableNode osVersion = new UaVariableNode(context, new NodeId(1, "VendorServerInfo/OsVersion"), new QualifiedName(1, "OsVersion"), LocalizedText.english((String)"OsVersion")){

            @Override
            public DataValue getValue() {
                return new DataValue(new Variant((Object)osBean.getVersion()));
            }
        };
        osVersion.setDataType(Identifiers.String);
        context.getNodeManager().addNode(osVersion);
        vendorServerInfo.addComponent(usedMemory);
        vendorServerInfo.addComponent(maxMemory);
        vendorServerInfo.addComponent(osName);
        vendorServerInfo.addComponent(osArch);
        vendorServerInfo.addComponent(osVersion);
    }

    private static void addVendorInfoSunJmx(UaNodeContext context, UaObjectNode vendorServerInfo) {
        java.lang.management.OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
        if (osMxBean instanceof OperatingSystemMXBean) {
            final OperatingSystemMXBean sunOsMxBean = (OperatingSystemMXBean)osMxBean;
            UaVariableNode processCpuLoad = new UaVariableNode(context, new NodeId(1, "VendorServerInfo/ProcessCpuLoad"), new QualifiedName(1, "ProcessCpuLoad"), LocalizedText.english((String)"ProcessCpuLoad")){

                @Override
                public DataValue getValue() {
                    return new DataValue(new Variant((Object)(sunOsMxBean.getProcessCpuLoad() * 100.0)));
                }
            };
            processCpuLoad.setDataType(Identifiers.Double);
            context.getNodeManager().addNode(processCpuLoad);
            UaVariableNode systemCpuLoad = new UaVariableNode(context, new NodeId(1, "VendorServerInfo/SystemCpuLoad"), new QualifiedName(1, "SystemCpuLoad"), LocalizedText.english((String)"SystemCpuLoad")){

                @Override
                public DataValue getValue() {
                    return new DataValue(new Variant((Object)(sunOsMxBean.getSystemCpuLoad() * 100.0)));
                }
            };
            systemCpuLoad.setDataType(Identifiers.Double);
            context.getNodeManager().addNode(systemCpuLoad);
            vendorServerInfo.addComponent(processCpuLoad);
            vendorServerInfo.addComponent(systemCpuLoad);
            if (sunOsMxBean instanceof UnixOperatingSystemMXBean) {
                final UnixOperatingSystemMXBean unixBean = (UnixOperatingSystemMXBean)sunOsMxBean;
                UaVariableNode openFileDescriptors = new UaVariableNode(context, new NodeId(1, "VendorServerInfo/OpenFileDescriptors"), new QualifiedName(1, "OpenFileDescriptors"), LocalizedText.english((String)"OpenFileDescriptors")){

                    @Override
                    public DataValue getValue() {
                        return new DataValue(new Variant((Object)unixBean.getOpenFileDescriptorCount()));
                    }
                };
                openFileDescriptors.setDataType(Identifiers.Int64);
                context.getNodeManager().addNode(openFileDescriptors);
                UaVariableNode maxFileDescriptors = new UaVariableNode(context, new NodeId(1, "VendorServerInfo/MaxFileDescriptors"), new QualifiedName(1, "MaxFileDescriptors"), LocalizedText.english((String)"MaxFileDescriptors")){

                    @Override
                    public DataValue getValue() {
                        return new DataValue(new Variant((Object)unixBean.getMaxFileDescriptorCount()));
                    }
                };
                maxFileDescriptors.setDataType(Identifiers.Int64);
                context.getNodeManager().addNode(maxFileDescriptors);
                vendorServerInfo.addComponent(openFileDescriptors);
                vendorServerInfo.addComponent(maxFileDescriptors);
            }
        }
    }
}

