/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;

final class DateTimeConversions {
    private static final DateFormat ISO_8601_UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    private DateTimeConversions() {
    }

    @Nonnull
    static String dateTimeToString(@Nonnull DateTime dt) {
        return DateTimeConversions.dateToIso8601UtcString(dt.getJavaDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dateToIso8601UtcString(Date date) {
        DateFormat dateFormat = ISO_8601_UTC_DATE_FORMAT;
        synchronized (dateFormat) {
            return ISO_8601_UTC_DATE_FORMAT.format(date);
        }
    }

    @Nullable
    static Object convert(@Nonnull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof DateTime) {
            DateTime d = (DateTime)o;
            return implicit ? DateTimeConversions.implicitConversion(d, targetType) : DateTimeConversions.explicitConversion(d, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull DateTime d, BuiltinDataType targetType) {
        switch (targetType) {
            case String: {
                return DateTimeConversions.dateTimeToString(d);
            }
        }
        return DateTimeConversions.implicitConversion(d, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull DateTime d, BuiltinDataType targetType) {
        return null;
    }

    static {
        ISO_8601_UTC_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

