/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

final class ByteConversions {
    private ByteConversions() {
    }

    @Nonnull
    static Boolean byteToBoolean(@Nonnull UByte ub) {
        return ub.intValue() != 0;
    }

    @Nonnull
    static Double byteToDouble(@Nonnull UByte ub) {
        return ub.doubleValue();
    }

    @Nonnull
    static Float byteToFloat(@Nonnull UByte ub) {
        return Float.valueOf(ub.floatValue());
    }

    @Nonnull
    static Short byteToInt16(@Nonnull UByte ub) {
        return ub.shortValue();
    }

    @Nonnull
    static Integer byteToInt32(@Nonnull UByte ub) {
        return ub.intValue();
    }

    @Nonnull
    static Long byteToInt64(@Nonnull UByte ub) {
        return ub.longValue();
    }

    @Nullable
    static Byte byteToSByte(@Nonnull UByte ub) {
        return ub.intValue() > 127 ? null : Byte.valueOf(ub.byteValue());
    }

    @Nonnull
    static String byteToString(@Nonnull UByte ub) {
        return ub.toString();
    }

    @Nonnull
    static UShort byteToUInt16(@Nonnull UByte ub) {
        return Unsigned.ushort((int)ub.intValue());
    }

    @Nonnull
    static UInteger byteToUInt32(@Nonnull UByte ub) {
        return Unsigned.uint((int)ub.intValue());
    }

    @Nonnull
    static ULong byteToUInt64(@Nonnull UByte ub) {
        return Unsigned.ulong((long)ub.longValue());
    }

    @Nullable
    static Object convert(@Nonnull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof UByte) {
            UByte b = (UByte)o;
            return implicit ? ByteConversions.implicitConversion(b, targetType) : ByteConversions.explicitConversion(b, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull UByte b, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return ByteConversions.byteToBoolean(b);
            }
            case String: {
                return ByteConversions.byteToString(b);
            }
        }
        return ByteConversions.implicitConversion(b, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull UByte b, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return ByteConversions.byteToDouble(b);
            }
            case Float: {
                return ByteConversions.byteToFloat(b);
            }
            case Int16: {
                return ByteConversions.byteToInt16(b);
            }
            case Int32: {
                return ByteConversions.byteToInt32(b);
            }
            case Int64: {
                return ByteConversions.byteToInt64(b);
            }
            case SByte: {
                return ByteConversions.byteToSByte(b);
            }
            case UInt16: {
                return ByteConversions.byteToUInt16(b);
            }
            case UInt32: {
                return ByteConversions.byteToUInt32(b);
            }
            case UInt64: {
                return ByteConversions.byteToUInt64(b);
            }
        }
        return null;
    }
}

