/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services.helpers;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.NamespaceManager;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.AccessContext;
import org.eclipse.milo.opcua.sdk.server.api.AttributeManager;
import org.eclipse.milo.opcua.sdk.server.api.Namespace;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.util.UaEnumUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.jooq.lambda.tuple.Tuple3;

public class BrowseHelper {
    private static final StatusCode BAD_CONTINUATION_POINT_INVALID = new StatusCode(2152333312L);
    private static final StatusCode BAD_NO_CONTINUATION_POINTS = new StatusCode(2152398848L);
    private static final BrowseResult NODE_ID_UNKNOWN_RESULT = new BrowseResult(new StatusCode(2150891520L), ByteString.NULL_VALUE, new ReferenceDescription[0]);

    public void browseNext(ServiceRequest<BrowseNextRequest, BrowseNextResponse> service) {
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        BrowseNextRequest request = (BrowseNextRequest)service.getRequest();
        List continuationPoints = ConversionUtil.l((Object[])request.getContinuationPoints());
        if (continuationPoints.size() > server.getConfig().getLimits().getMaxBrowseContinuationPoints().intValue()) {
            service.setServiceFault(0x80100000L);
        } else {
            server.getExecutorService().execute(new BrowseNext(server, service));
        }
    }

    public static CompletableFuture<BrowseResult> browse(AccessContext context, OpcUaServer server, ViewDescription view, UInteger maxReferencesPerNode, BrowseDescription browseDescription) {
        Browse browse = new Browse(context, server, maxReferencesPerNode, browseDescription);
        server.getExecutorService().execute(browse);
        return browse.getFuture();
    }

    private static class BrowseAttributes
    extends Tuple3<QualifiedName, LocalizedText, NodeClass> {
        private BrowseAttributes(QualifiedName browseName, LocalizedText displayName, NodeClass nodeClass) {
            super((Object)browseName, (Object)displayName, (Object)nodeClass);
        }

        private QualifiedName getBrowseName() {
            return (QualifiedName)this.v1();
        }

        private LocalizedText getDisplayName() {
            return (LocalizedText)this.v2();
        }

        private NodeClass getNodeClass() {
            return (NodeClass)this.v3();
        }
    }

    public static class BrowseContinuationPoint {
        private final List<ReferenceDescription> references;
        private final int max;
        private final ByteString identifier;

        public BrowseContinuationPoint(List<ReferenceDescription> references, int max) {
            this(references, max, BrowseContinuationPoint.generateId());
        }

        public BrowseContinuationPoint(List<ReferenceDescription> references, int max, ByteString identifier) {
            this.references = Collections.synchronizedList(references);
            this.max = max;
            this.identifier = identifier;
        }

        public List<ReferenceDescription> getReferences() {
            return this.references;
        }

        public int getMax() {
            return this.max;
        }

        public ByteString getIdentifier() {
            return this.identifier;
        }

        public static ByteString generateId() {
            return NonceUtil.generateNonce((int)16);
        }
    }

    private static class BrowseNext
    implements Runnable {
        private final OpcUaServer server;
        private final ServiceRequest<BrowseNextRequest, BrowseNextResponse> service;

        private BrowseNext(OpcUaServer server, ServiceRequest<BrowseNextRequest, BrowseNextResponse> service) {
            this.server = server;
            this.service = service;
        }

        @Override
        public void run() {
            ByteString[] cs;
            BrowseNextRequest request = (BrowseNextRequest)this.service.getRequest();
            ArrayList results = Lists.newArrayList();
            for (ByteString bs : cs = request.getContinuationPoints() != null ? request.getContinuationPoints() : new ByteString[]{}) {
                if (request.getReleaseContinuationPoints().booleanValue()) {
                    results.add(this.release(bs));
                    continue;
                }
                results.add(this.references(bs));
            }
            ResponseHeader header = this.service.createResponseHeader();
            BrowseNextResponse response = new BrowseNextResponse(header, results.toArray(new BrowseResult[results.size()]), new DiagnosticInfo[0]);
            this.service.setResponse((UaResponseMessage)response);
        }

        private BrowseResult release(ByteString bs) {
            BrowseContinuationPoint c = this.server.getBrowseContinuationPoints().remove(bs);
            return c != null ? new BrowseResult(StatusCode.GOOD, null, null) : new BrowseResult(BAD_CONTINUATION_POINT_INVALID, null, null);
        }

        private BrowseResult references(ByteString bs) {
            BrowseContinuationPoint c = this.server.getBrowseContinuationPoints().remove(bs);
            if (c != null) {
                int max = c.max;
                List references = c.references;
                if (references.size() > max) {
                    List subList = references.subList(0, max);
                    ArrayList current = Lists.newArrayList(subList);
                    subList.clear();
                    this.server.getBrowseContinuationPoints().put(c.identifier, c);
                    return new BrowseResult(StatusCode.GOOD, c.identifier, current.toArray(new ReferenceDescription[current.size()]));
                }
                return new BrowseResult(StatusCode.GOOD, null, references.toArray(new ReferenceDescription[references.size()]));
            }
            return new BrowseResult(BAD_CONTINUATION_POINT_INVALID, null, null);
        }
    }

    private static class Browse
    implements Runnable {
        private final CompletableFuture<BrowseResult> future = new CompletableFuture();
        private final AccessContext context;
        private final OpcUaServer server;
        private final UInteger maxReferencesPerNode;
        private final BrowseDescription browseDescription;

        private Browse(AccessContext context, OpcUaServer server, UInteger maxReferencesPerNode, BrowseDescription browseDescription) {
            this.context = context;
            this.browseDescription = browseDescription;
            this.maxReferencesPerNode = maxReferencesPerNode;
            this.server = server;
        }

        public CompletableFuture<BrowseResult> getFuture() {
            return this.future;
        }

        @Override
        public void run() {
            NamespaceManager namespaceManager = this.server.getNamespaceManager();
            Namespace namespace = namespaceManager.getNamespace(this.browseDescription.getNodeId().getNamespaceIndex());
            CompletableFuture<List<Reference>> referencesFuture = namespace.browse(this.context, this.browseDescription.getNodeId());
            referencesFuture.whenComplete((references, ex) -> {
                if (references != null) {
                    this.browse((List<Reference>)references).whenComplete((result, ex2) -> {
                        if (result != null) {
                            this.future.complete((BrowseResult)result);
                        } else {
                            this.future.complete(NODE_ID_UNKNOWN_RESULT);
                        }
                    });
                } else {
                    this.future.complete(NODE_ID_UNKNOWN_RESULT);
                }
            });
        }

        private CompletableFuture<BrowseResult> browse(List<Reference> references) {
            List fs = references.stream().filter(this::directionFilter).filter(this::referenceTypeFilter).filter(this::nodeClassFilter).distinct().map(this::referenceDescription).collect(Collectors.toList());
            return FutureUtils.sequence(fs).thenApply(referenceDescriptions -> {
                int max = this.maxReferencesPerNode.longValue() == 0L ? Integer.MAX_VALUE : Ints.saturatedCast((long)this.maxReferencesPerNode.longValue());
                return this.browseResult((List<ReferenceDescription>)referenceDescriptions, max);
            });
        }

        private BrowseResult browseResult(List<ReferenceDescription> references, int max) {
            if (references.size() > max) {
                if (this.server.getBrowseContinuationPoints().size() > this.server.getConfig().getLimits().getMaxBrowseContinuationPoints().intValue()) {
                    return new BrowseResult(BAD_NO_CONTINUATION_POINTS, null, new ReferenceDescription[0]);
                }
                List<ReferenceDescription> subList = references.subList(0, max);
                ArrayList current = Lists.newArrayList(subList);
                subList.clear();
                BrowseContinuationPoint c = new BrowseContinuationPoint(references, max);
                this.server.getBrowseContinuationPoints().put(c.identifier, c);
                return new BrowseResult(StatusCode.GOOD, c.identifier, current.toArray(new ReferenceDescription[current.size()]));
            }
            return new BrowseResult(StatusCode.GOOD, null, references.toArray(new ReferenceDescription[references.size()]));
        }

        private boolean directionFilter(Reference reference) {
            switch (this.browseDescription.getBrowseDirection()) {
                case Forward: {
                    return reference.isForward();
                }
                case Inverse: {
                    return reference.isInverse();
                }
            }
            return true;
        }

        private boolean referenceTypeFilter(Reference reference) {
            NodeId referenceTypeId = this.browseDescription.getReferenceTypeId();
            boolean includeAny = referenceTypeId == null || referenceTypeId.isNull();
            boolean includeSubtypes = this.browseDescription.getIncludeSubtypes();
            return includeAny || reference.getReferenceTypeId().equals((Object)referenceTypeId) || includeSubtypes && reference.subtypeOf(referenceTypeId, this.server.getReferenceTypes());
        }

        private boolean nodeClassFilter(Reference reference) {
            long mask = this.browseDescription.getNodeClassMask().longValue();
            EnumSet<NodeClass> nodeClasses = mask == 0L ? EnumSet.allOf(NodeClass.class) : UaEnumUtil.nodeClasses(mask);
            return nodeClasses.contains(reference.getTargetNodeClass());
        }

        private CompletableFuture<ReferenceDescription> referenceDescription(Reference reference) {
            EnumSet<BrowseResultMask> masks = UaEnumUtil.browseResultMasks(this.browseDescription.getResultMask().longValue());
            ExpandedNodeId targetNodeId = reference.getTargetNodeId();
            NodeId referenceTypeId = masks.contains(BrowseResultMask.ReferenceTypeId) ? reference.getReferenceTypeId() : NodeId.NULL_VALUE;
            return targetNodeId.local().map(nodeId -> {
                CompletableFuture<BrowseAttributes> af = this.browseAttributes((NodeId)nodeId, masks);
                return af.thenCombine(this.getTypeDefinition((NodeId)nodeId), (as, typeDefinition) -> new ReferenceDescription(referenceTypeId, Boolean.valueOf(reference.isForward()), targetNodeId, ((BrowseAttributes)as).getBrowseName(), ((BrowseAttributes)as).getDisplayName(), ((BrowseAttributes)as).getNodeClass(), typeDefinition));
            }).orElse(CompletableFuture.completedFuture(new ReferenceDescription(referenceTypeId, Boolean.valueOf(reference.isForward()), targetNodeId, QualifiedName.NULL_VALUE, LocalizedText.NULL_VALUE, NodeClass.Unspecified, ExpandedNodeId.NULL_VALUE)));
        }

        private CompletableFuture<BrowseAttributes> browseAttributes(NodeId nodeId, EnumSet<BrowseResultMask> masks) {
            ArrayList readValueIds = Lists.newArrayList();
            readValueIds.add(new ReadValueId(nodeId, AttributeId.BrowseName.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(nodeId, AttributeId.DisplayName.uid(), null, QualifiedName.NULL_VALUE));
            readValueIds.add(new ReadValueId(nodeId, AttributeId.NodeClass.uid(), null, QualifiedName.NULL_VALUE));
            CompletableFuture<List<DataValue>> future = new CompletableFuture<List<DataValue>>();
            AttributeManager.ReadContext context = new AttributeManager.ReadContext(this.server, null, future, new DiagnosticsContext<ReadValueId>());
            this.server.getNamespaceManager().getNamespace(nodeId.getNamespaceIndex()).read(context, 0.0, TimestampsToReturn.Neither, readValueIds);
            return future.thenApply(values -> {
                DataValue value2;
                DataValue value1;
                DataValue value0;
                QualifiedName browseName = QualifiedName.NULL_VALUE;
                LocalizedText displayName = LocalizedText.NULL_VALUE;
                NodeClass nodeClass = NodeClass.Unspecified;
                if (masks.contains(BrowseResultMask.BrowseName) && (value0 = (DataValue)values.get(0)).getStatusCode().isGood()) {
                    browseName = (QualifiedName)value0.getValue().getValue();
                }
                if (masks.contains(BrowseResultMask.DisplayName) && (value1 = (DataValue)values.get(1)).getStatusCode().isGood()) {
                    displayName = (LocalizedText)value1.getValue().getValue();
                }
                if (masks.contains(BrowseResultMask.NodeClass) && (value2 = (DataValue)values.get(2)).getStatusCode().isGood()) {
                    nodeClass = (NodeClass)value2.getValue().getValue();
                }
                return new BrowseAttributes(browseName, displayName, nodeClass);
            });
        }

        private CompletableFuture<ExpandedNodeId> getTypeDefinition(NodeId nodeId) {
            Namespace namespace = this.server.getNamespaceManager().getNamespace(nodeId.getNamespaceIndex());
            return namespace.browse(this.context, nodeId).thenApply(references -> references.stream().filter(r -> Identifiers.HasTypeDefinition.equals((Object)r.getReferenceTypeId())).findFirst().map(Reference::getTargetNodeId).orElse(ExpandedNodeId.NULL_VALUE));
        }
    }
}

