/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.IssuedIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserNameIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.X509IdentityToken;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.DigestUtil;

public abstract class AbstractIdentityValidator
implements IdentityValidator {
    @Override
    public Object validateIdentityToken(ServerSecureChannel channel, Session session, UserIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        if (token instanceof AnonymousIdentityToken) {
            return this.validateAnonymousToken(channel, session, (AnonymousIdentityToken)token, tokenPolicy, tokenSignature);
        }
        if (token instanceof UserNameIdentityToken) {
            return this.validateUsernameToken(channel, session, (UserNameIdentityToken)token, tokenPolicy, tokenSignature);
        }
        if (token instanceof X509IdentityToken) {
            return this.validateX509Token(channel, session, (X509IdentityToken)token, tokenPolicy, tokenSignature);
        }
        if (token instanceof IssuedIdentityToken) {
            return this.validateIssuedIdentityToken(channel, session, (IssuedIdentityToken)token, tokenPolicy, tokenSignature);
        }
        throw new UaException(0x80200000L);
    }

    protected Object validateAnonymousToken(ServerSecureChannel channel, Session session, AnonymousIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected Object validateUsernameToken(ServerSecureChannel channel, Session session, UserNameIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected Object validateX509Token(ServerSecureChannel channel, Session session, X509IdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected Object validateIssuedIdentityToken(ServerSecureChannel channel, Session session, IssuedIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        throw new UaException(0x80200000L);
    }

    protected byte[] decryptTokenData(ServerSecureChannel channel, Session session, SecurityAlgorithm algorithm, byte[] dataBytes) throws UaException {
        X509Certificate certificate = CertificateUtil.decodeCertificate((byte[])channel.getEndpointDescription().getServerCertificate().bytesOrEmpty());
        int cipherTextBlockSize = SecureChannel.getAsymmetricCipherTextBlockSize((Certificate)certificate, (SecurityAlgorithm)algorithm);
        int blockCount = dataBytes.length / cipherTextBlockSize;
        int plainTextBufferSize = cipherTextBlockSize * blockCount;
        byte[] plainTextBytes = new byte[plainTextBufferSize];
        ByteBuffer plainTextNioBuffer = ByteBuffer.wrap(plainTextBytes);
        ByteBuffer passwordNioBuffer = ByteBuffer.wrap(dataBytes);
        try {
            KeyPair keyPair = (KeyPair)session.getServer().getConfig().getCertificateManager().getKeyPair(ByteString.of((byte[])DigestUtil.sha1((byte[])certificate.getEncoded()))).orElseThrow(() -> new UaException(2148728832L));
            Cipher cipher = this.getCipher(algorithm, keyPair);
            for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
                passwordNioBuffer.limit(passwordNioBuffer.position() + cipherTextBlockSize);
                cipher.doFinal(passwordNioBuffer, plainTextNioBuffer);
            }
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
        return plainTextBytes;
    }

    private Cipher getCipher(SecurityAlgorithm algorithm, KeyPair keyPair) throws UaException {
        try {
            String transformation = algorithm.getTransformation();
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(2, keyPair.getPrivate());
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
    }
}

