/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.AccessContext;
import org.eclipse.milo.opcua.sdk.server.api.OperationContext;
import org.eclipse.milo.opcua.sdk.server.services.helpers.BrowseHelper;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public interface ViewManager {
    default public void browse(BrowseContext context, ViewDescription view, UInteger maxReferencesPerNode, List<BrowseDescription> nodesToBrowse) {
        OpcUaServer server = context.getServer();
        List futures = nodesToBrowse.stream().map(browseDescription -> BrowseHelper.browse(context, server, view, maxReferencesPerNode, browseDescription)).collect(Collectors.toList());
        FutureUtils.sequence(futures).thenAccept(context::complete);
    }

    public CompletableFuture<List<Reference>> browse(AccessContext var1, NodeId var2);

    public static final class BrowseContext
    extends OperationContext<BrowseDescription, BrowseResult>
    implements AccessContext {
        public BrowseContext(OpcUaServer server, @Nullable Session session, DiagnosticsContext<BrowseDescription> diagnosticsContext) {
            super(server, session, diagnosticsContext);
        }

        public BrowseContext(OpcUaServer server, @Nullable Session session, CompletableFuture<List<BrowseResult>> future, DiagnosticsContext<BrowseDescription> diagnosticsContext) {
            super(server, session, future, diagnosticsContext);
        }
    }
}

