/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.nodes.ReferenceTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

public class UaReferenceTypeNode
extends UaNode
implements ReferenceTypeNode {
    public UaReferenceTypeNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    @Override
    public CompletableFuture<Boolean> getIsAbstract() {
        return this.getAttributeOrFail(this.readIsAbstract());
    }

    @Override
    public CompletableFuture<Boolean> getSymmetric() {
        return this.getAttributeOrFail(this.readSymmetric());
    }

    @Override
    public CompletableFuture<LocalizedText> getInverseName() {
        return this.getAttributeOrFail(this.readInverseName());
    }

    @Override
    public CompletableFuture<StatusCode> setIsAbstract(boolean isAbstract) {
        return this.writeIsAbstract(DataValue.valueOnly((Variant)new Variant((Object)isAbstract)));
    }

    @Override
    public CompletableFuture<StatusCode> setSymmetric(boolean symmetric) {
        return this.writeSymmetric(DataValue.valueOnly((Variant)new Variant((Object)symmetric)));
    }

    @Override
    public CompletableFuture<StatusCode> setInverseName(LocalizedText inverseName) {
        return this.writeInverseName(DataValue.valueOnly((Variant)new Variant((Object)inverseName)));
    }

    @Override
    public CompletableFuture<DataValue> readIsAbstract() {
        return this.readAttribute(AttributeId.IsAbstract);
    }

    @Override
    public CompletableFuture<DataValue> readSymmetric() {
        return this.readAttribute(AttributeId.Symmetric);
    }

    @Override
    public CompletableFuture<DataValue> readInverseName() {
        return this.readAttribute(AttributeId.InverseName);
    }

    @Override
    public CompletableFuture<StatusCode> writeIsAbstract(DataValue value) {
        return this.writeAttribute(AttributeId.IsAbstract, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeSymmetric(DataValue value) {
        return this.writeAttribute(AttributeId.Symmetric, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeInverseName(DataValue value) {
        return this.writeAttribute(AttributeId.InverseName, value);
    }
}

