/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.BaseObjectNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.FolderNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.OperationLimitsNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.ServerCapabilitiesType;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;

public class ServerCapabilitiesNode
extends BaseObjectNode
implements ServerCapabilitiesType {
    public ServerCapabilitiesNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<PropertyNode> getServerProfileArrayNode() {
        return this.getPropertyNode(ServerCapabilitiesType.SERVER_PROFILE_ARRAY);
    }

    @Override
    public CompletableFuture<String[]> getServerProfileArray() {
        return this.getProperty(ServerCapabilitiesType.SERVER_PROFILE_ARRAY);
    }

    @Override
    public CompletableFuture<StatusCode> setServerProfileArray(String[] value) {
        return this.setProperty(ServerCapabilitiesType.SERVER_PROFILE_ARRAY, value);
    }

    public CompletableFuture<PropertyNode> getLocaleIdArrayNode() {
        return this.getPropertyNode(ServerCapabilitiesType.LOCALE_ID_ARRAY);
    }

    @Override
    public CompletableFuture<String[]> getLocaleIdArray() {
        return this.getProperty(ServerCapabilitiesType.LOCALE_ID_ARRAY);
    }

    @Override
    public CompletableFuture<StatusCode> setLocaleIdArray(String[] value) {
        return this.setProperty(ServerCapabilitiesType.LOCALE_ID_ARRAY, value);
    }

    public CompletableFuture<PropertyNode> getMinSupportedSampleRateNode() {
        return this.getPropertyNode(ServerCapabilitiesType.MIN_SUPPORTED_SAMPLE_RATE);
    }

    @Override
    public CompletableFuture<Double> getMinSupportedSampleRate() {
        return this.getProperty(ServerCapabilitiesType.MIN_SUPPORTED_SAMPLE_RATE);
    }

    @Override
    public CompletableFuture<StatusCode> setMinSupportedSampleRate(Double value) {
        return this.setProperty(ServerCapabilitiesType.MIN_SUPPORTED_SAMPLE_RATE, value);
    }

    public CompletableFuture<PropertyNode> getMaxBrowseContinuationPointsNode() {
        return this.getPropertyNode(ServerCapabilitiesType.MAX_BROWSE_CONTINUATION_POINTS);
    }

    @Override
    public CompletableFuture<UShort> getMaxBrowseContinuationPoints() {
        return this.getProperty(ServerCapabilitiesType.MAX_BROWSE_CONTINUATION_POINTS);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxBrowseContinuationPoints(UShort value) {
        return this.setProperty(ServerCapabilitiesType.MAX_BROWSE_CONTINUATION_POINTS, value);
    }

    public CompletableFuture<PropertyNode> getMaxQueryContinuationPointsNode() {
        return this.getPropertyNode(ServerCapabilitiesType.MAX_QUERY_CONTINUATION_POINTS);
    }

    @Override
    public CompletableFuture<UShort> getMaxQueryContinuationPoints() {
        return this.getProperty(ServerCapabilitiesType.MAX_QUERY_CONTINUATION_POINTS);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxQueryContinuationPoints(UShort value) {
        return this.setProperty(ServerCapabilitiesType.MAX_QUERY_CONTINUATION_POINTS, value);
    }

    public CompletableFuture<PropertyNode> getMaxHistoryContinuationPointsNode() {
        return this.getPropertyNode(ServerCapabilitiesType.MAX_HISTORY_CONTINUATION_POINTS);
    }

    @Override
    public CompletableFuture<UShort> getMaxHistoryContinuationPoints() {
        return this.getProperty(ServerCapabilitiesType.MAX_HISTORY_CONTINUATION_POINTS);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxHistoryContinuationPoints(UShort value) {
        return this.setProperty(ServerCapabilitiesType.MAX_HISTORY_CONTINUATION_POINTS, value);
    }

    public CompletableFuture<PropertyNode> getSoftwareCertificatesNode() {
        return this.getPropertyNode(ServerCapabilitiesType.SOFTWARE_CERTIFICATES);
    }

    @Override
    public CompletableFuture<SignedSoftwareCertificate[]> getSoftwareCertificates() {
        return this.getProperty(ServerCapabilitiesType.SOFTWARE_CERTIFICATES);
    }

    @Override
    public CompletableFuture<StatusCode> setSoftwareCertificates(SignedSoftwareCertificate[] value) {
        return this.setProperty(ServerCapabilitiesType.SOFTWARE_CERTIFICATES, value);
    }

    public CompletableFuture<PropertyNode> getMaxArrayLengthNode() {
        return this.getPropertyNode(ServerCapabilitiesType.MAX_ARRAY_LENGTH);
    }

    @Override
    public CompletableFuture<UInteger> getMaxArrayLength() {
        return this.getProperty(ServerCapabilitiesType.MAX_ARRAY_LENGTH);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxArrayLength(UInteger value) {
        return this.setProperty(ServerCapabilitiesType.MAX_ARRAY_LENGTH, value);
    }

    public CompletableFuture<PropertyNode> getMaxStringLengthNode() {
        return this.getPropertyNode(ServerCapabilitiesType.MAX_STRING_LENGTH);
    }

    @Override
    public CompletableFuture<UInteger> getMaxStringLength() {
        return this.getProperty(ServerCapabilitiesType.MAX_STRING_LENGTH);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxStringLength(UInteger value) {
        return this.setProperty(ServerCapabilitiesType.MAX_STRING_LENGTH, value);
    }

    public CompletableFuture<PropertyNode> getMaxByteStringLengthNode() {
        return this.getPropertyNode(ServerCapabilitiesType.MAX_BYTE_STRING_LENGTH);
    }

    @Override
    public CompletableFuture<UInteger> getMaxByteStringLength() {
        return this.getProperty(ServerCapabilitiesType.MAX_BYTE_STRING_LENGTH);
    }

    @Override
    public CompletableFuture<StatusCode> setMaxByteStringLength(UInteger value) {
        return this.setProperty(ServerCapabilitiesType.MAX_BYTE_STRING_LENGTH, value);
    }

    public CompletableFuture<OperationLimitsNode> getOperationLimitsNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "OperationLimits").thenApply(OperationLimitsNode.class::cast);
    }

    public CompletableFuture<FolderNode> getModellingRulesNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "ModellingRules").thenApply(FolderNode.class::cast);
    }

    public CompletableFuture<FolderNode> getAggregateFunctionsNode() {
        return this.getObjectComponent("http://opcfoundation.org/UA/", "AggregateFunctions").thenApply(FolderNode.class::cast);
    }
}

