/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.api.identity;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.SignedIdentityToken;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.InsecureCertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserNameIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsernameProvider
implements IdentityProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String username;
    private final String password;
    private final CertificateValidator certificateValidator;
    private final Function<List<UserTokenPolicy>, UserTokenPolicy> policyChooser;

    public UsernameProvider(String username, String password) {
        this(username, password, (CertificateValidator)new InsecureCertificateValidator());
    }

    public UsernameProvider(String username, String password, CertificateValidator certificateValidator) {
        this(username, password, certificateValidator, ps -> (UserTokenPolicy)ps.get(0));
    }

    public UsernameProvider(String username, String password, CertificateValidator certificateValidator, Function<List<UserTokenPolicy>, UserTokenPolicy> policyChooser) {
        this.username = username;
        this.password = password;
        this.certificateValidator = certificateValidator;
        this.policyChooser = policyChooser;
    }

    @Override
    public SignedIdentityToken getIdentityToken(EndpointDescription endpoint, ByteString serverNonce) throws Exception {
        Object bs;
        SecurityPolicy securityPolicy;
        List userIdentityTokens = ConversionUtil.l((Object[])endpoint.getUserIdentityTokens());
        List tokenPolicies = userIdentityTokens.stream().filter(t -> t.getTokenType() == UserTokenType.UserName).collect(Collectors.toList());
        if (tokenPolicies.isEmpty()) {
            throw new Exception("no UserTokenPolicy with UserTokenType.UserName found");
        }
        UserTokenPolicy tokenPolicy = this.policyChooser.apply(tokenPolicies);
        String securityPolicyUri = tokenPolicy.getSecurityPolicyUri();
        try {
            if (securityPolicyUri == null || securityPolicyUri.isEmpty()) {
                securityPolicyUri = endpoint.getSecurityPolicyUri();
            }
            securityPolicy = SecurityPolicy.fromUri((String)securityPolicyUri);
        }
        catch (Throwable t2) {
            throw new UaException(0x80550000L, t2);
        }
        byte[] passwordBytes = this.password.getBytes(StandardCharsets.UTF_8);
        byte[] nonceBytes = serverNonce.bytesOrEmpty();
        ByteBuf buffer = Unpooled.buffer();
        if (securityPolicy == SecurityPolicy.None) {
            buffer.writeBytes(passwordBytes);
        } else {
            NonceUtil.validateNonce((ByteString)serverNonce);
            buffer.writeIntLE(passwordBytes.length + nonceBytes.length);
            buffer.writeBytes(passwordBytes);
            buffer.writeBytes(nonceBytes);
            bs = endpoint.getServerCertificate();
            if (bs == null || bs.isNull()) {
                throw new UaException(0x80890000L, "UserTokenPolicy requires encryption but server did not provide a certificate in endpoint");
            }
            List certificateChain = CertificateUtil.decodeCertificates((byte[])bs.bytes());
            X509Certificate certificate = (X509Certificate)certificateChain.get(0);
            if (SecurityPolicy.None.getUri().equals(endpoint.getSecurityPolicyUri()) || !"http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary".equals(endpoint.getTransportProfileUri())) {
                this.certificateValidator.validate(certificate);
                this.certificateValidator.verifyTrustChain(certificateChain);
            }
            int plainTextBlockSize = SecureChannel.getAsymmetricPlainTextBlockSize((X509Certificate)certificate, (SecurityAlgorithm)securityPolicy.getAsymmetricEncryptionAlgorithm());
            int cipherTextBlockSize = SecureChannel.getAsymmetricCipherTextBlockSize((Certificate)certificate, (SecurityAlgorithm)securityPolicy.getAsymmetricEncryptionAlgorithm());
            int blockCount = (buffer.readableBytes() + plainTextBlockSize - 1) / plainTextBlockSize;
            Cipher cipher = this.getAndInitializeCipher(certificate, securityPolicy);
            ByteBuffer plainTextNioBuffer = buffer.nioBuffer();
            ByteBuffer cipherTextNioBuffer = Unpooled.buffer((int)(cipherTextBlockSize * blockCount)).nioBuffer(0, cipherTextBlockSize * blockCount);
            for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
                int position = blockNumber * plainTextBlockSize;
                int limit = Math.min(buffer.readableBytes(), (blockNumber + 1) * plainTextBlockSize);
                ((Buffer)plainTextNioBuffer).position(position);
                ((Buffer)plainTextNioBuffer).limit(limit);
                cipher.doFinal(plainTextNioBuffer, cipherTextNioBuffer);
            }
            ((Buffer)cipherTextNioBuffer).flip();
            buffer = Unpooled.wrappedBuffer((ByteBuffer)cipherTextNioBuffer);
        }
        bs = new byte[buffer.readableBytes()];
        buffer.readBytes(bs);
        String securityAlgorithmUri = securityPolicy.getAsymmetricEncryptionAlgorithm().getUri();
        String encryptionAlgorithm = securityAlgorithmUri.isEmpty() ? null : securityAlgorithmUri;
        UserNameIdentityToken token = new UserNameIdentityToken(tokenPolicy.getPolicyId(), this.username, ByteString.of((byte[])bs), encryptionAlgorithm);
        return new SignedIdentityToken((UserIdentityToken)token, new SignatureData());
    }

    private Cipher getAndInitializeCipher(X509Certificate serverCertificate, SecurityPolicy securityPolicy) throws UaException {
        assert (serverCertificate != null);
        try {
            String transformation = securityPolicy.getAsymmetricEncryptionAlgorithm().getTransformation();
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(1, serverCertificate.getPublicKey());
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
    }

    public String toString() {
        return "UsernameProvider{username='" + this.username + '\'' + '}';
    }

    public static UsernameProvider of(String username, String password, CertificateValidator certificateValidator) {
        return new UsernameProvider(username, password, certificateValidator);
    }
}

