/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.session.states;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.session.Fsm;
import org.eclipse.milo.opcua.sdk.client.session.events.CloseSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.Event;
import org.eclipse.milo.opcua.sdk.client.session.states.AbstractSessionState;
import org.eclipse.milo.opcua.sdk.client.session.states.Activating;
import org.eclipse.milo.opcua.sdk.client.session.states.Closing;
import org.eclipse.milo.opcua.sdk.client.session.states.Inactive;
import org.eclipse.milo.opcua.sdk.client.session.states.SessionState;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionResponse;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public class Creating
extends AbstractSessionState
implements SessionState {
    private CompletableFuture<OpcUaSession> sessionFuture = new CompletableFuture();

    @Override
    public CompletableFuture<OpcUaSession> getSessionFuture() {
        return this.sessionFuture;
    }

    @Override
    public void onExternalTransition(Fsm fsm, SessionState from, Event event) {
        if (from instanceof Inactive && event instanceof CreateSessionEvent) {
            this.sessionFuture = ((CreateSessionEvent)event).getSessionFuture();
        }
    }

    @Override
    public void onInternalTransition(Fsm fsm, Event event) {
        if (event instanceof CreateSessionEvent) {
            CreateSessionEvent e = (CreateSessionEvent)event;
            FutureUtils.complete(e.getSessionFuture()).with(this.sessionFuture);
        }
    }

    @Override
    public SessionState execute(Fsm fsm, Event e) {
        if (e instanceof CreateSessionSuccessEvent) {
            CreateSessionResponse csr = ((CreateSessionSuccessEvent)e).getResponse();
            Creating.activateSessionAsync(fsm, csr, this.sessionFuture);
            return new Activating();
        }
        if (e instanceof CreateSessionFailureEvent) {
            Throwable failure = ((CreateSessionFailureEvent)e).getFailure();
            this.sessionFuture.completeExceptionally(failure);
            return new Inactive();
        }
        if (e instanceof CloseSessionEvent) {
            return new Closing();
        }
        return this;
    }
}

