/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.session.states;

import com.codepoetics.protonpack.StreamUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Bytes;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.session.Fsm;
import org.eclipse.milo.opcua.sdk.client.session.SessionFsm;
import org.eclipse.milo.opcua.sdk.client.session.events.ActivateSessionFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.ActivateSessionSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CloseSessionSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.CreateSessionSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.InitializeFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.InitializeSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.ReactivateFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.ReactivateSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.TransferFailureEvent;
import org.eclipse.milo.opcua.sdk.client.session.events.TransferSuccessEvent;
import org.eclipse.milo.opcua.sdk.client.session.states.SessionState;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaSubscriptionManager;
import org.eclipse.milo.opcua.stack.client.UaTcpStackClient;
import org.eclipse.milo.opcua.stack.core.StatusCodes;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferResult;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.core.util.SignatureUtil;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSessionState
implements SessionState {
    private static final UInteger REQUEST_TIMEOUT = Unsigned.uint((int)16000);
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionFsm.class);

    AbstractSessionState() {
    }

    static void createSessionAsync(Fsm fsm, CompletableFuture<OpcUaSession> sessionFuture) {
        fsm.getClient().getConfig().getExecutor().execute(() -> AbstractSessionState.createSession(fsm, sessionFuture));
    }

    private static void createSession(Fsm fsm, CompletableFuture<OpcUaSession> sessionFuture) {
        OpcUaClient client = fsm.getClient();
        UaTcpStackClient stackClient = client.getStackClient();
        String serverUri = stackClient.getEndpoint().flatMap(e -> {
            String gatewayServerUri = e.getServer().getGatewayServerUri();
            if (gatewayServerUri != null && !gatewayServerUri.isEmpty()) {
                return Optional.ofNullable(e.getServer().getApplicationUri());
            }
            return Optional.empty();
        }).orElse(null);
        ByteString clientNonce = NonceUtil.generateNonce((int)32);
        ByteString clientCertificate = stackClient.getConfig().getCertificate().map(c -> {
            try {
                return ByteString.of((byte[])c.getEncoded());
            }
            catch (CertificateEncodingException e) {
                return ByteString.NULL_VALUE;
            }
        }).orElse(ByteString.NULL_VALUE);
        CreateSessionRequest request = new CreateSessionRequest(client.newRequestHeader(REQUEST_TIMEOUT), stackClient.getApplication(), serverUri, stackClient.getEndpointUrl(), client.getConfig().getSessionName().get(), clientNonce, clientCertificate, Double.valueOf(client.getConfig().getSessionTimeout().doubleValue()), client.getConfig().getMaxResponseMessageSize());
        LOGGER.debug("Sending CreateSessionRequest...");
        stackClient.sendRequest((UaRequestMessage)request).whenCompleteAsync((response, ex) -> {
            if (response != null) {
                LOGGER.debug("CreateSession succeeded: {}", (Object)response.getSessionId());
                try {
                    EndpointDescription endpoint = (EndpointDescription)stackClient.getEndpoint().orElseThrow(() -> new UaException(0x80020000L, "cannot create session with no endpoint configured"));
                    SecurityPolicy securityPolicy = SecurityPolicy.fromUri((String)endpoint.getSecurityPolicyUri());
                    if (securityPolicy != SecurityPolicy.None) {
                        X509Certificate certificateFromEndpoint;
                        X509Certificate certificateFromResponse = CertificateUtil.decodeCertificate((byte[])response.getServerCertificate().bytesOrEmpty());
                        if (!certificateFromResponse.equals(certificateFromEndpoint = CertificateUtil.decodeCertificate((byte[])endpoint.getServerCertificate().bytesOrEmpty()))) {
                            throw new UaException(2148728832L, "Certificate from CreateSessionResponse did not match certificate from EndpointDescription!");
                        }
                        SignatureData serverSignature = response.getServerSignature();
                        byte[] dataBytes = Bytes.concat((byte[][])new byte[][]{clientCertificate.bytesOrEmpty(), clientNonce.bytesOrEmpty()});
                        byte[] signatureBytes = serverSignature.getSignature().bytesOrEmpty();
                        SignatureUtil.verify((SecurityAlgorithm)SecurityAlgorithm.fromUri((String)serverSignature.getAlgorithm()), (X509Certificate)certificateFromResponse, (byte[])dataBytes, (byte[])signatureBytes);
                    }
                    fsm.fireEvent(new CreateSessionSuccessEvent((CreateSessionResponse)response, sessionFuture));
                }
                catch (UaException e) {
                    LOGGER.debug("CreateSession failed: {}", (Object)e.getMessage(), (Object)e);
                    fsm.fireEvent(new CreateSessionFailureEvent(e, sessionFuture));
                }
            } else {
                LOGGER.debug("CreateSession failed: {}", (Object)ex.getMessage(), ex);
                fsm.fireEvent(new CreateSessionFailureEvent((Throwable)ex, sessionFuture));
            }
        }, (Executor)stackClient.getExecutorService());
    }

    static void activateSessionAsync(Fsm fsm, CreateSessionResponse csr, CompletableFuture<OpcUaSession> sessionFuture) {
        fsm.getClient().getConfig().getExecutor().execute(() -> AbstractSessionState.activateSession(fsm, csr, sessionFuture));
    }

    private static void activateSession(Fsm fsm, CreateSessionResponse csr, CompletableFuture<OpcUaSession> sessionFuture) {
        OpcUaClient client = fsm.getClient();
        UaTcpStackClient stackClient = client.getStackClient();
        CompletableFuture cf = stackClient.getChannelFuture();
        CompletionStage af = cf.thenCompose(secureChannel -> {
            try {
                EndpointDescription endpoint = (EndpointDescription)stackClient.getEndpoint().orElseThrow(() -> new UaException(0x80020000L, "cannot create session with no endpoint configured"));
                ByteString serverNonce = csr.getServerNonce();
                Tuple2<UserIdentityToken, SignatureData> tuple = client.getConfig().getIdentityProvider().getIdentityToken(endpoint, serverNonce);
                UserIdentityToken userIdentityToken = (UserIdentityToken)tuple.v1();
                SignatureData userTokenSignature = (SignatureData)tuple.v2();
                ActivateSessionRequest request = new ActivateSessionRequest(client.newRequestHeader(csr.getAuthenticationToken(), REQUEST_TIMEOUT), AbstractSessionState.buildClientSignature(secureChannel, serverNonce), new SignedSoftwareCertificate[0], new String[0], ExtensionObject.encode((UaStructure)userIdentityToken), userTokenSignature);
                LOGGER.debug("Sending ActivateSessionRequest, secureChannelId={}, channel={}...", (Object)secureChannel.getChannelId(), (Object)secureChannel.getChannel());
                return stackClient.sendRequest((UaRequestMessage)request);
            }
            catch (Exception e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
        ((CompletableFuture)af).whenCompleteAsync((asr, ex) -> {
            if (asr != null) {
                OpcUaSession session = new OpcUaSession(csr.getAuthenticationToken(), csr.getSessionId(), client.getConfig().getSessionName().get(), csr.getRevisedSessionTimeout(), csr.getMaxRequestMessageSize(), csr.getServerCertificate(), csr.getServerSoftwareCertificates());
                LOGGER.debug("Session activated: {}", (Object)session);
                session.setServerNonce(asr.getServerNonce());
                fsm.fireEvent(new ActivateSessionSuccessEvent(session, sessionFuture));
            } else {
                fsm.fireEvent(new ActivateSessionFailureEvent((Throwable)ex, sessionFuture));
            }
        }, (Executor)stackClient.getExecutorService());
    }

    static void closeSessionAsync(Fsm fsm, OpcUaSession session, CompletableFuture<Unit> closeFuture, CompletableFuture<OpcUaSession> sessionFuture) {
        fsm.getClient().getConfig().getExecutor().execute(() -> AbstractSessionState.closeSession(fsm, session.getAuthenticationToken(), session.getSessionId(), closeFuture, sessionFuture));
    }

    static void closeSessionAsync(Fsm fsm, NodeId authToken, NodeId sessionId, CompletableFuture<Unit> closeFuture, CompletableFuture<OpcUaSession> sessionFuture) {
        fsm.getClient().getConfig().getExecutor().execute(() -> AbstractSessionState.closeSession(fsm, authToken, sessionId, closeFuture, sessionFuture));
    }

    private static void closeSession(Fsm fsm, NodeId authToken, NodeId sessionId, CompletableFuture<Unit> closeFuture, CompletableFuture<OpcUaSession> sessionFuture) {
        OpcUaClient client = fsm.getClient();
        UaTcpStackClient stackClient = client.getStackClient();
        RequestHeader requestHeader = new RequestHeader(authToken, DateTime.now(), client.nextRequestHandle(), Unsigned.uint((int)0), null, Unsigned.uint((int)5000), null);
        CloseSessionRequest request = new CloseSessionRequest(requestHeader, Boolean.valueOf(true));
        LOGGER.debug("Sending CloseSessionRequest...");
        stackClient.sendRequest((UaRequestMessage)request).whenCompleteAsync((csr, ex2) -> {
            if (ex2 != null) {
                LOGGER.debug("CloseSession failed: {}", (Object)ex2.getMessage(), ex2);
            } else {
                LOGGER.debug("Session closed: {}", (Object)sessionId);
            }
            fsm.fireEvent(new CloseSessionSuccessEvent(closeFuture, sessionFuture));
        }, (Executor)stackClient.getConfig().getExecutor());
    }

    static void reactivateSessionAsync(Fsm fsm, OpcUaSession session, CompletableFuture<OpcUaSession> sessionFuture) {
        fsm.getClient().getConfig().getExecutor().execute(() -> AbstractSessionState.reactivateSession(fsm, session, sessionFuture));
    }

    private static void reactivateSession(Fsm fsm, OpcUaSession session, CompletableFuture<OpcUaSession> sessionFuture) {
        OpcUaClient client = fsm.getClient();
        UaTcpStackClient stackClient = client.getStackClient();
        Function<ClientSecureChannel, CompletionStage> activate = secureChannel -> {
            try {
                EndpointDescription endpoint = (EndpointDescription)stackClient.getEndpoint().orElseThrow(() -> new Exception("cannot create session with no endpoint configured"));
                Tuple2<UserIdentityToken, SignatureData> tuple = client.getConfig().getIdentityProvider().getIdentityToken(endpoint, session.getServerNonce());
                UserIdentityToken userIdentityToken = (UserIdentityToken)tuple.v1();
                SignatureData userTokenSignature = (SignatureData)tuple.v2();
                SignatureData clientSignature = AbstractSessionState.buildClientSignature(secureChannel, session.getServerNonce());
                ActivateSessionRequest request = new ActivateSessionRequest(client.newRequestHeader(session.getAuthenticationToken(), REQUEST_TIMEOUT), clientSignature, new SignedSoftwareCertificate[0], new String[0], ExtensionObject.encode((UaStructure)userIdentityToken), userTokenSignature);
                LOGGER.debug("Sending (re)ActivateSessionRequest, secureChannelId={}, channel={}...", (Object)secureChannel.getChannelId(), (Object)secureChannel.getChannel());
                return stackClient.sendRequest((UaRequestMessage)request);
            }
            catch (Exception e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        };
        ((CompletableFuture)stackClient.getChannelFuture().thenCompose(activate)).whenCompleteAsync((asr, ex) -> {
            if (asr != null) {
                LOGGER.debug("Session reactivated: {}", (Object)session);
                session.setServerNonce(asr.getServerNonce());
                fsm.fireEvent(new ReactivateSuccessEvent(session, sessionFuture));
            } else {
                LOGGER.debug("(re)ActivateSession failed: {}", (Object)session, ex);
                fsm.fireEvent(new ReactivateFailureEvent((Throwable)ex, session, sessionFuture));
            }
        }, (Executor)stackClient.getExecutorService());
    }

    static void transferSubscriptionsAsync(Fsm fsm, OpcUaSession session, CompletableFuture<OpcUaSession> sessionFuture) {
        fsm.getClient().getConfig().getExecutor().execute(() -> AbstractSessionState.transferSubscriptions(fsm, session, sessionFuture));
    }

    private static void transferSubscriptions(Fsm fsm, OpcUaSession session, CompletableFuture<OpcUaSession> sessionFuture) {
        OpcUaClient client = fsm.getClient();
        UaTcpStackClient stackClient = client.getStackClient();
        OpcUaSubscriptionManager subscriptionManager = client.getSubscriptionManager();
        ImmutableList<UaSubscription> subscriptions = subscriptionManager.getSubscriptions();
        if (subscriptions.isEmpty()) {
            fsm.fireEvent(new TransferSuccessEvent(session, sessionFuture));
            return;
        }
        UInteger[] subscriptionIdsArray = (UInteger[])subscriptions.stream().map(UaSubscription::getSubscriptionId).toArray(UInteger[]::new);
        TransferSubscriptionsRequest request = new TransferSubscriptionsRequest(client.newRequestHeader(session.getAuthenticationToken(), REQUEST_TIMEOUT), subscriptionIdsArray, Boolean.valueOf(true));
        LOGGER.debug("Sending TransferSubscriptionsRequest...");
        stackClient.sendRequest((UaRequestMessage)request).whenCompleteAsync((tsr, ex) -> {
            if (tsr != null) {
                List results = ConversionUtil.l((Object[])tsr.getResults());
                client.getConfig().getExecutor().execute(() -> {
                    for (int i = 0; i < results.size(); ++i) {
                        TransferResult result = (TransferResult)results.get(i);
                        if (result.getStatusCode().isGood()) continue;
                        UaSubscription subscription = (UaSubscription)subscriptions.get(i);
                        subscriptionManager.transferFailed(subscription.getSubscriptionId(), result.getStatusCode());
                    }
                });
                if (LOGGER.isDebugEnabled()) {
                    Stream<UInteger> subscriptionIds = subscriptions.stream().map(UaSubscription::getSubscriptionId);
                    Stream<StatusCode> statusCodes = results.stream().map(TransferResult::getStatusCode);
                    Object[] ss = (String[])StreamUtils.zip(subscriptionIds, statusCodes, (i, s) -> String.format("id=%s/%s", i, StatusCodes.lookup((long)s.getValue()).map(sa -> sa[0]).orElse(s.toString()))).toArray(String[]::new);
                    LOGGER.debug("TransferSubscriptions results: {}", (Object)Arrays.toString(ss));
                }
                fsm.fireEvent(new TransferSuccessEvent(session, sessionFuture));
            } else {
                StatusCode statusCode = UaException.extract((Throwable)ex).map(UaException::getStatusCode).orElse(StatusCode.BAD);
                if (statusCode.getValue() == 0x80400000L || statusCode.getValue() == 2151481344L || statusCode.getValue() == 0x808D0000L || statusCode.getValue() == 0x800B0000L) {
                    LOGGER.debug("TransferSubscriptions not supported: {}", (Object)statusCode);
                    client.getConfig().getExecutor().execute(() -> {
                        for (UaSubscription subscription : subscriptions) {
                            subscriptionManager.transferFailed(subscription.getSubscriptionId(), statusCode);
                        }
                    });
                    fsm.fireEvent(new TransferSuccessEvent(session, sessionFuture));
                } else {
                    LOGGER.debug("TransferSubscriptions failed: {}", (Object)statusCode);
                    fsm.fireEvent(new TransferFailureEvent((Throwable)ex, session, sessionFuture));
                }
            }
        }, (Executor)stackClient.getExecutorService());
    }

    static void initializeSessionAsync(Fsm fsm, OpcUaSession session, CompletableFuture<OpcUaSession> sessionFuture) {
        fsm.getClient().getConfig().getExecutor().execute(() -> AbstractSessionState.initializeSession(fsm, session, sessionFuture));
    }

    private static void initializeSession(Fsm fsm, OpcUaSession session, CompletableFuture<OpcUaSession> sessionFuture) {
        List<SessionFsm.SessionInitializer> initializers = fsm.getInitializers();
        if (initializers.isEmpty()) {
            fsm.fireEvent(new InitializeSuccessEvent(session, sessionFuture));
        } else {
            UaTcpStackClient stackClient = fsm.getClient().getStackClient();
            CompletableFuture[] futures = (CompletableFuture[])initializers.stream().map(i -> i.initialize(stackClient, session)).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).whenCompleteAsync((v, ex) -> {
                if (ex != null) {
                    LOGGER.warn("Initialization failed: {}", (Object)session, ex);
                    fsm.fireEvent(new InitializeFailureEvent((Throwable)ex, session, sessionFuture));
                } else {
                    LOGGER.debug("Initialization succeeded: {}", (Object)session);
                    fsm.fireEvent(new InitializeSuccessEvent(session, sessionFuture));
                }
            }, (Executor)stackClient.getExecutorService());
        }
    }

    private static SignatureData buildClientSignature(ClientSecureChannel secureChannel, ByteString serverNonce) throws Exception {
        if (secureChannel.getSecurityPolicy() == SecurityPolicy.None) {
            return new SignatureData();
        }
        SecurityAlgorithm signatureAlgorithm = secureChannel.getSecurityPolicy().getAsymmetricSignatureAlgorithm();
        PrivateKey privateKey = secureChannel.getKeyPair().getPrivate();
        ByteString serverCertificate = secureChannel.getRemoteCertificateBytes();
        byte[] serverNonceBytes = serverNonce.bytesOrEmpty();
        byte[] serverCertificateBytes = serverCertificate.bytesOrEmpty();
        byte[] dataToSign = Bytes.concat((byte[][])new byte[][]{serverCertificateBytes, serverNonceBytes});
        byte[] signature = SignatureUtil.sign((SecurityAlgorithm)signatureAlgorithm, (PrivateKey)privateKey, (ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(dataToSign)});
        return new SignatureData(signatureAlgorithm.getUri(), ByteString.of((byte[])signature));
    }
}

