/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

public class UaMethodNode
extends UaNode
implements MethodNode {
    public UaMethodNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    @Override
    public CompletableFuture<Boolean> getExecutable() {
        return this.getAttributeOrFail(this.readExecutable());
    }

    @Override
    public CompletableFuture<Boolean> getUserExecutable() {
        return this.getAttributeOrFail(this.readUserExecutable());
    }

    @Override
    public CompletableFuture<StatusCode> setExecutable(boolean executable) {
        return this.writeExecutable(DataValue.valueOnly((Variant)new Variant((Object)executable)));
    }

    @Override
    public CompletableFuture<StatusCode> setUserExecutable(boolean userExecutable) {
        return this.writeUserExecutable(DataValue.valueOnly((Variant)new Variant((Object)userExecutable)));
    }

    @Override
    public CompletableFuture<DataValue> readExecutable() {
        return this.readAttribute(AttributeId.Executable);
    }

    @Override
    public CompletableFuture<DataValue> readUserExecutable() {
        return this.readAttribute(AttributeId.UserExecutable);
    }

    @Override
    public CompletableFuture<StatusCode> writeExecutable(DataValue value) {
        return this.writeAttribute(AttributeId.Executable, value);
    }

    @Override
    public CompletableFuture<StatusCode> writeUserExecutable(DataValue value) {
        return this.writeAttribute(AttributeId.UserExecutable, value);
    }
}

