/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.milo.opcua.sdk.client.ClientDataTypeManager;
import org.eclipse.milo.opcua.sdk.client.DataTypeDictionaryReader;
import org.eclipse.milo.opcua.sdk.client.DefaultAddressSpace;
import org.eclipse.milo.opcua.sdk.client.DefaultNodeCache;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.SessionActivityListener;
import org.eclipse.milo.opcua.sdk.client.TypeRegistry;
import org.eclipse.milo.opcua.sdk.client.api.AddressSpace;
import org.eclipse.milo.opcua.sdk.client.api.NodeCache;
import org.eclipse.milo.opcua.sdk.client.api.ServiceFaultListener;
import org.eclipse.milo.opcua.sdk.client.api.UaClient;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.model.TypeRegistryInitializer;
import org.eclipse.milo.opcua.sdk.client.session.SessionFsm;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaSubscriptionManager;
import org.eclipse.milo.opcua.stack.client.UaTcpStackClient;
import org.eclipse.milo.opcua.stack.client.config.UaTcpStackClientConfig;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.UaServiceFaultException;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SubscriptionAcknowledgement;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;
import org.eclipse.milo.opcua.stack.core.util.ManifestUtil;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaClient
implements UaClient {
    public static final String SDK_VERSION = ManifestUtil.read((String)"X-SDK-Version").orElse("dev");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ServiceFaultListener> faultListeners = Lists.newCopyOnWriteArrayList();
    private final ExecutionQueue faultNotificationQueue;
    private final NamespaceTable namespaceTable = new NamespaceTable();
    private final AddressSpace addressSpace;
    private final NodeCache nodeCache = new DefaultNodeCache();
    private final DataTypeManager dataTypeManager = new ClientDataTypeManager();
    private final TypeRegistry typeRegistry = new TypeRegistry();
    private final OpcUaSubscriptionManager subscriptionManager;
    private final UaTcpStackClient stackClient;
    private final SessionFsm sessionFsm;
    private final OpcUaClientConfig config;

    public OpcUaClient(OpcUaClientConfig config) {
        this.config = config;
        this.sessionFsm = new SessionFsm(this);
        this.sessionFsm.addInitializer((stackClient, session) -> {
            this.logger.debug("SessionInitializer: DataTypeDictionary");
            DataTypeDictionaryReader reader = new DataTypeDictionaryReader(stackClient, session, config.getBsdParser());
            return ((CompletableFuture)((CompletableFuture)reader.readDataTypeDictionaries().thenAccept(dictionaries -> dictionaries.forEach(arg_0 -> ((DataTypeManager)this.dataTypeManager).registerTypeDictionary(arg_0)))).thenApply(v -> Unit.VALUE)).exceptionally(ex -> {
                this.logger.warn("SessionInitializer: DataTypeDictionary", ex);
                return Unit.VALUE;
            });
        });
        this.sessionFsm.addInitializer((stackClient, session) -> {
            this.logger.debug("SessionInitializer: NamespaceTable");
            RequestHeader requestHeader = this.newRequestHeader(session.getAuthenticationToken());
            ReadRequest readRequest = new ReadRequest(requestHeader, Double.valueOf(0.0), TimestampsToReturn.Neither, new ReadValueId[]{new ReadValueId(Identifiers.Server_NamespaceArray, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)});
            CompletionStage namespaceArray = ((CompletableFuture)stackClient.sendRequest((UaRequestMessage)readRequest).thenApply(response -> Objects.requireNonNull(response.getResults()))).thenApply(results -> (String[])results[0].getValue().getValue());
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)namespaceArray).thenAccept(uris -> this.namespaceTable.update(uriTable -> {
                uriTable.clear();
                for (int i = 0; i < ((String[])uris).length; ++i) {
                    String uri = uris[i];
                    if (uri == null || uriTable.containsValue((Object)uri)) continue;
                    uriTable.put((Object)Unsigned.ushort((int)i), (Object)uri);
                }
            }))).thenApply(v -> Unit.VALUE)).exceptionally(ex -> {
                this.logger.warn("SessionInitializer: NamespaceTable", ex);
                return Unit.VALUE;
            });
        });
        this.stackClient = new UaTcpStackClient((UaTcpStackClientConfig)config);
        this.faultNotificationQueue = new ExecutionQueue(config.getExecutor());
        this.addressSpace = new DefaultAddressSpace(this);
        this.subscriptionManager = new OpcUaSubscriptionManager(this);
        TypeRegistryInitializer.initialize(this.typeRegistry);
    }

    @Override
    public OpcUaClientConfig getConfig() {
        return this.config;
    }

    public UaTcpStackClient getStackClient() {
        return this.stackClient;
    }

    @Override
    public NodeCache getNodeCache() {
        return this.nodeCache;
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.addressSpace;
    }

    public DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public NamespaceTable getNamespaceTable() {
        return this.namespaceTable;
    }

    public RequestHeader newRequestHeader() {
        return this.newRequestHeader(NodeId.NULL_VALUE, this.config.getRequestTimeout());
    }

    public RequestHeader newRequestHeader(UInteger requestTimeout) {
        return this.newRequestHeader(NodeId.NULL_VALUE, requestTimeout);
    }

    public RequestHeader newRequestHeader(NodeId authToken) {
        return this.newRequestHeader(authToken, this.config.getRequestTimeout());
    }

    public RequestHeader newRequestHeader(NodeId authToken, UInteger requestTimeout) {
        return this.getStackClient().newRequestHeader(authToken, requestTimeout);
    }

    public UInteger nextRequestHandle() {
        return this.getStackClient().nextRequestHandle();
    }

    public CompletableFuture<UaClient> connect() {
        return ((CompletableFuture)this.getStackClient().connect().thenCompose(c -> this.sessionFsm.openSession())).thenApply(s -> this);
    }

    public CompletableFuture<OpcUaClient> disconnect() {
        this.subscriptionManager.clearSubscriptions();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.sessionFsm.closeSession().exceptionally(ex -> Unit.VALUE)).thenCompose(u -> this.getStackClient().disconnect())).thenApply(c -> this)).exceptionally(ex -> this);
    }

    @Override
    public OpcUaSubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    @Override
    public CompletableFuture<ReadResponse> read(double maxAge, TimestampsToReturn timestampsToReturn, List<ReadValueId> readValueIds) {
        return this.getSession().thenCompose(session -> {
            ReadRequest request = new ReadRequest(this.newRequestHeader(session.getAuthenticationToken()), Double.valueOf(maxAge), timestampsToReturn, (ReadValueId[])ConversionUtil.a((List)readValueIds, ReadValueId.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<WriteResponse> write(List<WriteValue> writeValues) {
        return this.getSession().thenCompose(session -> {
            WriteRequest request = new WriteRequest(this.newRequestHeader(session.getAuthenticationToken()), (WriteValue[])ConversionUtil.a((List)writeValues, WriteValue.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<HistoryReadResponse> historyRead(HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, boolean releaseContinuationPoints, List<HistoryReadValueId> nodesToRead) {
        return this.getSession().thenCompose(session -> {
            HistoryReadRequest request = new HistoryReadRequest(this.newRequestHeader(session.getAuthenticationToken()), ExtensionObject.encode((UaStructure)historyReadDetails), timestampsToReturn, Boolean.valueOf(releaseContinuationPoints), (HistoryReadValueId[])ConversionUtil.a((List)nodesToRead, HistoryReadValueId.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<HistoryUpdateResponse> historyUpdate(List<HistoryUpdateDetails> historyUpdateDetails) {
        return this.getSession().thenCompose(session -> {
            ExtensionObject[] details = (ExtensionObject[])historyUpdateDetails.stream().map(ExtensionObject::encode).toArray(ExtensionObject[]::new);
            HistoryUpdateRequest request = new HistoryUpdateRequest(this.newRequestHeader(session.getAuthenticationToken()), details);
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<BrowseResponse> browse(ViewDescription viewDescription, UInteger maxReferencesPerNode, List<BrowseDescription> nodesToBrowse) {
        return this.getSession().thenCompose(session -> {
            BrowseRequest request = new BrowseRequest(this.newRequestHeader(session.getAuthenticationToken()), viewDescription, maxReferencesPerNode, (BrowseDescription[])ConversionUtil.a((List)nodesToBrowse, BrowseDescription.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<BrowseNextResponse> browseNext(boolean releaseContinuationPoints, List<ByteString> continuationPoints) {
        return this.getSession().thenCompose(session -> {
            BrowseNextRequest request = new BrowseNextRequest(this.newRequestHeader(session.getAuthenticationToken()), Boolean.valueOf(releaseContinuationPoints), (ByteString[])ConversionUtil.a((List)continuationPoints, ByteString.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<TranslateBrowsePathsToNodeIdsResponse> translateBrowsePaths(List<BrowsePath> browsePaths) {
        return this.getSession().thenCompose(session -> {
            TranslateBrowsePathsToNodeIdsRequest request = new TranslateBrowsePathsToNodeIdsRequest(this.newRequestHeader(session.getAuthenticationToken()), (BrowsePath[])ConversionUtil.a((List)browsePaths, BrowsePath.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<RegisterNodesResponse> registerNodes(List<NodeId> nodesToRegister) {
        return this.getSession().thenCompose(session -> {
            RegisterNodesRequest request = new RegisterNodesRequest(this.newRequestHeader(session.getAuthenticationToken()), (NodeId[])ConversionUtil.a((List)nodesToRegister, NodeId.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<UnregisterNodesResponse> unregisterNodes(List<NodeId> nodesToUnregister) {
        return this.getSession().thenCompose(session -> {
            UnregisterNodesRequest request = new UnregisterNodesRequest(this.newRequestHeader(session.getAuthenticationToken()), (NodeId[])ConversionUtil.a((List)nodesToUnregister, NodeId.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<CallResponse> call(List<CallMethodRequest> methodsToCall) {
        return this.getSession().thenCompose(session -> {
            CallRequest request = new CallRequest(this.newRequestHeader(session.getAuthenticationToken()), (CallMethodRequest[])ConversionUtil.a((List)methodsToCall, CallMethodRequest.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<CreateSubscriptionResponse> createSubscription(double requestedPublishingInterval, UInteger requestedLifetimeCount, UInteger requestedMaxKeepAliveCount, UInteger maxNotificationsPerPublish, boolean publishingEnabled, UByte priority) {
        return this.getSession().thenCompose(session -> {
            CreateSubscriptionRequest request = new CreateSubscriptionRequest(this.newRequestHeader(session.getAuthenticationToken()), Double.valueOf(requestedPublishingInterval), requestedLifetimeCount, requestedMaxKeepAliveCount, maxNotificationsPerPublish, Boolean.valueOf(publishingEnabled), priority);
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<ModifySubscriptionResponse> modifySubscription(UInteger subscriptionId, double requestedPublishingInterval, UInteger requestedLifetimeCount, UInteger requestedMaxKeepAliveCount, UInteger maxNotificationsPerPublish, UByte priority) {
        return this.getSession().thenCompose(session -> {
            ModifySubscriptionRequest request = new ModifySubscriptionRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, Double.valueOf(requestedPublishingInterval), requestedLifetimeCount, requestedMaxKeepAliveCount, maxNotificationsPerPublish, priority);
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<DeleteSubscriptionsResponse> deleteSubscriptions(List<UInteger> subscriptionIds) {
        return this.getSession().thenCompose(session -> {
            DeleteSubscriptionsRequest request = new DeleteSubscriptionsRequest(this.newRequestHeader(session.getAuthenticationToken()), (UInteger[])ConversionUtil.a((List)subscriptionIds, UInteger.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<TransferSubscriptionsResponse> transferSubscriptions(List<UInteger> subscriptionIds, boolean sendInitialValues) {
        return this.getSession().thenCompose(session -> {
            TransferSubscriptionsRequest request = new TransferSubscriptionsRequest(this.newRequestHeader(session.getAuthenticationToken()), (UInteger[])ConversionUtil.a((List)subscriptionIds, UInteger.class), Boolean.valueOf(sendInitialValues));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<SetPublishingModeResponse> setPublishingMode(boolean publishingEnabled, List<UInteger> subscriptionIds) {
        return this.getSession().thenCompose(session -> {
            SetPublishingModeRequest request = new SetPublishingModeRequest(this.newRequestHeader(session.getAuthenticationToken()), Boolean.valueOf(publishingEnabled), (UInteger[])ConversionUtil.a((List)subscriptionIds, UInteger.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<PublishResponse> publish(List<SubscriptionAcknowledgement> subscriptionAcknowledgements) {
        return this.getSession().thenCompose(session -> {
            PublishRequest request = new PublishRequest(this.newRequestHeader(session.getAuthenticationToken()), (SubscriptionAcknowledgement[])ConversionUtil.a((List)subscriptionAcknowledgements, SubscriptionAcknowledgement.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<RepublishResponse> republish(UInteger subscriptionId, UInteger retransmitSequenceNumber) {
        return this.getSession().thenCompose(session -> {
            RepublishRequest request = new RepublishRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, retransmitSequenceNumber);
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<CreateMonitoredItemsResponse> createMonitoredItems(UInteger subscriptionId, TimestampsToReturn timestampsToReturn, List<MonitoredItemCreateRequest> itemsToCreate) {
        return this.getSession().thenCompose(session -> {
            CreateMonitoredItemsRequest request = new CreateMonitoredItemsRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, timestampsToReturn, (MonitoredItemCreateRequest[])ConversionUtil.a((List)itemsToCreate, MonitoredItemCreateRequest.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<ModifyMonitoredItemsResponse> modifyMonitoredItems(UInteger subscriptionId, TimestampsToReturn timestampsToReturn, List<MonitoredItemModifyRequest> itemsToModify) {
        return this.getSession().thenCompose(session -> {
            ModifyMonitoredItemsRequest request = new ModifyMonitoredItemsRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, timestampsToReturn, (MonitoredItemModifyRequest[])ConversionUtil.a((List)itemsToModify, MonitoredItemModifyRequest.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<DeleteMonitoredItemsResponse> deleteMonitoredItems(UInteger subscriptionId, List<UInteger> monitoredItemIds) {
        return this.getSession().thenCompose(session -> {
            DeleteMonitoredItemsRequest request = new DeleteMonitoredItemsRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, (UInteger[])ConversionUtil.a((List)monitoredItemIds, UInteger.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<SetMonitoringModeResponse> setMonitoringMode(UInteger subscriptionId, MonitoringMode monitoringMode, List<UInteger> monitoredItemIds) {
        return this.getSession().thenCompose(session -> {
            SetMonitoringModeRequest request = new SetMonitoringModeRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, monitoringMode, (UInteger[])ConversionUtil.a((List)monitoredItemIds, UInteger.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<SetTriggeringResponse> setTriggering(UInteger subscriptionId, UInteger triggeringItemId, List<UInteger> linksToAdd, List<UInteger> linksToRemove) {
        return this.getSession().thenCompose(session -> {
            SetTriggeringRequest request = new SetTriggeringRequest(this.newRequestHeader(session.getAuthenticationToken()), subscriptionId, triggeringItemId, (UInteger[])ConversionUtil.a((List)linksToAdd, UInteger.class), (UInteger[])ConversionUtil.a((List)linksToRemove, UInteger.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<AddNodesResponse> addNodes(List<AddNodesItem> nodesToAdd) {
        return this.getSession().thenCompose(session -> {
            AddNodesRequest request = new AddNodesRequest(this.newRequestHeader(session.getAuthenticationToken()), (AddNodesItem[])ConversionUtil.a((List)nodesToAdd, AddNodesItem.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<AddReferencesResponse> addReferences(List<AddReferencesItem> referencesToAdd) {
        return this.getSession().thenCompose(session -> {
            AddReferencesRequest request = new AddReferencesRequest(this.newRequestHeader(session.getAuthenticationToken()), (AddReferencesItem[])ConversionUtil.a((List)referencesToAdd, AddReferencesItem.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<DeleteNodesResponse> deleteNodes(List<DeleteNodesItem> nodesToDelete) {
        return this.getSession().thenCompose(session -> {
            DeleteNodesRequest request = new DeleteNodesRequest(this.newRequestHeader(session.getAuthenticationToken()), (DeleteNodesItem[])ConversionUtil.a((List)nodesToDelete, DeleteNodesItem.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    @Override
    public CompletableFuture<DeleteReferencesResponse> deleteReferences(List<DeleteReferencesItem> referencesToDelete) {
        return this.getSession().thenCompose(session -> {
            DeleteReferencesRequest request = new DeleteReferencesRequest(this.newRequestHeader(session.getAuthenticationToken()), (DeleteReferencesItem[])ConversionUtil.a((List)referencesToDelete, DeleteReferencesItem.class));
            return this.sendRequest((UaRequestMessage)request);
        });
    }

    public CompletableFuture<OpcUaSession> getSession() {
        return this.sessionFsm.getSession();
    }

    @Override
    public <T extends UaResponseMessage> CompletableFuture<T> sendRequest(UaRequestMessage request) {
        CompletableFuture f = this.getStackClient().sendRequest(request);
        if (this.faultListeners.size() > 0) {
            f.whenComplete(this::maybeHandleServiceFault);
        }
        return f;
    }

    public void sendRequests(List<? extends UaRequestMessage> requests, List<CompletableFuture<? extends UaResponseMessage>> futures) {
        futures.forEach(f -> f.whenComplete(this::maybeHandleServiceFault));
        this.getStackClient().sendRequests(requests, futures);
    }

    private void maybeHandleServiceFault(UaResponseMessage response, Throwable ex) {
        if (this.faultListeners.isEmpty()) {
            return;
        }
        if (ex != null) {
            if (ex instanceof UaServiceFaultException) {
                UaServiceFaultException faultException = (UaServiceFaultException)ex;
                ServiceFault serviceFault = faultException.getServiceFault();
                this.logger.debug("Notifying {} ServiceFaultListeners", (Object)this.faultListeners.size());
                this.faultNotificationQueue.submit(() -> this.faultListeners.forEach(h -> h.onServiceFault(serviceFault)));
            } else if (ex.getCause() instanceof UaServiceFaultException) {
                UaServiceFaultException faultException = (UaServiceFaultException)ex.getCause();
                ServiceFault serviceFault = faultException.getServiceFault();
                this.logger.debug("Notifying {} ServiceFaultListeners", (Object)this.faultListeners.size());
                this.faultNotificationQueue.submit(() -> this.faultListeners.forEach(h -> h.onServiceFault(serviceFault)));
            }
        }
    }

    public void addFaultListener(ServiceFaultListener faultListener) {
        this.faultListeners.add(faultListener);
        this.logger.debug("Added ServiceFaultListener: {}", (Object)faultListener);
    }

    public void removeFaultListener(ServiceFaultListener faultListener) {
        this.faultListeners.remove(faultListener);
        this.logger.debug("Removed ServiceFaultListener: {}", (Object)faultListener);
    }

    public void addSessionActivityListener(SessionActivityListener listener) {
        this.sessionFsm.addListener(listener);
        this.logger.debug("Added SessionActivityListener: {}", (Object)listener);
    }

    public void removeSessionActivityListener(SessionActivityListener listener) {
        this.sessionFsm.removeListener(listener);
        this.logger.debug("Removed SessionActivityListener: {}", (Object)listener);
    }

    public void addSessionInitializer(SessionFsm.SessionInitializer initializer) {
        this.sessionFsm.addInitializer(initializer);
        this.logger.debug("Added SessionInitializer: {}", (Object)initializer);
    }

    public void removeSessionInitializer(SessionFsm.SessionInitializer initializer) {
        this.sessionFsm.removeInitializer(initializer);
        this.logger.debug("Removed SessionInitializer: {}", (Object)initializer);
    }

    static {
        Logger logger = LoggerFactory.getLogger(OpcUaClient.class);
        logger.info("Eclipse Milo OPC UA Stack version: {}", (Object)Stack.VERSION);
        logger.info("Eclipse Milo OPC UA Client SDK version: {}", (Object)SDK_VERSION);
    }
}

