/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.server.uasc;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.UaResponseMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.transport.server.ServerApplicationContext;
import org.eclipse.milo.opcua.stack.transport.server.uasc.UascServerConfig;
import org.eclipse.milo.opcua.stack.transport.server.uasc.UascServiceRequest;
import org.eclipse.milo.opcua.stack.transport.server.uasc.UascServiceResponse;

public class UascServiceRequestHandler
extends SimpleChannelInboundHandler<UascServiceRequest> {
    private final UascServerConfig config;
    private final ServerApplicationContext applicationContext;

    public UascServiceRequestHandler(UascServerConfig config, ServerApplicationContext applicationContext) {
        this.config = config;
        this.applicationContext = applicationContext;
    }

    protected void channelRead0(ChannelHandlerContext ctx, UascServiceRequest serviceRequest) {
        this.dispatchServiceRequest(serviceRequest);
    }

    private void dispatchServiceRequest(UascServiceRequest serviceRequest) {
        CompletableFuture<UaResponseMessageType> future = this.applicationContext.handleServiceRequest(serviceRequest, serviceRequest.getRequestMessage());
        future.whenComplete((response, ex) -> {
            if (response != null) {
                UascServiceResponse serviceResponse = new UascServiceResponse((UaResponseMessageType)response, serviceRequest.getRequestId());
                serviceRequest.getChannel().pipeline().writeAndFlush((Object)serviceResponse);
            } else {
                StatusCode serviceResult = UaException.extractStatusCode((Throwable)ex).orElse(new StatusCode(0x80010000L));
                ResponseHeader header = new ResponseHeader(DateTime.now(), serviceRequest.getRequestMessage().getRequestHeader().getRequestHandle(), serviceResult, DiagnosticInfo.NULL_VALUE, null, null);
                UascServiceResponse serviceResponse = new UascServiceResponse((UaResponseMessageType)new ServiceFault(header), serviceRequest.getRequestId());
                serviceRequest.getChannel().writeAndFlush((Object)serviceResponse);
            }
        });
    }
}

