/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.server.uasc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.ChunkDecoder;
import org.eclipse.milo.opcua.stack.core.channel.ChunkEncoder;
import org.eclipse.milo.opcua.stack.core.channel.MessageAbortException;
import org.eclipse.milo.opcua.stack.core.channel.MessageDecodeException;
import org.eclipse.milo.opcua.stack.core.channel.MessageEncodeException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageEncoder;
import org.eclipse.milo.opcua.stack.core.encoding.binary.OpcUaBinaryDecoder;
import org.eclipse.milo.opcua.stack.core.encoding.binary.OpcUaBinaryEncoder;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.types.UaMessageType;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.util.BufferUtil;
import org.eclipse.milo.opcua.stack.transport.server.ServerApplicationContext;
import org.eclipse.milo.opcua.stack.transport.server.uasc.UascServerConfig;
import org.eclipse.milo.opcua.stack.transport.server.uasc.UascServerHelloHandler;
import org.eclipse.milo.opcua.stack.transport.server.uasc.UascServiceRequest;
import org.eclipse.milo.opcua.stack.transport.server.uasc.UascServiceRequestHandler;
import org.eclipse.milo.opcua.stack.transport.server.uasc.UascServiceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UascServerSymmetricHandler
extends ByteToMessageCodec<UascServiceResponse>
implements HeaderDecoder {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final int maxChunkCount;
    private final int maxChunkSize;
    private List<ByteBuf> chunkBuffers;
    private final OpcUaBinaryEncoder binaryEncoder;
    private final OpcUaBinaryDecoder binaryDecoder;
    private final UascServerConfig config;
    private final ServerApplicationContext applicationContext;
    private final TransportProfile transportProfile;
    private final ChannelParameters channelParameters;
    private final ChunkEncoder chunkEncoder;
    private final ChunkDecoder chunkDecoder;
    private final ServerSecureChannel secureChannel;

    UascServerSymmetricHandler(UascServerConfig config, ServerApplicationContext applicationContext, TransportProfile transportProfile, ChannelParameters channelParameters, ChunkEncoder chunkEncoder, ChunkDecoder chunkDecoder, ServerSecureChannel secureChannel) {
        this.config = config;
        this.applicationContext = applicationContext;
        this.transportProfile = transportProfile;
        this.channelParameters = channelParameters;
        this.chunkEncoder = chunkEncoder;
        this.chunkDecoder = chunkDecoder;
        this.secureChannel = secureChannel;
        this.binaryEncoder = new OpcUaBinaryEncoder(applicationContext.getEncodingContext());
        this.binaryDecoder = new OpcUaBinaryDecoder(applicationContext.getEncodingContext());
        this.maxChunkCount = channelParameters.getLocalMaxChunkCount();
        this.maxChunkSize = channelParameters.getLocalReceiveBufferSize();
        this.chunkBuffers = new ArrayList<ByteBuf>(this.maxChunkCount);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addLast(new ChannelHandler[]{new UascServiceRequestHandler(this.config, this.applicationContext)});
        super.handlerAdded(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)evt;
            ByteBuf messageBuffer = TcpMessageEncoder.encode((ErrorMessage)errorMessage);
            ctx.writeAndFlush((Object)messageBuffer).addListener(future -> ctx.close());
        }
        super.userEventTriggered(ctx, evt);
    }

    protected void encode(ChannelHandlerContext ctx, UascServiceResponse response, ByteBuf buffer) throws Exception {
        this.sendServiceResponse(response, buffer);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.readableBytes() >= 8) {
            int messageLength = this.getMessageLength(buffer, this.maxChunkSize);
            if (buffer.readableBytes() >= messageLength) {
                MessageType messageType = MessageType.fromMediumInt((int)buffer.getMediumLE(buffer.readerIndex()));
                if (messageType == MessageType.SecureMessage) {
                    this.onSecureMessage(ctx, buffer.readSlice(messageLength), out);
                } else {
                    ctx.fireChannelRead((Object)buffer.readRetainedSlice(messageLength));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSecureMessage(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws UaException {
        buffer.skipBytes(3);
        char chunkType = (char)buffer.readByte();
        if (chunkType == 'A') {
            this.chunkBuffers.forEach(ReferenceCounted::release);
            this.chunkBuffers.clear();
        } else {
            buffer.skipBytes(4);
            long secureChannelId = buffer.readUnsignedIntLE();
            if (secureChannelId != this.secureChannel.getChannelId()) {
                throw new UaException(0x80220000L, "invalid secure channel id: " + secureChannelId);
            }
            int chunkSize = buffer.readerIndex(0).readableBytes();
            if (chunkSize > this.maxChunkSize) {
                throw new UaException(0x80800000L, String.format("max chunk size exceeded (%s)", this.maxChunkSize));
            }
            this.chunkBuffers.add(buffer.retain());
            if (this.maxChunkCount > 0 && this.chunkBuffers.size() > this.maxChunkCount) {
                throw new UaException(0x80800000L, String.format("max chunk count exceeded (%s)", this.maxChunkCount));
            }
            if (chunkType == 'F') {
                List<ByteBuf> buffersToDecode = this.chunkBuffers;
                this.chunkBuffers = new ArrayList<ByteBuf>();
                ByteBuf message = null;
                try {
                    ChunkDecoder.DecodedMessage decodedMessage = this.chunkDecoder.decodeSymmetric((SecureChannel)this.secureChannel, buffersToDecode);
                    message = decodedMessage.getMessage();
                    long requestId = decodedMessage.getRequestId();
                    this.binaryDecoder.setBuffer(message);
                    UaRequestMessageType requestMessage = (UaRequestMessageType)this.binaryDecoder.decodeMessage(null);
                    String endpointUrl = (String)ctx.channel().attr(UascServerHelloHandler.ENDPOINT_URL_KEY).get();
                    UascServiceRequest serviceRequest = new UascServiceRequest(endpointUrl, this.transportProfile, ctx.channel(), (SecureChannel)this.secureChannel, requestMessage, requestId);
                    out.add(serviceRequest);
                }
                catch (MessageAbortException e) {
                    this.logger.warn("Received message abort chunk; error={}, reason={}", (Object)e.getStatusCode(), (Object)e.getMessage());
                }
                catch (MessageDecodeException e) {
                    this.logger.error("Error decoding symmetric message", (Throwable)e);
                    ctx.close();
                }
                finally {
                    if (message != null) {
                        message.release();
                    }
                    buffersToDecode.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendServiceResponse(UascServiceResponse response, ByteBuf outBuffer) {
        ByteBuf messageBuffer = BufferUtil.pooledBuffer();
        CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
        try {
            this.binaryEncoder.setBuffer(messageBuffer);
            this.binaryEncoder.encodeMessage(null, (UaMessageType)response.getResponseMessage());
            this.checkMessageSize(messageBuffer);
            ChunkEncoder.EncodedMessage encodedMessage = this.chunkEncoder.encodeSymmetric((SecureChannel)this.secureChannel, response.getRequestId(), messageBuffer, MessageType.SecureMessage);
            for (ByteBuf chunk : encodedMessage.getMessageChunks()) {
                chunkComposite.addComponent(chunk);
                chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
            }
            outBuffer.writeBytes((ByteBuf)chunkComposite);
        }
        catch (MessageEncodeException e) {
            this.logger.error("Error encoding {}: {}", new Object[]{response, e.getMessage(), e});
            this.sendServiceFault(response, outBuffer, e);
        }
        catch (UaSerializationException e) {
            this.logger.error("Error serializing response: {}", (Object)e.getStatusCode(), (Object)e);
            this.sendServiceFault(response, outBuffer, e);
        }
        catch (Throwable t) {
            this.logger.error("Uncaught error sending service response", t);
            this.sendServiceFault(response, outBuffer, t);
        }
        finally {
            messageBuffer.release();
            chunkComposite.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendServiceFault(UascServiceResponse response, ByteBuf outBuffer, Throwable fault) {
        StatusCode statusCode = UaException.extract((Throwable)fault).map(UaException::getStatusCode).orElse(new StatusCode(0x80020000L));
        ServiceFault serviceFault = new ServiceFault(new ResponseHeader(DateTime.now(), response.getResponseMessage().getResponseHeader().getRequestHandle(), statusCode, null, null, null));
        ByteBuf messageBuffer = BufferUtil.pooledBuffer();
        CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
        try {
            this.binaryEncoder.setBuffer(messageBuffer);
            this.binaryEncoder.encodeMessage(null, (UaMessageType)serviceFault);
            this.checkMessageSize(messageBuffer);
            ChunkEncoder.EncodedMessage encodedMessage = this.chunkEncoder.encodeSymmetric((SecureChannel)this.secureChannel, response.getRequestId(), messageBuffer, MessageType.SecureMessage);
            for (ByteBuf chunk : encodedMessage.getMessageChunks()) {
                chunkComposite.addComponent(chunk);
                chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
            }
            outBuffer.writeBytes((ByteBuf)chunkComposite);
        }
        catch (MessageEncodeException e) {
            this.logger.error("Error encoding {}: {}", new Object[]{serviceFault, e.getMessage(), e});
        }
        catch (UaSerializationException e) {
            this.logger.error("Error serializing ServiceFault: {}", (Object)e.getStatusCode(), (Object)e);
        }
        finally {
            messageBuffer.release();
            chunkComposite.release();
        }
    }

    private void checkMessageSize(ByteBuf messageBuffer) throws UaSerializationException {
        int messageSize = messageBuffer.readableBytes();
        int remoteMaxMessageSize = this.channelParameters.getRemoteMaxMessageSize();
        if (remoteMaxMessageSize > 0 && messageSize > remoteMaxMessageSize) {
            throw new UaSerializationException(2159607808L, "response exceeds remote max message size: " + messageSize + " > " + remoteMaxMessageSize);
        }
    }
}

