/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.server.tcp;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.shaded.com.google.common.collect.ConcurrentHashMultiset;
import org.eclipse.milo.shaded.com.google.common.collect.Multiset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class RateLimitingHandler
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    public static final AtomicLong CUMULATIVE_CONNECTIONS_REJECTED = new AtomicLong(0L);
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ConcurrentMap<InetAddress, LinkedList<Long>> timestamps = new ConcurrentHashMap<InetAddress, LinkedList<Long>>();
    private final boolean enabled;
    private final int maxAttempts;
    private final int rateLimitWindowMs;
    private final int maxConnections;
    private final int maxConnectionsPerAddress;
    private final Multiset<InetAddress> connections = ConcurrentHashMultiset.create();

    public static RateLimitingHandler getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private RateLimitingHandler(boolean enabled, int maxAttempts, int rateLimitWindowMs, int maxConnections, int maxConnectionsPerAddress) {
        this.enabled = enabled;
        this.maxAttempts = maxAttempts;
        this.rateLimitWindowMs = rateLimitWindowMs;
        this.maxConnections = maxConnections;
        this.maxConnectionsPerAddress = maxConnectionsPerAddress;
        this.logger.debug("enabled={}, maxAttempts={}, rateLimitWindowMs={}, maxConnections={}, maxConnectionsPerAddress={}", new Object[]{enabled, maxAttempts, rateLimitWindowMs, maxConnections, maxConnectionsPerAddress});
    }

    protected synchronized boolean accept(ChannelHandlerContext ctx, InetSocketAddress isa) {
        InetAddress address = isa.getAddress();
        if (!this.enabled || address.isLoopbackAddress()) {
            return true;
        }
        LinkedList attempts = this.timestamps.computeIfAbsent(address, ia -> new LinkedList());
        long now = System.currentTimeMillis();
        if (attempts.size() >= this.maxAttempts) {
            boolean accept;
            int attemptsInWindow = 0;
            for (Long ts : attempts) {
                if (now - ts >= (long)this.rateLimitWindowMs) continue;
                ++attemptsInWindow;
            }
            attempts.addLast(now);
            while (attempts.size() > this.maxAttempts) {
                attempts.removeFirst();
            }
            int connectionsTotal = this.connections.size();
            int connectionsFromAddress = this.connections.count((Object)address);
            boolean bl = accept = attemptsInWindow < this.maxAttempts && connectionsTotal < this.maxConnections && connectionsFromAddress < this.maxConnectionsPerAddress;
            if (accept) {
                this.logger.debug("Accepting connection from {}. window={}ms, attemptsInWindow={}, connectionsTotal={}, connectionsFromAddress={}", new Object[]{isa, this.rateLimitWindowMs, attemptsInWindow, connectionsTotal, connectionsFromAddress});
            } else {
                this.logger.debug("Rejecting connection from {}. window={}ms, attemptsInWindow={}, connectionsTotal={}, connectionsFromAddress={}", new Object[]{isa, this.rateLimitWindowMs, attemptsInWindow, connectionsTotal, connectionsFromAddress});
                long cumulativeConnectionsRejected = CUMULATIVE_CONNECTIONS_REJECTED.incrementAndGet();
                this.logger.debug("cumulativeConnectionsRejected={}", (Object)cumulativeConnectionsRejected);
            }
            return accept;
        }
        attempts.addLast(now);
        return true;
    }

    protected void channelAccepted(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) {
        InetAddress address = remoteAddress.getAddress();
        if (!this.enabled || address.isLoopbackAddress()) {
            return;
        }
        this.connections.add((Object)address);
        ctx.channel().closeFuture().addListener((GenericFutureListener)new ChannelCloseListener(address, ctx));
    }

    private static class InstanceHolder {
        private static final RateLimitingHandler INSTANCE = new RateLimitingHandler(Stack.ConnectionLimits.RATE_LIMIT_ENABLED, Stack.ConnectionLimits.RATE_LIMIT_MAX_ATTEMPTS, Stack.ConnectionLimits.RATE_LIMIT_WINDOW_MS, Stack.ConnectionLimits.RATE_LIMIT_MAX_CONNECTIONS, Stack.ConnectionLimits.RATE_LIMIT_MAX_CONNECTIONS_PER_ADDRESS);

        private InstanceHolder() {
        }
    }

    private class ChannelCloseListener
    implements ChannelFutureListener {
        private final InetAddress address;
        private final ChannelHandlerContext ctx;

        private ChannelCloseListener(InetAddress address, ChannelHandlerContext ctx) {
            this.address = address;
            this.ctx = ctx;
        }

        public void operationComplete(ChannelFuture channelFuture) {
            RateLimitingHandler.this.connections.remove((Object)this.address);
            if (RateLimitingHandler.this.connections.count((Object)this.address) == 0) {
                RateLimitingHandler.this.logger.debug("Scheduling timestamp removal for {}", (Object)this.address);
                this.ctx.executor().schedule(() -> {
                    if (RateLimitingHandler.this.connections.count((Object)this.address) == 0) {
                        RateLimitingHandler.this.timestamps.remove(this.address);
                        RateLimitingHandler.this.logger.debug("Removed timestamps for {}", (Object)this.address);
                    }
                }, (long)RateLimitingHandler.this.rateLimitWindowMs, TimeUnit.MILLISECONDS);
            }
        }
    }
}

