/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.server.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.transport.server.tcp.OpcTcpServerTransportConfig;

public class OpcTcpServerTransportConfigBuilder {
    private ExecutorService executor;
    private EventLoopGroup eventLoop;
    private UInteger helloDeadline = Unsigned.uint((int)10000);
    private UInteger minimumSecureChannelLifetime = Unsigned.uint((int)60000);
    private UInteger maximumSecureChannelLifetime = Unsigned.uint((int)86400000);
    private Consumer<ServerBootstrap> bootstrapCustomizer = b -> {};
    private Consumer<ChannelPipeline> channelPipelineCustomizer = p -> {};

    public OpcTcpServerTransportConfigBuilder setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public OpcTcpServerTransportConfigBuilder setEventLoop(EventLoopGroup eventLoop) {
        this.eventLoop = eventLoop;
        return this;
    }

    public OpcTcpServerTransportConfigBuilder setBootstrapCustomizer(Consumer<ServerBootstrap> bootstrapCustomizer) {
        this.bootstrapCustomizer = bootstrapCustomizer;
        return this;
    }

    public OpcTcpServerTransportConfigBuilder setChannelPipelineCustomizer(Consumer<ChannelPipeline> channelPipelineCustomizer) {
        this.channelPipelineCustomizer = channelPipelineCustomizer;
        return this;
    }

    public OpcTcpServerTransportConfigBuilder setHelloDeadline(UInteger helloDeadline) {
        this.helloDeadline = helloDeadline;
        return this;
    }

    public OpcTcpServerTransportConfigBuilder setMinimumSecureChannelLifetime(UInteger minimumSecureChannelLifetime) {
        this.minimumSecureChannelLifetime = minimumSecureChannelLifetime;
        return this;
    }

    public OpcTcpServerTransportConfigBuilder setMaximumSecureChannelLifetime(UInteger maximumSecureChannelLifetime) {
        this.maximumSecureChannelLifetime = maximumSecureChannelLifetime;
        return this;
    }

    public OpcTcpServerTransportConfig build() {
        if (this.executor == null) {
            this.executor = Stack.sharedExecutor();
        }
        if (this.eventLoop == null) {
            this.eventLoop = Stack.sharedEventLoop();
        }
        return new OpcTcpServerTransportConfigImpl(this.executor, this.eventLoop, this.bootstrapCustomizer, this.channelPipelineCustomizer, this.helloDeadline, this.minimumSecureChannelLifetime, this.maximumSecureChannelLifetime);
    }

    static class OpcTcpServerTransportConfigImpl
    implements OpcTcpServerTransportConfig {
        private final ExecutorService executor;
        private final EventLoopGroup eventLoop;
        private final UInteger helloDeadline;
        private final UInteger minimumSecureChannelLifetime;
        private final UInteger maximumSecureChannelLifetime;
        private final Consumer<ServerBootstrap> bootstrapCustomizer;
        private final Consumer<ChannelPipeline> channelPipelineCustomizer;

        public OpcTcpServerTransportConfigImpl(ExecutorService executor, EventLoopGroup eventLoop, Consumer<ServerBootstrap> bootstrapCustomizer, Consumer<ChannelPipeline> channelPipelineCustomizer, UInteger helloDeadline, UInteger minimumSecureChannelLifetime, UInteger maximumSecureChannelLifetime) {
            this.executor = executor;
            this.eventLoop = eventLoop;
            this.bootstrapCustomizer = bootstrapCustomizer;
            this.channelPipelineCustomizer = channelPipelineCustomizer;
            this.helloDeadline = helloDeadline;
            this.minimumSecureChannelLifetime = minimumSecureChannelLifetime;
            this.maximumSecureChannelLifetime = maximumSecureChannelLifetime;
        }

        @Override
        public ExecutorService getExecutor() {
            return this.executor;
        }

        @Override
        public EventLoopGroup getEventLoop() {
            return this.eventLoop;
        }

        @Override
        public Consumer<ServerBootstrap> getBootstrapCustomizer() {
            return this.bootstrapCustomizer;
        }

        @Override
        public Consumer<ChannelPipeline> getChannelPipelineCustomizer() {
            return this.channelPipelineCustomizer;
        }

        @Override
        public UInteger getHelloDeadline() {
            return this.helloDeadline;
        }

        @Override
        public UInteger getMinimumSecureChannelLifetime() {
            return this.minimumSecureChannelLifetime;
        }

        @Override
        public UInteger getMaximumSecureChannelLifetime() {
            return this.maximumSecureChannelLifetime;
        }
    }
}

