/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.client.uasc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.UaServiceFaultException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.channel.ChunkDecoder;
import org.eclipse.milo.opcua.stack.core.channel.ChunkEncoder;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.channel.MessageAbortException;
import org.eclipse.milo.opcua.stack.core.channel.MessageDecodeException;
import org.eclipse.milo.opcua.stack.core.channel.MessageEncodeException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.headers.AsymmetricSecurityHeader;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageDecoder;
import org.eclipse.milo.opcua.stack.core.encoding.binary.OpcUaBinaryDecoder;
import org.eclipse.milo.opcua.stack.core.encoding.binary.OpcUaBinaryEncoder;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.UaMessageType;
import org.eclipse.milo.opcua.stack.core.types.UaRequestMessageType;
import org.eclipse.milo.opcua.stack.core.types.UaResponseMessageType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.SecurityTokenRequestType;
import org.eclipse.milo.opcua.stack.core.types.structured.ChannelSecurityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.OpenSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.OpenSecureChannelResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.util.BufferUtil;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.transport.client.ClientApplicationContext;
import org.eclipse.milo.opcua.stack.transport.client.uasc.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.transport.client.uasc.UascClientAcknowledgeHandler;
import org.eclipse.milo.opcua.stack.transport.client.uasc.UascClientConfig;
import org.eclipse.milo.opcua.stack.transport.client.uasc.UascRequest;
import org.eclipse.milo.opcua.stack.transport.client.uasc.UascResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UascClientMessageHandler
extends ByteToMessageCodec<UascRequest> {
    private static final long PROTOCOL_VERSION = 0L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicReference<AsymmetricSecurityHeader> headerRef = new AtomicReference();
    private List<ByteBuf> chunkBuffers = new ArrayList<ByteBuf>();
    private ScheduledFuture<?> renewFuture;
    private Timeout secureChannelTimeout;
    private ClientSecureChannel secureChannel;
    private final OpcUaBinaryDecoder binaryDecoder;
    private final OpcUaBinaryEncoder binaryEncoder;
    private final ChunkDecoder chunkDecoder;
    private final ChunkEncoder chunkEncoder;
    private final UascClientConfig config;
    private final ClientApplicationContext application;
    private final Supplier<Long> requestIdSupplier;
    private final CompletableFuture<ClientSecureChannel> handshakeFuture;
    private final ChannelParameters channelParameters;

    public UascClientMessageHandler(UascClientConfig config, ClientApplicationContext application, Supplier<Long> requestIdSupplier, CompletableFuture<ClientSecureChannel> handshakeFuture, List<UaRequestMessageType> awaitingHandshake, ChannelParameters channelParameters) {
        this.config = config;
        this.application = application;
        this.requestIdSupplier = requestIdSupplier;
        this.handshakeFuture = handshakeFuture;
        this.channelParameters = channelParameters;
        this.binaryDecoder = new OpcUaBinaryDecoder(application.getEncodingContext());
        this.binaryEncoder = new OpcUaBinaryEncoder(application.getEncodingContext());
        this.chunkDecoder = new ChunkDecoder(channelParameters, application.getEncodingContext().getEncodingLimits());
        this.chunkEncoder = new ChunkEncoder(channelParameters);
        handshakeFuture.thenAccept(sc -> {
            Channel channel = sc.getChannel();
            channel.eventLoop().execute(() -> {
                this.logger.debug("{} message(s) queued before handshake completed; sending now.", (Object)awaitingHandshake.size());
                awaitingHandshake.forEach(arg_0 -> ((Channel)channel).writeAndFlush(arg_0));
                awaitingHandshake.clear();
            });
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.renewFuture != null) {
            this.renewFuture.cancel(false);
        }
        UaException exception = new UaException(2158886912L, "connection closed");
        this.handshakeFuture.completeExceptionally(exception);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.error("[remote={}] Exception caught: {}", new Object[]{ctx.channel().remoteAddress(), cause.getMessage(), cause});
        this.chunkBuffers.forEach(ReferenceCountUtil::safeRelease);
        this.chunkBuffers.clear();
        this.handshakeFuture.completeExceptionally(cause);
        ctx.close();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.secureChannel = UascClientMessageHandler.newSecureChannel(this.application);
        this.secureChannel.setChannel(ctx.channel());
        SecurityTokenRequestType requestType = this.secureChannel.getChannelId() == 0L ? SecurityTokenRequestType.Issue : SecurityTokenRequestType.Renew;
        this.secureChannelTimeout = this.config.getWheelTimer().newTimeout(timeout -> {
            if (!timeout.isCancelled()) {
                this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for secure channel"));
                ctx.close();
            }
        }, this.application.getRequestTimeout().longValue(), TimeUnit.MILLISECONDS);
        this.logger.debug("OpenSecureChannel timeout scheduled for +{}ms", (Object)this.application.getRequestTimeout());
        this.sendOpenSecureChannelRequest(ctx, requestType);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof CloseSecureChannelRequest) {
            this.sendCloseSecureChannelRequest(ctx, (CloseSecureChannelRequest)evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, UascRequest request, ByteBuf buffer) throws Exception {
        ByteBuf messageBuffer = BufferUtil.pooledBuffer();
        try {
            this.binaryEncoder.setBuffer(messageBuffer);
            this.binaryEncoder.encodeMessage(null, (UaMessageType)request.getRequestMessage());
            this.checkMessageSize(messageBuffer);
            ChunkEncoder.EncodedMessage encodedMessage = this.chunkEncoder.encodeSymmetric((SecureChannel)this.secureChannel, request.getRequestId(), messageBuffer, MessageType.SecureMessage);
            List messageChunks = encodedMessage.getMessageChunks();
            CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
            for (ByteBuf chunk : messageChunks) {
                chunkComposite.addComponent(chunk);
                chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
            }
            ctx.writeAndFlush((Object)chunkComposite, ctx.voidPromise());
        }
        catch (MessageEncodeException e) {
            this.logger.error("Error encoding {}: {}", new Object[]{request, e.getMessage(), e});
            UascResponse response = UascResponse.failure(request.getRequestId(), new UaException((Throwable)e));
            ctx.fireUserEventTriggered((Object)response);
            ctx.close();
        }
        catch (UaSerializationException e) {
            this.logger.error("Error serializing {}: {}", new Object[]{request, e.getMessage(), e});
            UascResponse response = UascResponse.failure(request.getRequestId(), new UaException((Throwable)e));
            ctx.fireUserEventTriggered((Object)response);
        }
        finally {
            messageBuffer.release();
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.readableBytes() >= 8) {
            int messageLength = UascClientMessageHandler.getMessageLength(buffer, this.channelParameters.getLocalReceiveBufferSize());
            if (buffer.readableBytes() >= messageLength) {
                MessageType messageType = MessageType.fromMediumInt((int)buffer.getMediumLE(buffer.readerIndex()));
                switch (messageType) {
                    case OpenSecureChannel: {
                        this.onOpenSecureChannel(ctx, buffer.readSlice(messageLength));
                        break;
                    }
                    case SecureMessage: {
                        this.onSecureMessage(ctx, buffer.readSlice(messageLength), out);
                        break;
                    }
                    case Error: {
                        this.onError(ctx, buffer.readSlice(messageLength));
                        break;
                    }
                    default: {
                        throw new UaException(2155741184L, "unexpected MessageType: " + String.valueOf(messageType));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSecureMessage(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws UaException {
        buffer.skipBytes(8);
        long secureChannelId = buffer.readUnsignedIntLE();
        if (secureChannelId != this.secureChannel.getChannelId()) {
            throw new UaException(0x80220000L, "invalid secure channel id: " + secureChannelId);
        }
        if (this.accumulateChunk(buffer)) {
            List<ByteBuf> buffersToDecode = this.chunkBuffers;
            this.chunkBuffers = new ArrayList<ByteBuf>(this.getMaxChunkCount());
            ByteBuf messageBuffer = null;
            try {
                ChunkDecoder.DecodedMessage decodedMessage = this.chunkDecoder.decodeSymmetric((SecureChannel)this.secureChannel, buffersToDecode);
                messageBuffer = decodedMessage.getMessage();
                this.binaryDecoder.setBuffer(messageBuffer);
                UaMessageType message = this.binaryDecoder.decodeMessage(null);
                if (message instanceof ServiceFault) {
                    ServiceFault serviceFault = (ServiceFault)message;
                    UascResponse response = UascResponse.failure(decodedMessage.getRequestId(), (UaException)new UaServiceFaultException(serviceFault));
                    out.add(response);
                } else if (message instanceof UaResponseMessageType) {
                    UascResponse response = UascResponse.success(decodedMessage.getRequestId(), (UaResponseMessageType)message);
                    out.add(response);
                } else {
                    UascResponse response = UascResponse.failure(decodedMessage.getRequestId(), new UaException(0x80090000L, message.getClass().getSimpleName()));
                    out.add(response);
                }
            }
            catch (MessageAbortException e) {
                this.logger.warn("Received message abort chunk; error={}, reason={}", (Object)e.getStatusCode(), (Object)e.getMessage());
                out.add(UascResponse.failure(e.getRequestId(), new UaException(e.getStatusCode(), e.getMessage())));
            }
            catch (MessageDecodeException e) {
                this.logger.error("Error decoding symmetric message", (Throwable)e);
                ctx.close();
            }
            finally {
                if (messageBuffer != null) {
                    messageBuffer.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOpenSecureChannel(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        if (this.secureChannelTimeout != null) {
            if (this.secureChannelTimeout.cancel()) {
                this.logger.debug("OpenSecureChannel timeout canceled");
                this.secureChannelTimeout = null;
            } else {
                this.logger.warn("timed out waiting for secure channel");
                this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for secure channel"));
                ctx.close();
                return;
            }
        }
        buffer.skipBytes(12);
        AsymmetricSecurityHeader securityHeader = AsymmetricSecurityHeader.decode((ByteBuf)buffer, (EncodingLimits)this.application.getEncodingContext().getEncodingLimits());
        if (this.headerRef.compareAndSet(null, securityHeader)) {
            CertificateValidator certificateValidator = this.application.getCertificateValidator();
            SecurityPolicy securityPolicy = SecurityPolicy.fromUri((String)securityHeader.getSecurityPolicyUri());
            if (securityPolicy != SecurityPolicy.None) {
                ByteString serverCertificateBytes = securityHeader.getSenderCertificate();
                List serverCertificateChain = CertificateUtil.decodeCertificates((byte[])serverCertificateBytes.bytesOrEmpty());
                certificateValidator.validateCertificateChain(serverCertificateChain, null, null);
            }
        } else if (!securityHeader.equals((Object)this.headerRef.get())) {
            throw new UaException(2148728832L, "subsequent AsymmetricSecurityHeader did not match");
        }
        if (this.accumulateChunk(buffer)) {
            List<ByteBuf> buffersToDecode = this.chunkBuffers;
            this.chunkBuffers = new ArrayList<ByteBuf>(this.getMaxChunkCount());
            ByteBuf messageBuffer = null;
            try {
                ChunkDecoder.DecodedMessage decodedMessage = this.chunkDecoder.decodeAsymmetric((SecureChannel)this.secureChannel, buffersToDecode);
                messageBuffer = decodedMessage.getMessage();
                this.binaryDecoder.setBuffer(messageBuffer);
                UaResponseMessageType responseMessage = (UaResponseMessageType)this.binaryDecoder.decodeMessage(null);
                StatusCode serviceResult = responseMessage.getResponseHeader().getServiceResult();
                if (serviceResult.isGood()) {
                    OpenSecureChannelResponse response = (OpenSecureChannelResponse)responseMessage;
                    this.logger.debug("Received OpenSecureChannelResponse.");
                    this.secureChannel.setChannelId(response.getSecurityToken().getChannelId().longValue());
                    this.installSecurityToken(ctx, response);
                    this.handshakeFuture.complete(this.secureChannel);
                } else {
                    ServiceFault serviceFault = responseMessage instanceof ServiceFault ? (ServiceFault)responseMessage : new ServiceFault(responseMessage.getResponseHeader());
                    this.handshakeFuture.completeExceptionally((Throwable)new UaServiceFaultException(serviceFault));
                    ctx.close();
                }
            }
            catch (MessageAbortException e) {
                this.logger.warn("Received message abort chunk; error={}, reason={}", (Object)e.getStatusCode(), (Object)e.getMessage());
            }
            catch (MessageDecodeException e) {
                this.logger.error("Error decoding asymmetric message", (Throwable)e);
                this.handshakeFuture.completeExceptionally(e);
                ctx.close();
            }
            catch (Exception e) {
                this.logger.error("Error decoding OpenSecureChannelResponse", (Throwable)e);
                this.handshakeFuture.completeExceptionally(e);
                ctx.close();
            }
            finally {
                if (messageBuffer != null) {
                    messageBuffer.release();
                }
            }
        }
    }

    private void installSecurityToken(ChannelHandlerContext ctx, OpenSecureChannelResponse response) throws UaException {
        ChannelSecurity oldSecrets;
        if (response.getServerProtocolVersion().longValue() < 0L) {
            throw new UaException(2159935488L, "server protocol version unsupported: " + String.valueOf(response.getServerProtocolVersion()));
        }
        ChannelSecurity.SecurityKeys newKeys = null;
        ChannelSecurityToken newToken = response.getSecurityToken();
        if (this.secureChannel.isSymmetricSigningEnabled()) {
            ByteString serverNonce = response.getServerNonce();
            NonceUtil.validateNonce((ByteString)serverNonce, (SecurityPolicy)this.secureChannel.getSecurityPolicy());
            this.secureChannel.setRemoteNonce(serverNonce);
            newKeys = ChannelSecurity.generateKeyPair((SecureChannel)this.secureChannel, (ByteString)this.secureChannel.getLocalNonce(), (ByteString)this.secureChannel.getRemoteNonce());
        }
        ChannelSecurity.SecurityKeys oldKeys = (oldSecrets = this.secureChannel.getChannelSecurity()) != null ? oldSecrets.getCurrentKeys() : null;
        ChannelSecurityToken oldToken = oldSecrets != null ? oldSecrets.getCurrentToken() : null;
        this.secureChannel.setChannelSecurity(new ChannelSecurity(newKeys, newToken, oldKeys, oldToken));
        DateTime createdAt = response.getSecurityToken().getCreatedAt();
        long revisedLifetime = response.getSecurityToken().getRevisedLifetime().longValue();
        if (revisedLifetime > 0L) {
            long renewAt = (long)((double)revisedLifetime * 0.75);
            this.renewFuture = ctx.executor().schedule(() -> this.sendOpenSecureChannelRequest(ctx, SecurityTokenRequestType.Renew), renewAt, TimeUnit.MILLISECONDS);
        } else {
            this.logger.warn("Server revised secure channel lifetime to 0; renewal will not occur.");
        }
        ctx.executor().execute(() -> {
            if (ctx.pipeline().get(UascClientAcknowledgeHandler.class) != null) {
                ctx.pipeline().remove(UascClientAcknowledgeHandler.class);
            }
        });
        ChannelSecurity channelSecurity = this.secureChannel.getChannelSecurity();
        long currentTokenId = channelSecurity.getCurrentToken().getTokenId().longValue();
        long previousTokenId = channelSecurity.getPreviousToken().map(t -> t.getTokenId().longValue()).orElse(-1L);
        this.logger.debug("SecureChannel id={}, currentTokenId={}, previousTokenId={}, lifetime={}ms, createdAt={}", new Object[]{this.secureChannel.getChannelId(), currentTokenId, previousTokenId, revisedLifetime, createdAt});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            ErrorMessage errorMessage = TcpMessageDecoder.decodeError((ByteBuf)buffer);
            StatusCode statusCode = errorMessage.getError();
            this.logger.error("[remote={}] errorMessage={}", (Object)ctx.channel().remoteAddress(), (Object)errorMessage);
            this.handshakeFuture.completeExceptionally(new UaException(statusCode, errorMessage.getReason()));
            ctx.fireUserEventTriggered((Object)errorMessage);
        }
        catch (UaException e) {
            this.logger.error("[remote={}] An exception occurred while decoding an error message: {}", new Object[]{ctx.channel().remoteAddress(), e.getMessage(), e});
            this.handshakeFuture.completeExceptionally(e);
        }
        finally {
            ctx.close();
        }
    }

    private boolean accumulateChunk(ByteBuf buffer) throws UaException {
        int maxChunkCount = this.getMaxChunkCount();
        int maxChunkSize = this.getMaxChunkSize();
        int chunkSize = buffer.readerIndex(0).readableBytes();
        if (chunkSize > maxChunkSize) {
            throw new UaException(0x80800000L, String.format("max chunk size exceeded (%s)", maxChunkSize));
        }
        this.chunkBuffers.add(buffer.retain());
        if (maxChunkCount > 0 && this.chunkBuffers.size() > maxChunkCount) {
            throw new UaException(0x80800000L, String.format("max chunk count exceeded (%s)", maxChunkCount));
        }
        char chunkType = (char)buffer.getByte(3);
        return chunkType == 'A' || chunkType == 'F';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOpenSecureChannelRequest(ChannelHandlerContext ctx, SecurityTokenRequestType requestType) {
        ByteString clientNonce = this.secureChannel.isSymmetricSigningEnabled() ? NonceUtil.generateNonce((SecurityPolicy)this.secureChannel.getSecurityPolicy()) : ByteString.NULL_VALUE;
        this.secureChannel.setLocalNonce(clientNonce);
        RequestHeader header = new RequestHeader(null, DateTime.now(), Unsigned.uint((int)0), Unsigned.uint((int)0), null, this.application.getRequestTimeout(), null);
        OpenSecureChannelRequest request = new OpenSecureChannelRequest(header, Unsigned.uint((long)0L), requestType, this.secureChannel.getMessageSecurityMode(), this.secureChannel.getLocalNonce(), this.config.getChannelLifetime());
        ByteBuf messageBuffer = BufferUtil.pooledBuffer();
        try {
            this.binaryEncoder.setBuffer(messageBuffer);
            this.binaryEncoder.encodeMessage(null, (UaMessageType)request);
            this.checkMessageSize(messageBuffer);
            ChunkEncoder.EncodedMessage encodedMessage = this.chunkEncoder.encodeAsymmetric((SecureChannel)this.secureChannel, this.requestIdSupplier.get().longValue(), messageBuffer, MessageType.OpenSecureChannel);
            CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
            for (ByteBuf chunk : encodedMessage.getMessageChunks()) {
                chunkComposite.addComponent(chunk);
                chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
            }
            ctx.writeAndFlush((Object)chunkComposite, ctx.voidPromise());
            ChannelSecurity channelSecurity = this.secureChannel.getChannelSecurity();
            long currentTokenId = -1L;
            if (channelSecurity != null) {
                currentTokenId = channelSecurity.getCurrentToken().getTokenId().longValue();
            }
            long previousTokenId = -1L;
            if (channelSecurity != null) {
                previousTokenId = channelSecurity.getPreviousToken().map(token -> token.getTokenId().longValue()).orElse(-1L);
            }
            this.logger.debug("Sent OpenSecureChannelRequest ({}, id={}, currentToken={}, previousToken={}).", new Object[]{request.getRequestType(), this.secureChannel.getChannelId(), currentTokenId, previousTokenId});
        }
        catch (MessageEncodeException e) {
            this.logger.error("Error encoding {}: {}", new Object[]{request, e.getMessage(), e});
            ctx.close();
        }
        finally {
            messageBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCloseSecureChannelRequest(ChannelHandlerContext ctx, CloseSecureChannelRequest request) {
        ByteBuf messageBuffer = BufferUtil.pooledBuffer();
        try {
            this.binaryEncoder.setBuffer(messageBuffer);
            this.binaryEncoder.encodeMessage(null, (UaMessageType)request);
            this.checkMessageSize(messageBuffer);
            ChunkEncoder.EncodedMessage encodedMessage = this.chunkEncoder.encodeSymmetric((SecureChannel)this.secureChannel, this.requestIdSupplier.get().longValue(), messageBuffer, MessageType.CloseSecureChannel);
            CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
            for (ByteBuf chunk : encodedMessage.getMessageChunks()) {
                chunkComposite.addComponent(chunk);
                chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
            }
            ctx.writeAndFlush((Object)chunkComposite).addListener(future -> ctx.close());
            this.secureChannel.setChannelId(0L);
        }
        catch (MessageEncodeException e) {
            this.logger.error("Error encoding {}: {}", new Object[]{request, e.getMessage(), e});
            this.handshakeFuture.completeExceptionally(e);
            ctx.close();
        }
        catch (UaSerializationException e) {
            this.logger.error("Error serializing {}: {}", new Object[]{request, e.getMessage(), e});
            this.handshakeFuture.completeExceptionally(e);
            ctx.close();
        }
        finally {
            messageBuffer.release();
        }
    }

    private void checkMessageSize(ByteBuf messageBuffer) throws UaSerializationException {
        int messageSize = messageBuffer.readableBytes();
        int remoteMaxMessageSize = this.channelParameters.getRemoteMaxMessageSize();
        if (remoteMaxMessageSize > 0 && messageSize > remoteMaxMessageSize) {
            throw new UaSerializationException(0x80B80000L, "request exceeds remote max message size: " + messageSize + " > " + remoteMaxMessageSize);
        }
    }

    private int getMaxChunkCount() {
        return this.channelParameters.getLocalMaxChunkCount();
    }

    private int getMaxChunkSize() {
        return this.channelParameters.getLocalReceiveBufferSize();
    }

    private static ClientSecureChannel newSecureChannel(ClientApplicationContext application) throws UaException {
        EndpointDescription endpoint = application.getEndpoint();
        SecurityPolicy securityPolicy = SecurityPolicy.fromUri((String)endpoint.getSecurityPolicyUri());
        if (securityPolicy == SecurityPolicy.None) {
            return new ClientSecureChannel(securityPolicy, endpoint.getSecurityMode());
        }
        KeyPair keyPair = application.getKeyPair().orElseThrow(() -> new UaException(0x80890000L, "no KeyPair configured"));
        X509Certificate certificate = application.getCertificate().orElseThrow(() -> new UaException(0x80890000L, "no certificate configured"));
        List<X509Certificate> certificateChain = Arrays.asList(application.getCertificateChain().orElseThrow(() -> new UaException(0x80890000L, "no certificate chain configured")));
        X509Certificate remoteCertificate = CertificateUtil.decodeCertificate((byte[])endpoint.getServerCertificate().bytes());
        List remoteCertificateChain = CertificateUtil.decodeCertificates((byte[])endpoint.getServerCertificate().bytes());
        return new ClientSecureChannel(keyPair, certificate, certificateChain, remoteCertificate, remoteCertificateChain, securityPolicy, endpoint.getSecurityMode());
    }

    private static int getMessageLength(ByteBuf buffer, int maxMessageLength) throws UaException {
        long messageLength = buffer.getUnsignedIntLE(buffer.readerIndex() + 4);
        if (messageLength <= (long)maxMessageLength) {
            return (int)messageLength;
        }
        throw new UaException(0x80800000L, String.format("max message length exceeded (%s > %s)", messageLength, maxMessageLength));
    }
}

