/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.client.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.transport.client.tcp.OpcTcpClientTransportConfig;

public class OpcTcpClientTransportConfigBuilder {
    private UInteger connectTimeout = Unsigned.uint((int)5000);
    private UInteger acknowledgeTimeout = Unsigned.uint((int)5000);
    private UInteger channelLifetime = Unsigned.uint((int)3600000);
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private EventLoopGroup eventLoop;
    private HashedWheelTimer wheelTimer;
    private Consumer<Bootstrap> bootstrapCustomizer = b -> {};
    private Consumer<ChannelPipeline> channelPipelineCustomizer = p -> {};

    public OpcTcpClientTransportConfigBuilder setConnectTimeout(UInteger connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public OpcTcpClientTransportConfigBuilder setAcknowledgeTimeout(UInteger acknowledgeTimeout) {
        this.acknowledgeTimeout = acknowledgeTimeout;
        return this;
    }

    public OpcTcpClientTransportConfigBuilder setChannelLifetime(UInteger channelLifetime) {
        this.channelLifetime = channelLifetime;
        return this;
    }

    public OpcTcpClientTransportConfigBuilder setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public OpcTcpClientTransportConfigBuilder setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
        return this;
    }

    public OpcTcpClientTransportConfigBuilder setEventLoop(EventLoopGroup eventLoop) {
        this.eventLoop = eventLoop;
        return this;
    }

    public OpcTcpClientTransportConfigBuilder setWheelTimer(HashedWheelTimer wheelTimer) {
        this.wheelTimer = wheelTimer;
        return this;
    }

    public OpcTcpClientTransportConfigBuilder setBootstrapCustomizer(Consumer<Bootstrap> bootstrapCustomizer) {
        this.bootstrapCustomizer = bootstrapCustomizer;
        return this;
    }

    public OpcTcpClientTransportConfigBuilder setChannelPipelineCustomizer(Consumer<ChannelPipeline> channelPipelineCustomizer) {
        this.channelPipelineCustomizer = channelPipelineCustomizer;
        return this;
    }

    public OpcTcpClientTransportConfig build() {
        if (this.executor == null) {
            this.executor = Stack.sharedExecutor();
        }
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = Stack.sharedScheduledExecutor();
        }
        if (this.eventLoop == null) {
            this.eventLoop = Stack.sharedEventLoop();
        }
        if (this.wheelTimer == null) {
            this.wheelTimer = Stack.sharedWheelTimer();
        }
        return new OpcTcpClientTransportConfigImpl(this.connectTimeout, this.acknowledgeTimeout, this.channelLifetime, this.executor, this.scheduledExecutor, this.eventLoop, this.wheelTimer, this.bootstrapCustomizer, this.channelPipelineCustomizer);
    }

    static class OpcTcpClientTransportConfigImpl
    implements OpcTcpClientTransportConfig {
        private final UInteger connectTimeout;
        private final UInteger acknowledgeTimeout;
        private final UInteger channelLifetime;
        private final ExecutorService executor;
        private final ScheduledExecutorService scheduledExecutor;
        private final EventLoopGroup eventLoop;
        private final HashedWheelTimer wheelTimer;
        private final Consumer<Bootstrap> bootstrapCustomizer;
        private final Consumer<ChannelPipeline> channelPipelineCustomizer;

        public OpcTcpClientTransportConfigImpl(UInteger connectTimeout, UInteger acknowledgeTimeout, UInteger channelLifetime, ExecutorService executor, ScheduledExecutorService scheduledExecutor, EventLoopGroup eventLoop, HashedWheelTimer wheelTimer, Consumer<Bootstrap> bootstrapCustomizer, Consumer<ChannelPipeline> channelPipelineCustomizer) {
            this.connectTimeout = connectTimeout;
            this.acknowledgeTimeout = acknowledgeTimeout;
            this.channelLifetime = channelLifetime;
            this.executor = executor;
            this.scheduledExecutor = scheduledExecutor;
            this.eventLoop = eventLoop;
            this.wheelTimer = wheelTimer;
            this.bootstrapCustomizer = bootstrapCustomizer;
            this.channelPipelineCustomizer = channelPipelineCustomizer;
        }

        @Override
        public UInteger getConnectTimeout() {
            return this.connectTimeout;
        }

        @Override
        public UInteger getAcknowledgeTimeout() {
            return this.acknowledgeTimeout;
        }

        @Override
        public UInteger getChannelLifetime() {
            return this.channelLifetime;
        }

        @Override
        public ExecutorService getExecutor() {
            return this.executor;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutor() {
            return this.scheduledExecutor;
        }

        @Override
        public EventLoopGroup getEventLoop() {
            return this.eventLoop;
        }

        @Override
        public HashedWheelTimer getWheelTimer() {
            return this.wheelTimer;
        }

        @Override
        public Consumer<Bootstrap> getBootstrapCustomizer() {
            return this.bootstrapCustomizer;
        }

        @Override
        public Consumer<ChannelPipeline> getChannelPipelineCustomizer() {
            return this.channelPipelineCustomizer;
        }
    }
}

