/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.transport.server.uasc;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.channel.ExceptionHandler;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.AcknowledgeMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.HelloMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageEncoder;
import org.eclipse.milo.opcua.stack.core.transport.TransportProfile;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.transport.server.ServerApplicationContext;
import org.eclipse.milo.opcua.stack.transport.server.uasc.UascServerAsymmetricHandler;
import org.eclipse.milo.opcua.stack.transport.server.uasc.UascServerConfig;
import org.eclipse.milo.shaded.com.google.common.primitives.Ints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UascServerHelloHandler
extends ByteToMessageDecoder
implements HeaderDecoder {
    static final AttributeKey<String> ENDPOINT_URL_KEY = AttributeKey.valueOf((String)"endpoint-url");
    public static final AtomicLong CUMULATIVE_DEADLINES_MISSED = new AtomicLong(0L);
    private static final int MAX_HELLO_MESSAGE_SIZE = 4128;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private volatile boolean receivedHello = false;
    private final UascServerConfig config;
    private final ServerApplicationContext application;
    private final TransportProfile transportProfile;

    public UascServerHelloHandler(UascServerConfig config, ServerApplicationContext application, TransportProfile transportProfile) {
        if (transportProfile != TransportProfile.TCP_UASC_UABINARY && transportProfile != TransportProfile.WSS_UASC_UABINARY) {
            throw new IllegalArgumentException("transportProfile: " + String.valueOf(transportProfile));
        }
        this.config = config;
        this.application = application;
        this.transportProfile = transportProfile;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        int helloDeadlineMs = this.config.getHelloDeadline().intValue();
        this.logger.debug("Scheduling Hello deadline for +{}ms", (Object)helloDeadlineMs);
        ctx.executor().schedule(() -> {
            if (!this.receivedHello) {
                long cumulativeDeadlinesMissed = CUMULATIVE_DEADLINES_MISSED.incrementAndGet();
                this.logger.debug("No Hello received after {}ms; closing channel. cumulativeDeadlinesMissed={}", (Object)helloDeadlineMs, (Object)cumulativeDeadlinesMissed);
                ctx.close();
            }
        }, (long)helloDeadlineMs, TimeUnit.MILLISECONDS);
        super.channelActive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            ctx.close();
            this.logger.debug("[remote={}] IOException caught; channel closed", (Object)ctx.channel().remoteAddress(), (Object)cause);
        } else {
            ErrorMessage errorMessage = ExceptionHandler.sendErrorMessage((ChannelHandlerContext)ctx, (Throwable)cause);
            if (cause instanceof UaException) {
                this.logger.debug("[remote={}] UaException caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            } else {
                this.logger.error("[remote={}] Exception caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            }
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.readableBytes() >= 8) {
            int messageLength = this.getMessageLength(buffer, 4128);
            if (buffer.readableBytes() >= messageLength) {
                MessageType messageType = MessageType.fromMediumInt((int)buffer.getMediumLE(buffer.readerIndex()));
                if (messageType == MessageType.Hello) {
                    this.onHello(ctx, buffer.readSlice(messageLength));
                } else {
                    throw new UaException(2155741184L, "unexpected MessageType: " + String.valueOf(messageType));
                }
            }
        }
    }

    private void onHello(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        boolean endpointMatch;
        this.logger.debug("[remote={}] Received Hello message.", (Object)ctx.channel().remoteAddress());
        this.receivedHello = true;
        HelloMessage hello = TcpMessageDecoder.decodeHello((ByteBuf)buffer);
        String endpointUrl = hello.getEndpointUrl();
        boolean bl = endpointMatch = endpointUrl != null && this.application.getEndpointDescriptions().stream().anyMatch(endpoint -> Objects.equals(EndpointUtil.getPath((String)endpointUrl), EndpointUtil.getPath((String)endpoint.getEndpointUrl())));
        if (!endpointMatch) {
            throw new UaException(0x80830000L, "unrecognized endpoint url: " + endpointUrl);
        }
        ctx.channel().attr(ENDPOINT_URL_KEY).set((Object)endpointUrl);
        long remoteProtocolVersion = hello.getProtocolVersion();
        long remoteReceiveBufferSize = hello.getReceiveBufferSize();
        long remoteSendBufferSize = hello.getSendBufferSize();
        long remoteMaxMessageSize = hello.getMaxMessageSize();
        long remoteMaxChunkCount = hello.getMaxChunkCount();
        if (remoteProtocolVersion < 0L) {
            throw new UaException(2159935488L, "unsupported protocol version: " + remoteProtocolVersion);
        }
        EncodingLimits encodingLimits = this.application.getEncodingContext().getEncodingLimits();
        long localReceiveBufferSize = Math.min(remoteSendBufferSize, (long)encodingLimits.getMaxChunkSize());
        long localSendBufferSize = Math.min(remoteReceiveBufferSize, (long)encodingLimits.getMaxChunkSize());
        long localMaxChunkCount = encodingLimits.getMaxChunkCount();
        long localMaxMessageSize = Math.min(localReceiveBufferSize * localMaxChunkCount, (long)encodingLimits.getMaxMessageSize());
        ChannelParameters channelParameters = new ChannelParameters(Ints.saturatedCast((long)localMaxMessageSize), Ints.saturatedCast((long)localReceiveBufferSize), Ints.saturatedCast((long)localSendBufferSize), Ints.saturatedCast((long)localMaxChunkCount), Ints.saturatedCast((long)remoteMaxMessageSize), Ints.saturatedCast((long)remoteReceiveBufferSize), Ints.saturatedCast((long)remoteSendBufferSize), Ints.saturatedCast((long)remoteMaxChunkCount));
        UascServerAsymmetricHandler asymmetricHandler = new UascServerAsymmetricHandler(this.config, this.application, this.transportProfile, channelParameters);
        ctx.pipeline().addLast(new ChannelHandler[]{asymmetricHandler});
        ctx.pipeline().remove((ChannelHandler)this);
        this.logger.debug("[remote={}] Removed HelloHandler, added AsymmetricHandler.", (Object)ctx.channel().remoteAddress());
        AcknowledgeMessage acknowledge = new AcknowledgeMessage(0L, localReceiveBufferSize, localSendBufferSize, localMaxMessageSize, localMaxChunkCount);
        ByteBuf messageBuffer = TcpMessageEncoder.encode((AcknowledgeMessage)acknowledge);
        ctx.executor().execute(() -> ctx.writeAndFlush((Object)messageBuffer));
        this.logger.debug("[remote={}] Sent Acknowledge message.", (Object)ctx.channel().remoteAddress());
    }
}

